#!/bin/sh

DIR=/nmt/apps

install()
{
    if [ -d $DIR ];then
        cd $DIR/server;./clutch stop
        cd /share/.transmission
        cat settings.json |sed 's|"umask":.*|"umask": 0,|' > settings.json.tmp && mv settings.json.tmp settings.json
        killall btpd_monitor
        cd $DIR/bin
        mv -f transmission-daemon transmission-daemon.org
        mv -f transmission-remote transmission-remote.org
        cd $DIR
        if [ -d "clutch5" ];then
            mv clutch5 clutch5.org
        fi
        tar xvf /share/Apps/Transmission/nmt-transmission.tar
        cd $DIR/server
        mv clutch clutch.org
        cat clutch.org|sed 's|umask 0000|umask 0000\n\t# Kernel optimalizations\n\techo 4194304 > /proc/sys/net/core/rmem_max\n\techo 1048576 > /proc/sys/net/core/wmem_max\n\techo "16384 87380 87380" > /proc/sys/net/ipv4/tcp_rmem\n\n\t# Fix for urandom dev\n\tchmod 666 /dev/random\n\tchmod 777 /dev/urandom\n|g' > clutch
        chmod 777 clutch
        ./clutch start
    else
        exit 1
    fi
}

uninstall()
{
    if [ -d $DIR ];then
        cd $DIR/server;./clutch stop
        killall btpd_monitor
        cd $DIR/bin
        mv -f transmission-daemon.org transmission-daemon
        mv -f transmission-remote.org transmission-remote
        rm -rf lib
        cd $DIR
        if [ -d "clutch5.org" ];then
            rm -rf clutch5
            mv clutch5.org clutch5
        fi
        cd $DIR/server
        if [ -f "clutch.org" ];then
            mv -f clutch.org clutch
        fi
        ./clutch start
    else
        exit 1
    fi

}

case "$1" in
    install)
    install
    ;;

    uninstall)
    uninstall
    ;;
esac
