#!/bin/sh

is_nmt100() {
    [ -f /mnt/syb8634/MIN_FIRMWARE_VER ]
}
is_nmt200() {
    [ -f /nmt/apps/MIN_FIRMWARE_VER ] 
}

install()
{	
	if is_nmt200; then
		dir="/nmt/apps"
	elif is_nmt100; then
		dir="/mnt/syb8634"
	else 
		echo "Unknown NMT."
		exit 1
	fi

    if [ ! -f $dir/server/clutch_backup ]; then
    	mv $dir/server/clutch $dir/server/clutch_backup
    	echo "#!/bin/sh

/share/Apps/AppInit/appinit.cgi \$1 Transmission
" > $dir/server/clutch
	chmod a+x $dir/server/clutch
    fi
}

uninstall()
{
	if [ is_nmt200 ]; then
		dir="/nmt/apps"
	elif [ is_nmt100 ]; then
		dir="/mnt/syb8634"
	else 
		echo "Unknown NMT".
		exit 1;
	fi
	
    if [ -f $dir/server/clutch_backup ]; then
    	mv $dir/server/clutch_backup $dir/server/clutch
    fi
}


case "$1" in
    install)
    install
    ;;
    
    uninstall)
    uninstall
    ;;
esac
