<?php

/***************************************************************

	This file is part of Transmission Web/Gaya GUI
	File created by: Ger Teunis
	File updated by: Shurup <shurup@gmail.com>

	Transmission Web/Gaya GUI is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Transmission Web/Gaya GUI is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Transmission Web/Gaya GUI; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


****************************************************************/

function _error($_msg)
{
	global $globalinfo;

	$globalinfo["error_message"] = $_msg;
	require_once('templates/error.tmpl.php');
	exit(0);
}

function parseTorrentFiles($_torrent)
{
	$files = array();

	if( is_array($_torrent["files"]) ) $files = $_torrent["files"];

	foreach($files AS $key => $file)
	{
		$files[$key]["substrName"] = basename($files[$key]["name"]);

		$files[$key]["totalSize"]  = file_getLength($file)/1024;
		$files[$key]["totalSize"]  = $files[$key]["totalSize"]>999?number_format($files[$key]["totalSize"]/1024,1)."MB":number_format($files[$key]["totalSize"],1)."KB";

		$files[$key]["completed"]  = file_getBytesCompleted($file)/1024;
		$files[$key]["completed"]  = $files[$key]["completed"]>999?number_format($files[$key]["completed"]/1024,1)."MB":number_format($files[$key]["completed"],1)."KB";

		$files[$key]["wanted"]     = $_torrent["wanted"][$key];
		$files[$key]["priorities"] = $_torrent["priorities"][$key];
		$files[$key]["priorityName"] = file_getPriorityName($files[$key]["priorities"], $files[$key]["wanted"]);

		$files[$key]["percCompleted"] = round(file_getBytesCompleted($file)/file_getLength($file) * 100);
	}

	return $files;
}

function parseTorrentPeers($_torrent)
{
	$peers = array();

	if( is_array($_torrent["peers"]) ) $peers = $_torrent["peers"];

	foreach($peers AS $key => $peer)
	{
		$peers[$key]["rx"] = number_format(_isset($peer, 'rateToClient')/1024,1);
		$peers[$key]["tx"] = number_format(_isset($peer, 'rateToPeer')/1024,1);
	}

	return $peers;
}

function file_getPriorityName($p, $w){
	if( !$w ) return "skip";
	switch($p)
	{
		case 1: return "high"; break;
		case -1: return "low"; break;
		case 0: default: return "normal"; break;
	}
}

function file_getBytesCompleted($t) {
	return _isset($t, 'bytesCompleted', 0);
}

function file_getLength($t) {
	return _isset($t, 'length', 0);
}

function getStartupconfig()
{
	$globalinfo = array(
		'APP_NAME'      => 'Transmission',
		'APP_INI'       => '',
		'APP_RESTART'   => '',
		'APP_HOME'      => '',
		'scriptName'    => basename($_SERVER["SCRIPT_NAME"]),
		'scriptSetup'   => 'setup.php',
		'scriptIndex'   => 'index.php',
		'scriptOptions' => 'torrent_options.php',
		'scriptFiles'   => 'torrent_files.php',
		'scriptPeers'   => 'torrent_peers.php',
		'imgPath'       => 'file:///opt/sybhttpd/localhost.images/hd',
		'perPage'       => 4,
		'perPage2'      => 8,
		'totalup'       => 0,
		'totaldown'     => 0,
		'torrentId'     => 0,
		'refreshTime'   => 60,
		'page'          => 0,
		'page2'         => 0,
		'isGaya'        => is_numeric(stripos($_SERVER["HTTP_USER_AGENT"], "Syabas"))?true:false
		);

	if( !$globalinfo['isGaya'] )
	{
		$globalinfo['imgPath']  = 'images';
		$globalinfo['perPage']  = 20;
		$globalinfo['perPage2'] = 40;
	}

	return $globalinfo;
}

function parseSession($_setup)
{
	global $globalinfo;

	/*
	$arrTmp = file_exists($globalinfo["APP_INI"])?parse_ini_file($globalinfo["APP_INI"]):array();
	*/
	$session = array(
				"download-dir"     => $_setup["download-dir"],
				"peer-limit"       => max(0,$_setup["peer-limit"]),
				"port"             => $_setup["port"],
				"speed-limit-down" => tor_speedLimitDown($_setup),
				"speed-limit-up"   => tor_speedLimitUp($_setup),
				"ratio-limit"      => tor_ratioLimit($_setup),
				"version"          => $_setup["version"],
				"ini"              => ""
		);

	return $session;
}

function parseTorrent($_torrent, $_extended = false)
{
	$torrent = array(
		'id'            => tor_getId($_torrent),
		'name'          => tor_getName($_torrent),
		'status'        => tor_getStatus($_torrent),
		'totalSize'     => number_format(tor_getTotalSize($_torrent)/1024/1024,1),
		'completed'     => number_format(tor_getCompleted($_torrent)/1024/1024,1),
		'percCompleted' => number_format((tor_getCompleted($_torrent)/tor_getTotalSize($_torrent))*100,1),
		'rx'            => number_format(tor_getDownloadRate($_torrent)/1024,1),
		'tx'            => number_format(tor_getUploadRate($_torrent)/1024,1),
		//'peers'         => tor_getPeerCount($_torrent),
		'peers'         => tor_getConnectedPeerCount($_torrent),
		'avail'         => number_format(tor_getAvailable($_torrent),1),
		'ratio'         => number_format(tor_getRatio($_torrent), 2),
		'eta'           => tor_getEta($_torrent),
		'selected'      => false
		);

	if( $_extended )
	{
		$torrent['peersSendingToUs']   = tor_getSendingPeerCount($_torrent);
		$torrent['peersGettingFromUs'] = tor_getGettingPeerCount($_torrent);
		$torrent['maxConnectedPeers']  = tor_getMaxPeerCount($_torrent);
		$torrent['speed-limit-down']   = tor_speedLimitDown($_torrent);
		$torrent['speed-limit-up']     = tor_speedLimitUp($_torrent);
		$torrent['ratio-limit']        = tor_ratioLimit($_torrent);
	}

	$torrent['progress_done_width']    = ceil($torrent['percCompleted']);
	$torrent['progress_notdone_width'] = 100 - $torrent['progress_done_width'];

	if( $torrent['progress_done_width'] >= 100 )
	{
		$torrent['progress_left_border']   = 'progressGreen2LeftBorder.png';
		$torrent['progress_right_border']  = 'progressGreen2RightBorder.png';
		$torrent['progress_done_image']    = 'progressGreen2.png';
		$torrent['progress_notdone_image'] = 'progressLightGrey.png';
	}
	else
	{
		$torrent['progress_left_border']   = 'progressBlue2LeftBorder.png';
		$torrent['progress_right_border']  = 'progressDarkBlueRightBorder.png';
		$torrent['progress_done_image']    = 'progressBlue2.png';
		$torrent['progress_notdone_image'] = 'progressDarkBlue.png';
	}

	switch( $torrent['status'] )
	{
		case 'Downloading':
			$torrent['iconStatus'] = 'iconDownload.png';
			break;
		case 'Seeding':
			$torrent['iconStatus'] = 'iconUpload.png';
			break;
		case 'Stopped':
			$torrent['iconStatus'] = $torrent['progress_done_width'] >= 100 ? 'iconCompleted.png' : 'iconStopped.png';
			break;
		default:
			$torrent['iconStatus'] = 'iconUnknown.png';
			break;
	}

	return $torrent;
}

function parseSpeeds(&$_arr,&$torrents)
{
	if( !is_array($torrents) ) return;
	foreach( $torrents AS $oneTorrent )
	{
		$_arr['totaldown'] += tor_getDownloadRate($oneTorrent);
		$_arr['totalup'] += tor_getUploadRate($oneTorrent);
	}
}

function parseFreespace(&$_arr)
{
	exec(' df -h | grep -E \'HARD_DISK|SATA_DISK\' | awk \'{ print $4":"$5}\'', $output);
	list($_arr['freespace'], $_arr['usedspaceproc']) = explode(':', implode('',$output));
	$_arr['freespace'] = trim($_arr['freespace']);
	$_arr['usedspaceproc'] = 100 - intval(substr(trim($_arr['usedspaceproc']),0,-1));
}

function duration($seconds) {

	$years = floor($seconds/60/60/24/365);
	$days = floor($seconds/60/60/24)%365;
	$hours = $seconds/60/60%24;
	$mins = $seconds/60%60;
	$secs = $seconds%60;

        $duration='';

        if($years>0) {
        	$duration .= $years." years ".$days." days";
        } else {
        	if($days>0) {
        		$duration .= $days." days ".$hours." hours";
        	} else {
        		if ($hours > 0) {
        			$duration .= $hours."hours ".$mins." minutes";
        		} else {
        			if ($mins > 0) {
        				$duration .= $mins." minutes ".$secs." seconds";
        			} else {
        				$duration .= $secs." seconds";
        			}

        		}
		}
        }

        if($secs<0) $duration = '-';

	return $duration;
}

function parse_torrent_list($_list) {
	$list = array();
	if( !is_array($_list) ) $_list = array();

	foreach( $_list AS $i )
	{
		if( !is_numeric($i) ) continue;
		$list[] = intval($i);
	}
	return $list;
}

function _isset($t, $key, $no = -1) {
	return isset($t[$key]) ? $t[$key] : $no;
}

function has_flag($flags, $flag_check) {
        return(($flags & $flag_check) == $flag_check);
}

function tor_getId($t) {
	return _isset($t, 'id');
}

function tor_getName($t) {
	return _isset($t, 'name');
}


function tor_getStatus($t) {
	if(!isset($t['status']))
		return(-1);

	  $tr_torrent_status = array(0 => 'Torrent is stopped',
                             1 => 'Queued to check files',
                             2 => 'Checking files',
                             3 => 'Queued to download',
                             4 => 'Downloading',
                             5 => 'Queued to seed',
                             6 => 'Seeding'
  );

  if( array_key_exists($t['status'], $tr_torrent_status ) ) {
    return $tr_torrent_status[$t['status']];
  }
}

function tor_getTotalSize($t) {
	return _isset($t, 'totalSize', 0);
}

function tor_getCompleted($t) {
	if(isset($t['haveUnchecked'], $t['haveValid']))
		return ($t['haveUnchecked']+$t['haveValid']);
}

function tor_getDownloadRate($t) {
	return _isset($t, 'rateDownload');
}

function tor_getUploadRate($t) {
	return _isset($t, 'rateUpload');
}

function tor_getPeerCount($t) {
	return _isset($t, 'peersKnown');
}

function tor_getConnectedPeerCount($t) {
	return _isset($t, 'peersConnected');
}

function tor_getSendingPeerCount($t) {
	return _isset($t, 'peersSendingToUs');
}

function tor_getGettingPeerCount($t) {
	return _isset($t, 'peersGettingFromUs');
}

function tor_getMaxPeerCount($t) {
	return _isset($t, 'maxConnectedPeers');
}

function tor_speedLimitDown($t) {
	if( isset($t['speed-limit-down-enabled']) && $t['speed-limit-down-enabled'] ) return max(0,$t['speed-limit-down']);
	if( isset($t['downloadLimitMode']) && $t['downloadLimitMode'] == 1 ) return max(0,$t['downloadLimit']);
	return 0;
}

function tor_speedLimitUp($t) {
	if( isset($t['speed-limit-up-enabled']) && $t['speed-limit-up-enabled'] ) return max(0,$t['speed-limit-up']);
	if( isset($t['uploadLimitMode']) && $t['uploadLimitMode'] == 1 ) return max(0,$t['uploadLimit']);
	return 0;
}

function tor_ratioLimit($t) {
	if( isset($t['ratio-limit-enabled']) && $t['ratio-limit-enabled'] ) return max(0,doubleval($t['ratio-limit']));
	if( isset($t['seedRatioMode']) && $t['seedRatioMode'] == 1 ) return max(0,doubleval($t['seedRatioLimit']));
	return 0;
}

function tor_getAvailable($t) {
	if (isset($t['leftUntilDone']) && isset($t['desiredAvailable']) && $t['desiredAvailable']>0)
		return ($t['leftUntilDone']/$t['desiredAvailable'])*100;
		else
		return 'Unknown';
}

function tor_getRatio($t) {
	if(isset($t['uploadedEver'], $t['downloadedEver']))  {
		if($t['downloadedEver'] == 0)
			return 0;
		return $t['uploadedEver']/$t['downloadedEver'];
	} else
		return -1;
}

function tor_getUploaded($t) {
	return _isset($t, 'uploadedEver');
}

function tor_getProgress($t) {
	if(isset($t['sizeWhenDone'], $t['haveUnchecked'], $t['haveValid']))
	return((($t['haveUnchecked']+$t['haveValid'])/$t['sizeWhenDone'])*100);
}

function tor_getEta($t) {
	return _isset($t, 'eta');
}

function stat_getTorrentCount($s) {
	return _isset($s, 'torrentCount', 0);
}

?>