<?php
#!/mnt/syb8634/server/php5-cgi -d register_argc_argv=1
/***************************************************************

	This file is part of Transmission Web/Gaya GUI
	File created by: Shurup <shurup@gmail.com>

	Transmission Web/Gaya GUI is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Transmission Web/Gaya GUI is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Transmission Web/Gaya GUI; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


****************************************************************/

require_once('transmission-rpc.php');
require_once('utils.php');

//###########################################################
// Init
//###########################################################

$globalinfo = getStartupconfig();

$globalinfo["torrentId"] = intval(_isset($_REQUEST,"t",0));
$globalinfo['page'] = intval(_isset($_REQUEST,'pg',0));

$stdGetFields = array(
							"id",
							"name",             // tor_getName()
							"status",           // tor_getStatus()
							"uploadedEver",     // tor_getRatio()
							"downloadedEver",   // tor_getRatio()
							"totalSize",        // tor_getProgress(), tor_getTotalSize()
							"haveUnchecked",    // tor_getProgress(), tor_getCompleted()
							"haveValid",        // tor_getProgress(), tor_getCompleted()
							"rateUpload",       // tor_getUploadRate()
							"rateDownload",     // tor_getDownloadRate()
							"peersKnown",       // tor_getPeerCount()
							"peersConnected",   // tor_getConnectedPeerCount()
							"desiredAvailable", // tor_getAvailable()
							"leftUntilDone",    // tor_getAvailable()
							"eta",              // tor_getEta()
							"peersSendingToUs",         // tor_getSendingPeerCount()
							"peersGettingFromUs",       // tor_getGettingPeerCount()
							"maxConnectedPeers",        // tor_getMaxPeerCount()
							"downloadLimitMode",
							"downloadLimit",
							"uploadLimitMode",
							"uploadLimit",
							"ratio-limit",              // tor_ratioLimit()
							"ratio-limit-enabled",      // tor_ratioLimit()
							"speed-limit-down",         // tor_speedLimitDown()
							"speed-limit-down-enabled", // tor_speedLimitDown()
							"speed-limit-up",           // tor_speedLimitUp()
							"speed-limit-up-enabled",   // tor_speedLimitUp()
						);

//###########################################################
// Actions
//###########################################################

if( isset($_REQUEST['list']) ) // Received a command
{
	$tor_IdList = parse_torrent_list($_REQUEST['list']);
	if(isset($_REQUEST['action-delete']))
	{
		tr_torrentRemove($tor_IdList);
		Header("Location: ".$globalinfo["scriptIndex"]."?t=".$globalinfo["torrentId"]."&pg=".$globalinfo["page"]);
		exit;
	}
	else if(isset($_REQUEST['action-start'])) tr_torrentStart($tor_IdList);
	else if(isset($_REQUEST['action-stop']))  tr_torrentStop($tor_IdList);
	else if(isset($_REQUEST['action-save']))
	{
		//Init
		$stdSetFields = array();

		//DL rate
		$stdSetFields["speed-limit-down"] = intval($_REQUEST["fDlRate"]);
		$stdSetFields["speed-limit-down-enabled"] = $stdSetFields["speed-limit-down"]?true:false;

		//UL rate
		$stdSetFields["speed-limit-up"] = intval($_REQUEST["fUlRate"]);
		$stdSetFields["speed-limit-up-enabled"] = $stdSetFields["speed-limit-up"]?true:false;

		//Ratio limit
		$stdSetFields["ratio-limit"] = doubleval($_REQUEST["fRatio"]);
		$stdSetFields["ratio-limit-enabled"] = $stdSetFields["ratio-limit"]?1:0;

		//Max connections
		$stdSetFields["peer-limit"] = intval($_REQUEST["fMaxConnections"]);

		$result = tr_torrentMutator($stdSetFields, $tor_IdList);
	}

	Header("Location: ".$globalinfo["scriptName"]."?t=".$globalinfo["torrentId"]."&pg=".$globalinfo["page"]);
	exit;
}

//###########################################################
// Interface
//###########################################################

// Free Space info
parseFreespace($globalinfo);

//Stats
$globalinfo['stats'] = tr_sessionStats();

//if we requested torrent info
//Torrent info
$torrents = tr_torrentAccessor($stdGetFields, array($globalinfo["torrentId"]));
if( !$torrents) _error("Torrent not found or deleted");
if( !is_array($torrents) ) $torrents = array();

//Speed info
parseSpeeds($globalinfo,$torrents);

require_once('templates/torrent_options.tmpl.php');

exit(0);
?>