<?php
#!/mnt/syb8634/server/php5-cgi -d register_argc_argv=1
/***************************************************************

	This file is part of Transmission Web/Gaya GUI
	File created by: Shurup <shurup@gmail.com>

	Transmission Web/Gaya GUI is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Transmission Web/Gaya GUI is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Transmission Web/Gaya GUI; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


****************************************************************/

require_once('transmission-rpc.php');
require_once('utils.php');

//###########################################################
// Init
//###########################################################

$globalinfo = getStartupconfig();
$globalinfo["torrentId"] = intval(_isset($_REQUEST,"t",0));
$globalinfo['page']  = intval(_isset($_REQUEST,'pg',0));
$globalinfo['page2'] = intval(_isset($_REQUEST,'pg2',0));
$globalinfo['refreshTime'] = 0;

$stdGetFields = array(
							"id",
							"name",             // tor_getName()
							"status",           // tor_getStatus()
							"uploadedEver",     // tor_getRatio()
							"downloadedEver",   // tor_getRatio()
							"totalSize",        // tor_getProgress(), tor_getTotalSize()
							"haveUnchecked",    // tor_getProgress(), tor_getCompleted()
							"haveValid",        // tor_getProgress(), tor_getCompleted()
							"rateUpload",       // tor_getUploadRate()
							"rateDownload",     // tor_getDownloadRate()
							"peersKnown",       // tor_getPeerCount()
							"peersConnected",   // tor_getConnectedPeerCount()
							"desiredAvailable", // tor_getAvailable()
							"leftUntilDone",    // tor_getAvailable()
							"eta",              // tor_getEta()
							"files",
							"wanted",
							"priorities"
						);

//###########################################################
// Actions
//###########################################################

if( isset($_REQUEST['list_files']) ) // Received a command
{
	//Init
	$stdSetFields = array();
	$skip_save = false;

	//Collect IDs
	$arrFiles = array();
	$arrTmp = $_REQUEST['list_files'];
	if( !is_array($arrTmp) ) $arrTmp = array($arrTmp);
	foreach($arrTmp AS $oneId) $arrFiles[] = intval($oneId);

	if( isset($_REQUEST['action-high']) )        $stdSetFields["priority-high"]   = $stdSetFields["files-wanted"] = $arrFiles;
	else if( isset($_REQUEST['action-normal']) ) $stdSetFields["priority-normal"] = $stdSetFields["files-wanted"] = $arrFiles;
	else if( isset($_REQUEST['action-low']) )    $stdSetFields["priority-low"]    = $stdSetFields["files-wanted"] = $arrFiles;
	else if( isset($_REQUEST['action-skip']) )   $stdSetFields["files-unwanted"]  = $arrFiles;
	else                                         $skip_save = true;

	if( !$skip_save ) $result = tr_torrentMutator($stdSetFields, array($globalinfo["torrentId"]));
}

//###########################################################
// Interface
//###########################################################

// Free Space info
parseFreespace($globalinfo);

//Stats
$globalinfo['stats'] = tr_sessionStats();

//Torrent info
$torrents = tr_torrentAccessor($stdGetFields, array($globalinfo["torrentId"]));
if( !$torrents) _error("Torrent not found");
if( !is_array($torrents) ) $torrents = array();

//Speed info
parseSpeeds($globalinfo,$torrents);

require_once('templates/torrent_files.tmpl.php');

exit(0);
?>