<?php
#!/mnt/syb8634/server/php5-cgi -d register_argc_argv=1
/***************************************************************

	This file is part of Transmission Web/Gaya GUI
	File created by: Ger Teunis
	File updated by: Shurup <shurup@gmail.com>

	Transmission Web/Gaya GUI is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Transmission Web/Gaya GUI is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Transmission Web/Gaya GUI; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


****************************************************************/

require_once('transmission-rpc.php');
require_once('utils.php');

//###########################################################
// Init
//###########################################################

$globalinfo = getStartupconfig();
$globalinfo['page'] = intval(_isset($_REQUEST,'pg',0));

$stdGetFields = array("id",
					"name",             // tor_getName()
					"status",           // tor_getStatus()
					"uploadedEver",     // tor_getRatio()
					"downloadedEver",   // tor_getRatio()
					"totalSize",        // tor_getProgress(), tor_getTotalSize()
					"haveUnchecked",    // tor_getProgress(), tor_getCompleted()
					"haveValid",        // tor_getProgress(), tor_getCompleted()
					"rateUpload",       // tor_getUploadRate()
					"rateDownload",     // tor_getDownloadRate()
					"peersKnown",       // tor_getPeerCount()
					"peersConnected",   // tor_getConnectedPeerCount()
					"desiredAvailable", // tor_getAvailable()
					"leftUntilDone",	// tor_getAvailable()
					"eta"               // tor_getEta()
				);

$stdGetFieldsFiles = array_merge($stdGetFields,array("files", "wanted", "priorities"));
$stdGetFieldsPeers = array_merge($stdGetFields,array("peers"));

//###########################################################
// Actions
//###########################################################

if( isset($_REQUEST['list']) ) // Received a command
{
	$tor_IdList = parse_torrent_list($_REQUEST['list']);
	if(isset($_REQUEST['action-delete']))     tr_torrentRemove($tor_IdList);
	else if(isset($_REQUEST['action-start'])) tr_torrentStart($tor_IdList);
	else if(isset($_REQUEST['action-stop']))  tr_torrentStop($tor_IdList);
	else if(isset($_REQUEST['action-save']))
	{
		//Init
		$stdSetFields = array();

		//DL rate
		$stdSetFields["speed-limit-down"] = intval($_REQUEST["fDlRate"]);
		$stdSetFields["speed-limit-down-enabled"] = $stdSetFields["speed-limit-down"]?true:false;

		//UL rate
		$stdSetFields["speed-limit-up"] = intval($_REQUEST["fUlRate"]);
		$stdSetFields["speed-limit-up-enabled"] = $stdSetFields["speed-limit-up"]?true:false;

		//Max connections
		$stdSetFields["peer-limit"] = intval($_REQUEST["fMaxConnections"]);

		$result = tr_torrentMutator($stdSetFields, $tor_IdList);
	}

	Header("Location: ".$globalinfo["scriptName"]."?t=".$globalinfo["torrentId"]."&pg=".$globalinfo["page"]);
	exit;
}
else if( isset($_REQUEST['action-delete-all']) )
{
	tr_torrentRemoveAll();
	Header("Location: ".$globalinfo["scriptName"]."?t=".$globalinfo["torrentId"]."&pg=".$globalinfo["page"]);
	exit;
}
else if( isset($_REQUEST['action-start-all']) )
{
	tr_torrentStartAll();
	Header("Location: ".$globalinfo["scriptName"]."?t=".$globalinfo["torrentId"]."&pg=".$globalinfo["page"]);
	exit;
}
else if( isset($_REQUEST['action-stop-all']) )
{
	tr_torrentStopAll();
	Header("Location: ".$globalinfo["scriptName"]."?t=".$globalinfo["torrentId"]."&pg=".$globalinfo["page"]);
	exit;
}
else if(isset($_REQUEST['action-upload']))
{
	if( !is_uploaded_file($_FILES['fFile']['tmp_name']) ) _error("Cannot find uploaded file.");
	
	$stdSetFields = array();
	$stdSetFields["paused"] = $_REQUEST["fAutoStart"]==1?false:true;

	$result = tr_torrentAdd($_FILES['fFile']['tmp_name'], $stdSetFields);
	
	Header("Location: ".$globalinfo["scriptName"]."?t=".$globalinfo["torrentId"]."&pg=".$globalinfo["page"]);
	exit;
}

//###########################################################
// Interface
//###########################################################

// Free Space info
parseFreespace($globalinfo);

//Stats
$globalinfo['stats'] = tr_sessionStats();

//Pagination
$globalinfo['actTor']   = stat_getTorrentCount($globalinfo['stats']);
$globalinfo['fromTor']  = $globalinfo['page'] * $globalinfo['perPage'] + 1;
if( $globalinfo['fromTor'] > $globalinfo['actTor'] ) $globalinfo['fromTor'] = $globalinfo['page'] = 0;
$globalinfo['toTor']    = $globalinfo['page'] * $globalinfo['perPage'] + $globalinfo['perPage'];
$globalinfo['nextpage'] = min(ceil($globalinfo['actTor']/$globalinfo['perPage']), $globalinfo['page']+1);
$globalinfo['prevpage'] = max(0, $globalinfo['page']-1);

if( $globalinfo['toTor'] > $globalinfo['actTor'] )  $globalinfo['toTor'] = $globalinfo['actTor'];
if( $globalinfo['toTor'] >= $globalinfo['actTor'] ) $globalinfo['nextpage'] = 0;

$globalinfo['torrenOfset'] = $globalinfo['page']?$globalinfo['page'] * $globalinfo['perPage']:0;

//Torrent info
$torrents = tr_torrentAccessor($stdGetFields);
if( !is_array($torrents) ) $torrents = array();

//Speed info
parseSpeeds($globalinfo,$torrents);

require_once('templates/index.tmpl.php');

exit(0);
?>