#!/bin/sh
DIR=/nmt/apps

install()
{
    if [ -d $DIR ];then
        cd $DIR/server;./clutch stop
        mv clutch clutch.org
        cp /share/Apps/Transmission-nmt/clutch.sh clutch
        chmod 777 clutch
        cd $DIR/bin
        mv transmission-daemon transmission-daemon.org
        mv transmission-remote transmission-remote.org
        killall btpd_monitor
        cd $DIR
        if [ -d "clutch5" ];then
            mv clutch5 clutch5.org
        fi
        tar xvf /share/Apps/Transmission-nmt/clutch.tar
        cd $DIR/server;./clutch start
    else
        exit 1
    fi
}

uninstall()
{
    if [ -d $DIR ];then
        cd $DIR/server;./clutch stop
        mv clutch.org clutch
        killall btpd_monitor
        cd $DIR
        if [ -d "clutch5.org" ];then
            rm -rf clutch5
            mv clutch5.org clutch5
        fi
        cd $DIR/bin
        mv transmission-daemon.org transmission-daemon
        mv transmission-remote.org transmission-remote
        cd $DIR/server;./clutch start
    else
        exit 1
    fi
}

case "$1" in
    install)
    install
    ;;
    
    uninstall)
    uninstall
    ;;
esac
