#!/bin/sh
#Set Paths
PATH=$PATH:/bin:/usr/local/bin:/share/Apps/local/bin:/share/Apps/local/libexec/git-core:/nmt/apps/bin;export PATH
LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/lib:/opt/syb/app/lib:/nmt/app/lib:/opt/syb/sigma/lib:/usr/local/bin:/share/Apps/local/lib;export LD_LIBRARY_PATH
MANPATH=$MANPATH:/usr/local/share/man:/share/Apps/local/share/man;export MANPATH
HERE=""
# Package
if [ -f /opt/sybhttpd/localhost.drives/SATA_DISK/start_app.sh ]; then
	HERE="SATA_DISK"
elif [ -f /opt/sybhttpd/localhost.drives/USB_DRIVE/start_app.sh ]; then
	HERE="USB_DRIVE"
elif [ -f /opt/sybhttpd/localhost.drives/USB_DRIVE_SD_CARD/start_app.sh ]; then
	HERE="USB_DRIVE_SD_CARD"
else
	HERE="HARD_DISK"
fi
LOCAL_DIR=/share/Apps/local
cd /usr
if [ -d "local" ]; then
	mv ./local ./local.org
	ln -s ${LOCAL_DIR} .
fi

# Package
PACKAGE="sickrage"
DNAME="sickrage"

# Others
INSTALL_DIR="/share/Apps/${PACKAGE}"
RUNAS="root"
PYTHON="python2.7"
PID_FILE="/var/sickrage.pid"
SICKRAGE="${INSTALL_DIR}/SickBeard.py "
LOG_FILE="${INSTALL_DIR}/Logs/sickrage.log"

force_sickrage()
{
   chmod -R 777 /share/Apps/sickrage
   mkdir /share/tmp
   cd /share/tmp
   git clone git://github.com/echel0n/SickRage.git SB
   cp -Ra SB/. /share/Apps/sickrage
   chmod -R 777 /share/Apps/sickrage
   cd
   rm -Rf /share/tmp
}

force_all()
{
opkg update
opkg install python2.7 --force-depends --force-overwrite 
opkg install git -force-depends -force-overwrite
opkg install g++-4.4 -force-depends -force-overwrite
opkg install gcc-4.4 -force-depends -force-overwrite
opkg install expat -force-depends -force-overwrite
opkg install zlib1-dev -force-depends -force-overwrite
wget http://peak.telecommunity.com/dist/ez_setup.py
/share/Apps/local/bin/python2.7 ez_setup.py
easy_install setuptools
rm -r ez_setup.py
easy_install Cheetah
}

start_daemon()
{
# start sickrage
eval "/usr/local/bin/python2.7 /opt/sybhttpd/localhost.drives/${HERE}/Apps/sickrage/SickBeard.py -q --daemon --pidfile=/var/sickrage.pid" &
chmod -R 777 /share/Apps/sickrage
} 

daemon_status()
{
    if [ -f ${PID_FILE} ] && [ -d /proc/`cat ${PID_FILE}` ]; then
return 0
    fi
return 1
}

wait_for_status()
{
    counter=$2
    while [ ${counter} <> 0 ]; do
daemon_status
        [ $? -eq $1 ] && break
let counter=counter-1
        sleep 1
    done
}

stop_daemon()
{
# Stop sickrage

    kill `cat ${PID_FILE}`
    wait_for_status 1 20
    rm -f ${PID_FILE}
}

#Main
case $1 in
    start)
        if daemon_status; then
echo ${DNAME} is already running
        else
echo Starting ${DNAME} ...
            start_daemon
        fi
        ;;
    stop)
        if daemon_status; then
echo Stopping ${DNAME} ...
            stop_daemon
        else
echo ${DNAME} is not running
        fi
        ;;
    status)
        if daemon_status; then
echo ${DNAME} is running
            exit 0
        else
echo ${DNAME} is not running
            exit 1
        fi
        ;;
    log)
        echo ${LOG_FILE}
        ;;
    *)
        exit 1
        ;;
esac