#!/bin/sh

echo "Content-Type: text/html"
echo ""

RCLONE_VER=`/share/Apps/rclone/bin/rclone --version 2>&- |cut -d' ' -f2`

cat << EOM1
<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->

EOM1

echo "	<title>Rclone web config</title>"

cat << EOM2

	<!-- Bootstrap core CSS -->
	<link href="../rclone_web/css/bootstrap.min.css" rel="stylesheet">
	<!-- Bootstrap theme -->
	<link href="../rclone_web/css/bootstrap-theme.min.css" rel="stylesheet">
	<!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->
	<link href="../rclone_web/css/ie10-viewport-bug-workaround.css" rel="stylesheet">
	<!-- Custom styles for this template -->
	<link href="../rclone_web/css/navbar.css" rel="stylesheet">

</head>

<body>

	<div class="container">

		<!-- Static navbar -->
		<nav class="navbar navbar-inverse">
			<div class="container-fluid">
				<div class="navbar-header">
					<button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
						<span class="sr-only">Toggle navigation</span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
					</button>
EOM2

echo "					<a class="navbar-brand">Rclone web config</a>"

cat << EOM3
				</div>
				<div id="navbar" class="navbar-collapse collapse">
					<ul class="nav navbar-nav">
						<li><a href="/cgi-bin/read_rclone_config.sh">Rclone Config</a></li>
						<li><a href="/cgi-bin/read_config.sh">Global Config</a></li>
						<li class="active"><a href="/cgi-bin/about.sh">About</a></li>
						<li><a href="/cgi-bin/reload.sh">Reload</a></li>
					</ul>
				</div><!--/.nav-collapse -->
			</div><!--/.container-fluid -->
		</nav>

		<!-- Main component for a primary marketing message or call to action -->
		<div class="page-header">
			<h1>About rclone</h1>
		</div>
		
		<p>Rclone is a command line program to sync files and directories to and from</p>
		<ul>
			<li>Google Drive</li>
			<li>Amazon S3</li>
			<li>Openstack Swift / Rackspace cloud files / Memset Memstore</li>
			<li>Dropbox</li>
			<li>Google Cloud Storage</li>
			<li>Amazon Drive</li>
			<li>Microsoft OneDrive</li>
			<li>Hubic</li>
			<li>Backblaze B2</li>
			<li>Yandex Disk</li>
			<li>SFTP</li>
			<li>The local filesystem</li>
			
		</ul>
	
		<h2>Version</h2>
		<dl class="dl-horizontal">
			<dt>Application</dt>
EOM3

echo "          <dd>$RCLONE_VER</dd>"

cat << EOM6
			<dt>Web Interface by:</dt>
			<dd>vaidyasr</dd>
			<dt>Forum Help/Support:</dt>
			<dd><a href=http://www.networkedmediatank.com/showthread.php?tid=74321">Link</a></dd>
		</dl>
		
		<h2>More Information</h2>
		<a href="https://rclone.org/">https://rclone.org/</a>
			
	</div>

	<!-- Bootstrap core JavaScript
	================================================== -->
	<!-- Placed at the end of the document so the pages load faster -->
	<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
	<!--<script>window.jQuery || document.write('<script src="../rclone_web/js/vendor/jquery.min.js"><\/script>')</script>-->
	<script src="../rclone_web/js/bootstrap.min.js"></script>
	<!-- IE10 viewport hack for Surface/desktop Windows 8 bug -->
	<script src="../rclone_web/js/ie10-viewport-bug-workaround.js"></script>
</body>

</html>
EOM6
