#!/bin/sh
BUSYBOX="/bin/busybox"

install()
{
  if [ ! -d "~/.config" ];then
    mkdir ~/.config
  fi
  ln -s /share/Apps/rclone ~/.config/
}

uninstall()
{
  if [ -d "~/.config" ];then
    rm -rf ~/.config
  fi
}

install_busybox()
{
    if [ ! -f "/bin/busybox_org" ]; then
        $BUSYBOX cp /bin/busybox /bin/busybox_org
    fi
    
    if [ -f "/share/Apps/rclone/bin/busybox" ];then
        $BUSYBOX cp /share/Apps/rclone/bin/busybox /bin
        $BUSYBOX chmod a+x /bin/busybox
        $BUSYBOX --install
    
        #patches for backward compatibility
        #for NMT apps
        $BUSYBOX rm /bin/su
        $BUSYBOX ln -s /bin/busybox_org /bin/su
        $BUSYBOX rm /usr/bin/wget
    fi
}

remove_busybox()
{
    if [ -f "/bin/busybox_org" ]; then
        $BUSYBOX mv /bin/busybox_org /bin/busybox
    fi
    
    $BUSYBOX rm /bin/su
    $BUSYBOX ln -s /bin/busybox /bin/su
}


case "$1" in
    install)
    install_busybox
    install
    ;;
    
    uninstall)
    remove_busybox
    uninstall
    ;;
esac
