#!/bin/sh
RCLONE=/share/Apps/rclone/bin/rclone
CONF=/share/Apps/rclone/global.conf
BUSYBOX="/bin/busybox"

export PATH=/share/Apps/rclone/bin:$PATH

start_rclone()
{
NO_REMOTES=`cat $CONF|grep '^\['|wc -l`
if [ "$NO_REMOTES" -ne 0 ];then
  remotes=0
  while [ $remotes -ne $NO_REMOTES ]
  do
  remotes=`expr $remotes + 1`
  type=`cat $CONF|grep '^\['| head -$remotes|tail -1|sed 's|\[||g'|sed 's|\]||g'`
  lno=`cat $CONF|grep -n '^\['|grep $type |cut -d':' -f1`  
  mountpoint=`cat $CONF|head -$(expr $lno + 1) |tail -1|cut -d'=' -f2|sed 's| ||g'`
  remotename=`cat $CONF|head -$(expr $lno + 2) |tail -1|cut -d'=' -f2|sed 's| ||g'`
  already_mounted=`mount|grep fuse|grep "^$remotename:"|wc -l`
  if [ $already_mounted -eq 0 ];then 
    mkdir -p $mountpoint
    echo "Mounting $type in $mountpoint"
    $RCLONE mount $remotename: $mountpoint &
  else
    echo "Error: $type already mounted in $mountpoint, unmount first."
  fi
  done
else
  echo "Error: No remote has been configured."
  exit 1
fi
}

stop_rclone()
{
NO_REMOTES=`cat $CONF|grep '^\['|wc -l`
if [ "$NO_REMOTES" -ne 0 ];then
  remotes=0
  while [ $remotes -ne $NO_REMOTES ]
  do
  remotes=`expr $remotes + 1`
  type=`cat $CONF|grep '^\['| head -$remotes|tail -1|sed 's|\[||g'|sed 's|\]||g'`
  lno=`cat $CONF|grep -n '^\['|grep $type |cut -d':' -f1`  
  mountpoint=`cat $CONF|head -$(expr $lno + 1) |tail -1|cut -d'=' -f2|sed 's| ||g'`
  remotename=`cat $CONF|head -$(expr $lno + 2) |tail -1|cut -d'=' -f2|sed 's| ||g'`
  already_mounted=`mount|grep fuse|grep "^$remotename:"|wc -l`
  if [ $already_mounted -ne 0 ];then 
    echo "Un-Mounting $type in $mountpoint"
    umount $mountpoint
  else
    echo "Warning: $type already un-mounted."
  fi
  done
fi
}

install()
{
  if [ ! -d "~/.config" ];then
    mkdir ~/.config
  fi
  ln -s /share/Apps/rclone ~/.config/
}

uninstall()
{
  if [ -d "~/.config" ];then
    rm -rf ~/.config
  fi
}

install_busybox()
{
    if [ ! -f "/bin/busybox_org" ]; then
        $BUSYBOX cp /bin/busybox /bin/busybox_org
    fi
    
    if [ -f "/share/Apps/rclone/bin/busybox" ];then
        $BUSYBOX cp /share/Apps/rclone/bin/busybox /bin
        $BUSYBOX chmod a+x /bin/busybox
        $BUSYBOX --install
    
        #patches for backward compatibility
        #for NMT apps
        $BUSYBOX rm /bin/su
        $BUSYBOX ln -s /bin/busybox_org /bin/su
    fi
}

link_cgibin()
{
    if [ ! -L "/share/Apps/AppInit/websites/cgi-bin" ];then
      $BUSYBOX ln -s /share/Apps/rclone/web/cgi-bin /share/Apps/AppInit/websites/cgi-bin
    fi
}

remove_busybox()
{
    if [ -f "/bin/busybox_org" ]; then
        $BUSYBOX mv /bin/busybox_org /bin/busybox
    fi
    
    $BUSYBOX rm /bin/su
    $BUSYBOX ln -s /bin/busybox /bin/su
}

#Main
case "$1" in
    start)
    install_busybox;
    install
    start_rclone;
    link_cgibin;
    ;;

    stop)
    stop_rclone;
    uninstall
    remove_busybox;
    exit
    ;;

    restart)
    stop_rclone;
    sleep 2
    start_rclone;
    ;;
esac
