#!/bin/sh

if [ -d /opt/gaya ]; then
    DIR=/nmt/syb8634
else
    DIR=/nmt/apps
fi

install()
{
    if [ -d $DIR/server ];then
        cd $DIR/server
        if [ -f php-cgi ];then
            mv php-cgi php-cgi.old
        fi
        if [ -f php ];then
            mv php php.old
        fi
        if [ -f php.ini ];then
            mv php.ini php.ini.old
        fi
        cd $DIR
        tar xvf /share/Apps/php8-nmt/php8.tar
        cd $DIR/server
        ln -s php8-cgi php-cgi
        ln -s php8 php
        ln -s php8dbg phpdbg
        $DIR/server/php8 -i
    else
        exit 1
    fi
}

uninstall()
{
    if [ -d $DIR/server ];then
        cd $DIR/server
        rm -f php8-cgi php8 php8dbg phpdbg php php-cgi
        if [ -f php-cgi.old ];then
            mv php-cgi.old php-cgi
        fi
        if [ -f php.old ];then
            mv php.old php
        fi
        if [ -f php.ini.old ];then
            mv php.ini.old php.ini
        fi
        cd $DIR/etc;rm -rf php8
        cd $DIR/lib;rm -rf php8
    else
        exit 1
    fi

}

case "$1" in
    install)
    install
    ;;

    uninstall)
    uninstall
    ;;
esac
