#!/bin/sh

if [ -d /opt/gaya ]; then
    DIR=/nmt/syb8634
else
    DIR=/nmt/apps
fi

install()
{
    if [ -d $DIR/server ];then
        cd $DIR/server
        if [ -f php-cgi ];then
            mv php-cgi php-cgi.old
        fi
        if [ -f php ];then
            mv php php.old
        fi
        if [ -f php.ini ];then
            mv php.ini php.ini.old
        fi
        cd $DIR
        tar xvf /share/Apps/php7-nmt/php7.tar
        cd $DIR/server
        ln -s php7-cgi php-cgi
        ln -s php7 php
        ln -s php7dbg phpdbg
        $DIR/server/php7 -i
    else
        exit 1
    fi
}

uninstall()
{
    if [ -d $DIR/server ];then
        cd $DIR/server
        rm -f php7-cgi php7 php7dbg phpdbg php php-cgi
        if [ -f php-cgi.old ];then
            mv php-cgi.old php-cgi
        fi
        if [ -f php.old ];then
            mv php.old php
        fi
        if [ -f php.ini.old ];then
            mv php.ini.old php.ini
        fi
        cd $DIR/etc;rm -rf php7
        cd $DIR/lib;rm -rf php7
    else
        exit 1
    fi

}

case "$1" in
    install)
    install
    ;;

    uninstall)
    uninstall
    ;;
esac
