#!/bin/sh

if [ -d /opt/gaya ]; then
    DIR=/nmt/syb8634/server
else
    CHIPSET=`/opt/syb/sigma/bin/gbus_read_uint32 0x0002fee8 2>&-`
    if [ $CHIPSET = "0x00008647" -o $CHIPSET = "0x00008643" -o $CHIPSET = "0x00008911" ];then
        DIR=/nmt/apps/server
    fi
fi

install()
{
    if [ -d $DIR ];then
        cd $DIR
        if [ -f php5-cgi ];then
            mv php5-cgi php5-cgi.old
        fi
        if [ -f php.ini ];then
            mv php.ini php.ini.old
        fi
        if [ -f php ];then
            mv php php.old
        fi
        tar xvf /share/Apps/php5/php5.tar
    else
        exit 1
    fi
}

uninstall()
{
    if [ -d $DIR ];then
        cd $DIR
        if [ -f php5-cgi ];then
            mv php5-cgi.old php5-cgi
        fi
        if [ -f php.ini ];then
            mv php.ini.old php.ini
        fi
        if [ -f php ];then
            rm -f php
            mv php.old php
        fi
        rm -rf conf.d lib php5
    else
        exit 1
    fi

}

case "$1" in
    install)
    install
    ;;

    uninstall)
    uninstall
    ;;
esac
