<?php
// +-----------------------------------------------------------------------+
// |                                                                       |
// | THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS   |
// | "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT     |
// | LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR |
// | A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT  |
// | OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, |
// | SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT      |
// | LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, |
// | DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY |
// | THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT   |
// | (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE |
// | OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  |
// |                                                                       |
// +-----------------------------------------------------------------------+

include "functions.php";

if (isset($_GET['xml']) && $_GET['xml'] == 'getMovies') {
    //define variables from incoming values
    if (isset($_GET["start"]))
        $posStart = $_GET['start'];
    else
        $posStart = 0;

    if (isset($_GET["TYPE"]))
        $type = $_GET['TYPE'];
    else
        $type = "";

    if (isset($_GET["VALUE"]))
        $value = $_GET['VALUE'];
    else
        $value = "";

    if (isset($_GET["count"]))
        $count = $_GET['count'];
    else
        $count = 20;

    if (isset($_GET['filter']))
        $filter = $_GET['filter'];

    if (file_exists('oversight/index.db')) {
	$db = file('oversight/index.db');
        if ($type == 'Genre') {
            $genreid = getGenreID($value);
            $result = preg_grep("/_G	([^ ]\|?[^ ]\|?\b".$genreid."\b)/i", $db);
        }
        else if ($type == 'Cast') {
            $castid = getPeopleID($value);
            $result = preg_grep("/_A	(\d*,?\d*,?\d*,?\b".$castid."\b)/i", $db);
        }
        else if ($type == 'Director') {
            $castid = getPeopleID($value);
            $result = preg_grep("/_d	(\d*,?\d*,?\d*,?\b".$castid."\b)/i", $db);
        }
        else if ($type == 'Year') {
            $yearenc = dechex($value - 1900);
            $result = preg_grep("/_Y	".$yearenc."/i", $db);
        }
        else if ($type == 'Index') {
        }
        else if ($type == 'Certification') {
            $result = preg_grep("/_R	".$value."/i", $db);
        }
        else if ($type == 'Rating') {
            $result = preg_grep("/_R	M/i", $db);
        }
        else if ($type == 'filter') {
            $result1 = preg_grep("/_T	.*?".$filter."/i", $db);
            $result = preg_grep("/_s	.*?[,\t]/i", $result1, PREG_GREP_INVERT);
        }
        else if ($type == 'TV_Series') {
            $tvshow = preg_grep("/_C	T/i", $db);
            foreach($tvshow as $key => $value) {
                $row_data = explode("	", $value);
                for ($i=1;$i<count($row_data); $i = $i + 2) {
                    if (trim($row_data[$i]) == '_T')
                        $title[$key] = $row_data[$i + 1];
                }
            }
            $title = array_unique($title);
            foreach($title as $key => $value) {
                $result[$key] = $tvshow[$key];
            }
        }
        else if ($type == 'Boxset') {
            $boxset = preg_grep("/_a	themoviedb\:.*?[,\t]/i", $db);
            foreach($boxset as $key => $value) {
                $row_data = explode("	", $value);
                for ($i=1;$i<count($row_data); $i = $i + 2) {
                    if (trim($row_data[$i]) == '_a')
                        $title[$key] = $row_data[$i + 1];
                }
            }
            $title = array_unique($title);
            foreach($title as $key => $value) {
                $result[$key] = $boxset[$key];
            }
        }
        else if ($type == 'Movie') {
            $result = preg_grep("/_C	M/i", $db);
        }

        $ovdb = array_slice($result, $posStart, $count, true);
        foreach ($ovdb as $ovs)
            $ov_db[] = readOversightData($ovs);
	$rcount = 0;
	$dbcount = count($result);

	if ($dbcount > 0){
            print ("{\n");
            print (" pos:".$posStart.",\n");
            print (" data: [\n");

            foreach($ov_db as $nmj_data) {
                // Print XML
                $kcount = 0;
                print ("  {\n");
	        print("    total_count : ".$dbcount.",\n");
                foreach ($nmj_data as $key => $value) {
                    $kcount++;
                    if ($key == 'TITLE')
                        $value = htmlspecialchars_decode($value);
                    if ($value == '')
                        $value = "NULL";
                    if ($type == 'Boxset')
                        if ($key == 'THUMBNAIL')
                            $value = str_replace(".thumb.jpg", ".thumb.boxset.jpg", $value);

                    if ($type == 'Boxset')
                        if ($key == 'TITLE_TYPE')
                            $value = 3;

                    if ($kcount == count($nmj_data))
                        print('    "' . $key . '" : "' . $value . '"'."\n");
                    else
                        print('    "' . $key . '" : "' . $value . '"'.",\n");
                }
	        $rcount++; 
                if ($rcount == $count)
                    print ("  }\n");
                else
                    print ("  },\n");
            }
            print("]}\n");
        }
        else {
            print("{}\n");
        }
    }
    else {
        print("{ }\n");
    }
    // close the database connection
    $dbh = NULL;
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getSeasons') {
    $title = $_GET['title'];

    if (file_exists('oversight/index.db')) {
	$db = file('oversight/index.db');
        $result = preg_grep("/_T	\b".$title."\b[,\t]/", $db);
        $count = count($result);
        foreach ($result as $key => $value) {
            $row_data = explode("	", $value);
            for ($i=1;$i<count($row_data); $i = $i + 2) {
                if (trim($row_data[$i]) == '_s')
                    $seasons[$key] = $row_data[$i + 1];
            }
        }
        $seasons = array_unique($seasons);
        asort($seasons);
        foreach($seasons as $key => $value) {
            $season[$key] = $result[$key];
        }
        foreach ($season as $ovs)
            $ov_db[] = readOversightData($ovs);

        print ("[\n");
        $rcount=0;
        foreach ($ov_db as $rowdata) {
            $kcount=0;
            print ("  {\n");
            $rcount++;
            foreach ($rowdata as $key => $value) {
                $kcount++;
                if ($kcount == count($rowdata))
                    print('    "' . $key . '" : "' . $value . '"'."\n");
                else
                    print('    "' . $key . '" : "' . $value . '"'.",\n");
            }
            if ($rcount == $count)
                print ("  }\n");
            else
                print ("  },\n");
        }
        print ("]\n");
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getBoxset') {
    $boxid = $_GET['boxid'];

    if (file_exists('oversight/index.db')) {
	$db = file('oversight/index.db');
        $result = preg_grep("/_a	\b".$boxid."\b[,\t]/", $db);
        foreach ($result as $ovs)
            $ov_db[] = readOversightData($ovs);

        print ("[\n");
        $rcount=0;
        foreach ($ov_db as $rowdata) {
            $kcount=0;
            print ("  {\n");
            $rcount++;
            foreach ($rowdata as $key => $value) {
                $kcount++;
                if ($kcount == count($rowdata))
                    print('    "' . $key . '" : "' . $value . '"'."\n");
                else
                    print('    "' . $key . '" : "' . $value . '"'.",\n");
            }
            if ($rcount == $count)
                print ("  }\n");
            else
                print ("  },\n");
        }
        print ("]\n");
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getMovieDetails') {
    $ovsid = $_GET['ovsid'];
    $index = $_GET['INDEX'];

    if (file_exists($drivepath . 'oversight/index.db')) {
        $ov_data = loadOversightData($ovsid);

        print ("[\n");
        print ("  {\n");
        print('    "INDEX" : "' . $index . '"'.",\n");
$kcount = 0;
        foreach ($ov_data as $key => $value) {
$kcount++;
                if ($kcount == count($ov_data))
                    print('    "' . $key . '" : "' . $value . '"'."\n");
                else
                    print('    "' . $key . '" : "' . $value . '"'.",\n");
	}
    print ("  }\n");
    print ("]\n");
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getSeasonDetails') {
    $ovsid = $_GET['ovsid'];
    $title = $_GET['title'];
    $season = $_GET['season'];
    $index = $_GET['INDEX'];

    if (file_exists('oversight/index.db')) {
	$db = file('oversight/index.db');
        $result = preg_grep("/_T	\b".$title."\b[,\t]/", $db);
        $episodes = preg_grep("/_s	\b".$season."\b[,\t]/", $result);
        $count = count($episodes);
        $ov_db = loadOversightData($ovsid);

        print ("[\n");
        print ("  {\n");
        print('    "INDEX" : "' . $index . '"'.",\n");
        $kcount = 0;
        foreach ($ov_db as $key => $value) {
        $kcount++;
		if ($key == 'CONTENT')
                        $value = str_replace($remove, ' ', $value);
                print('    "' . $key . '" : "' . $value . '"'.",\n");
	}

        print ('    "episodes": ['."\n");

        $ecount = 0;
        foreach ($episodes as $ovs ){
            $ecount++;
            $episode = readOversightData($ovs);
            print ("    {\n");
            print ('      "EPISODE": "'.$episode['EPISODE'].'",'."\n");
            print ('      "TITLE": "'.$episode['EPISODE_TITLE'].'",'."\n");
            print ('      "SYNOPSIS": "'.getPlotData($episode['TTID'], $season, $episode['EPISODE']).'",'."\n");
            print ('      "RUNTIME": "'.$episode['RUNTIME'].':00",'."\n");
            print ('      "PATH": "'.$episode['PATH'].'"'."\n");
            if ($ecount == count($episodes))
                print ("    }\n");
            else
                print ("    },\n");
        }
    print ("    ]\n");
    print ("  }\n");
    print ("]\n");
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getMenu') {
    if (file_exists('oversight/index.db')) {
	$db = file('oversight/index.db');
        $mediapath = dirname(dirname($drivepath));

//include XML Header (as response will be in xml format)
        if (stristr($_SERVER["HTTP_ACCEPT"], "application/xhtml+xml")) {
            header("Content-type: application/xhtml+xml");
        } else {
            header("Content-type: text/xml");
        }
        print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        print ("<data>\n");

        $result1 = preg_grep("/_C	M/i", $db);
        $result2 = preg_grep("/_C	T/i", $db);
        $result = array_merge ($result1, $result2);
        if (count($result) > 0) {
            print ("    <item id='Video'><name>Video</name>\n");
            if (count($result1) > 0)
                print ("        <item id='Movie'><name>Movie</name></item>\n");
            if (count($result2) > 0)
                print ("        <item id='TV_Series'><name>TV Series</name></item>\n");
            print ("        <item id='Movie_Boxset'><name>Boxset</name></item>\n");

            print ("        <item id='Movie_Genre'><name>By Genre</name>\n");
            $all_genre = array();

            $all_data = file_get_contents("oversight/index.db");
            $result = preg_match_all("/_G	(.*?)[,\t]/i", $all_data, $matches);
            $output = array_unique(explode("|", implode("|", $matches[1])));
            
            foreach (getGenre($output) as $genre)
                print ("            <item id='" . $genre . "'><name>" . $genre . "</name></item>\n");
            print ("        </item>\n");

            print ("        <item id='Movie_Year'><name>By Year</name>\n");
            $result = preg_match_all("/_Y	(.*?)[,\t]/i", $all_data, $matches);
            $output = array_unique($matches[1]);
            foreach ($output as $year){
                $yr[] = hexdec($year)+1900;
            }
            asort($yr);
            foreach ($yr as $year) {
                print ("            <item id='" . $year . "'><name>" . $year . "</name></item>\n");
            }
            print ("        </item>\n");

            print ("        <item id='Movie_Certification'><name>By Certification</name>\n");
            $result = preg_match_all("/_R	(.*?)[,\t]/", $all_data, $matches);
            $output = array_unique($matches[1]);
            asort($output);
            foreach ($output as $mpaa)
                print ("            <item id='" . $mpaa . "'><name>" . $mpaa . "</name></item>\n");
            print ("        </item>\n");

            //print ("        <item id='Movie_Index'><name>By Index</name>\n");
            //$result = preg_match_all("/_T	(.*?)[,\t]/", $all_data, $matches);
            /*$sql = 'SELECT DISTINCT NAME FROM SHOW_GROUPS ORDER BY NAME';
            foreach ($dbh->query($sql) as $row) {
                print ("            <item id='" . $row['NAME'] . "'><name>" . $row['NAME'] . "</name></item>\n");
            }
            print ("        </item>\n");*/

            print ("        <item id='Movie_Rating'><name>By Rating</name>\n");
            print ("            <item id='10'><name><![CDATA[<img src='images/common_star_10.png'>]]></name></item>\n");
            print ("            <item id='9'><name><![CDATA[<img src='images/common_star_9.png'>]]></name></item>\n");
            print ("            <item id='8'><name><![CDATA[<img src='images/common_star_8.png'>]]></name></item>\n");
            print ("            <item id='7'><name><![CDATA[<img src='images/common_star_7.png'>]]></name></item>\n");
            print ("            <item id='6'><name><![CDATA[<img src='images/common_star_6.png'>]]></name></item>\n");
            print ("            <item id='5'><name><![CDATA[<img src='images/common_star_5.png'>]]></name></item>\n");
            print ("            <item id='4'><name><![CDATA[<img src='images/common_star_4.png'>]]></name></item>\n");
            print ("            <item id='3'><name><![CDATA[<img src='images/common_star_3.png'>]]></name></item>\n");
            print ("            <item id='2'><name><![CDATA[<img src='images/common_star_2.png'>]]></name></item>\n");
            print ("            <item id='1'><name><![CDATA[<img src='images/common_star_1.png'>]]></name></item>\n");
            print ("            <item id='0'><name><![CDATA[<img src='images/common_star_0.png'>]]></name></item>\n");
            print ("        </item>\n");
            print ("    </item>\n");
        }

        print ("    <item id='Remote Control'><name>Remote Control</name>\n");
        print ("    </item>\n");
        print ("    <item id='Now Playing'><name>Now Playing</name>\n");
        print ("    </item>\n");
        print ("</data>\n");
    }
}
else if (isset($_GET['xml']) && $_GET['xml'] == 'getImages') {
    if (isset($_GET['type']))
        $type = $_GET['type'];

if (isset($_GET["imdbid"]))
    $imdbid = $_GET["imdbid"];
else
    $imdbid = "tt0111257";

//include XML Header (as response will be in xml format)
if (stristr($_SERVER["HTTP_ACCEPT"], "application/xhtml+xml")) {
    header("Content-type: application/xhtml+xml");
} else {
    header("Content-type: text/xml");
}

print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");


if (isset($_GET["image"]))
    $image = str_replace("w1280","w300", $_GET['image']);
else {
    if ($type == "DETAIL_POSTER")
        $image = "images/poster.jpg";
    else
        $image = "images/no_wallpaper.jpg";
}

if ($type == 'DETAIL_POSTER')
    $text = 'Poster';
else if ($type == 'THUMBNAIL')
    $text = 'Thumbnail';
else if ($type == 'WALLPAPER')
    $text = 'Wallpaper';
$APIKEY = "b626260be86175272e48fa6347e58100";

$data = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://api.themoviedb.org/2.1/Movie.getImages/en/xml/" . $APIKEY . "/" . $imdbid . " -qO-");
$xml_parser = xml_parser_create();
xml_parse_into_struct($xml_parser, $data, $vals, $index);
xml_parser_free($xml_parser);
$i = 0;
$img_array[0] = $image;
foreach ($vals as $img_data) {
    if ($type == 'DETAIL_POSTER' || $type == 'THUMBNAIL') {
        if ($img_data['tag'] == 'IMAGE' && $img_data['attributes']['SIZE'] == 'cover')
            $img_array[++$i] = $img_data['attributes']['URL'];
    }
    else if ($type == 'WALLPAPER') {
        if ($img_data['tag'] == 'IMAGE' && $img_data['attributes']['SIZE'] == 'thumb' && $prev_tag['tag'] == 'BACKDROP')
            $img_array[++$i] = $img_data['attributes']['URL'];
    }
    $prev_tag = $img_data;
}
    print ("<data>\n");
    for ($j = 0; $j < count($img_array); $j++) {
        print("<item id ='".$j."'><image>" . $img_array[$j] . "</image></item>\n");
}
    print ("</data>\n");
}else if (isset($_GET['xml']) && $_GET['xml'] == 'playMedia') {
    if (isset($_GET['media']))
        $media = $_GET['media'];
    if (isset($_GET['type']))
        $type = $_GET['type'];
    if (isset($_GET['time']))
        $time = $_GET['time'];
    if ($time == 0)
        $time='';
    $host = trim(shell_exec("hostname"));
    $APIURL = '';
    if ($type == "movie") {
        $movies = explode("|", $media);
        if (count($movies) == 1) {
            $APIURL = " 'http://127.0.0.1:8008/playback?arg0=start_vod&arg1=MyMovieFile&arg2=".$movies[0]."&arg3=show&arg4=".$time."&arg5=0&arg6=disable' ";
        }
        else {
            for($h=0;$h<count($movies);$h++)
                $APIURL = $APIURL . " 'http://127.0.0.1:8008/playback?arg0=insert_vod_queue&arg1=MyMovieFile&arg2=".$movies[$h]."&arg3=show&arg4=' ";
        }
    }
    else {
        $music = explode("#", $media);
        if (count($music) == 1)
            $APIURL = " 'http://127.0.0.1:8008/playback?arg0=start_aod&arg1=MyAudioFile&arg2=".$music[0]."&arg3=show&arg4=disable' ";
        else {
            for($h=0;$h<count($music);$h++)
                $APIURL = $APIURL . " 'http://127.0.0.1:8008/playback?arg0=insert_aod_queue&arg1=MyAudioFile&arg2=".$music[$h]."&arg3=show' ";
        }
    }
    if ($host != "raspberrypi") {
        $current = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- 'http://127.0.0.1:8008/playback?arg0=stop_vod'");
        $current = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- 'http://127.0.0.1:8008/playback?arg0=stop_aod'");

        $url = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- ".$APIURL;
        $xml_data = shell_exec($url);
        $xml_parser = xml_parser_create();
        xml_parse_into_struct($xml_parser, $xml_data, $vals, $index);
        xml_parser_free($xml_parser);
        foreach ($vals as $drive_data) {
        if ($drive_data['tag'] == 'RETURNVALUE' && $drive_data['level'] == 2)
            $return_value = $drive_data['value'];
        }
    }
    else {
        $return_value = 0;
    }
print_r($return_value);
}
?>
