#!/bin/sh

LOCAL_DIR=/share/Apps/local

if [ -f "/bin/busybox" ];then
BUSYBOX="/bin/busybox"
elif [ -f "/bin/busybox_org" ];then
BUSYBOX="/bin/busybox_org"
fi

create_dir()
{
    cd /usr
    if [ -d "local" ]; then
        $BUSYBOX mv ./local ./local.org
        $BUSYBOX ln -s ${LOCAL_DIR} .
    fi
    echo "Done<br>"
    echo "Done<br>"
}

restore_dir()
{
    cd /usr
    if [ -L "local" ]; then
        $BUSYBOX rm local
    fi
    if [ -d local.org ];then
        $BUSYBOX mv ./local.org ./local
    fi
    echo "Done<br>"
}

set_uid()
{
    cd ${LOCAL_DIR}/bin
    $BUSYBOX chown root:root opkg
    $BUSYBOX chmod u+s opkg
}

start_init_d()
{
    if [ -d "${LOCAL_DIR}/etc/rc2.d" ];then
        cd ${LOCAL_DIR}/etc/rc2.d
        for script in `$BUSYBOX ls S*`
        do
            ./${script} start
        done

    fi
}

install_busybox()
{
    if [ ! -f "/bin/busybox_org" ]; then
        $BUSYBOX cp /bin/busybox /bin/busybox_org
    fi
    
    if [ -f "/share/Apps/local/bin/busybox" ];then
        $BUSYBOX cp /share/Apps/local/bin/busybox /bin
        $BUSYBOX chmod a+x /bin/busybox
        $BUSYBOX --install
    
        #patches for backward compatibility
        #for NMT apps
        $BUSYBOX rm /bin/su
        $BUSYBOX ln -s /bin/busybox_org /bin/su
        $BUSYBOX rm /usr/bin/wget
    fi
}

remove_busybox()
{
    if [ -f "/bin/busybox_org" ]; then
        $BUSYBOX mv /bin/busybox_org /bin/busybox
    fi
    
    $BUSYBOX rm /bin/su
    $BUSYBOX ln -s /bin/busybox /bin/su
}

disable_system_bin()
{
    for file in `$BUSYBOX ls /share/Apps/local/bin`
    do
        if [ "$file" != "busybox" ];then
            if [ -e "/bin/${file}" ];then
                $BUSYBOX mv /bin/${file} /bin/${file}.org
                $BUSYBOX ln -s /share/Apps/local/bin/${file} /bin/${file}
            fi
            if [ -e "/usr/bin/${file}" ];then
                $BUSYBOX mv /usr/bin/${file} /usr/bin/${file}.org
                $BUSYBOX ln -s /share/Apps/local/bin/${file} /usr/bin/${file}
            fi
        fi
    done
}

disable_system_sbin()
{
    for file in `$BUSYBOX ls /share/Apps/local/sbin`
    do
        if [ -e "/sbin/${file}" ];then
            $BUSYBOX mv /sbin/${file} /sbin/${file}.org
            $BUSYBOX ln -s /share/Apps/local/sbin/${file} /sbin/${file}
        fi
        if [ -e "/usr/sbin/${file}" ];then
            $BUSYBOX mv /usr/sbin/${file} /usr/sbin/${file}.org
            $BUSYBOX ln -s /share/Apps/local/sbin/${file} /usr/sbin/${file}
        fi
    done
}

enable_system_bin()
{
    for file in `$BUSYBOX ls /share/Apps/local/bin`
    do
        if [ -e "/bin/${file}.org" ];then
            $BUSYBOX mv /bin/${file}.org /bin/${file}
        fi
        if [ -e "/usr/bin/${file}.org" ];then
            $BUSYBOX mv /usr/bin/${file}.org /usr/bin/${file}
        fi
    done
}

enable_system_sbin()
{
    for file in `$BUSYBOX ls /share/Apps/local/sbin`
    do
        if [ -e "/sbin/${file}.org" ];then
            $BUSYBOX mv /sbin/${file}.org /sbin/${file}
        fi
        if [ -e "/usr/sbin/${file}.org" ];then
            $BUSYBOX mv /usr/sbin/${file}.org /usr/sbin/${file}
        fi
    done
}

link_webui()
{
    if [ -d "${LOCAL_DIR}/web" ];then
        cd ${LOCAL_DIR}/web
        for webui in `$BUSYBOX ls -1`
        do
            if [ ! -L /share/Apps/AppInit/websites/${webui}_web ];then
                $BUSYBOX ln -s ${LOCAL_DIR}/web/${webui} /share/Apps/AppInit/websites/${webui}_web
            fi
        done

    fi
}

stop_init_d()
{
    if [ -d "${LOCAL_DIR}/etc/rc2.d" ];then
        cd ${LOCAL_DIR}/etc/rc2.d
        for script in `$BUSYBOX ls K*`
        do
            ./${script} stop
        done
    fi
}

case "$1" in
    start)
    create_dir;
    set_uid;
    install_busybox;
    #disable_system_bin;
    #disable_system_sbin;
    link_webui;
    start_init_d;
    ;;
    
    stop)
    restore_dir;
    remove_busybox;
    #enable_system_bin;
    #enable_system_sbin;
    stop_init_d;
    exit
    ;;
    
    restart)
    stop
    sleep 2
    start
    ;;
esac
