#!/bin/sh

TEST=`cat /nmt/apps/VERSION`
NZB_LOCATION="/share/.nzbget"
CHIPSET=`/opt/syb/sigma/bin/gbus_read_uint32 0x0002fee8 2>&-`
NMTAPPS_LOCATION="/nmt/apps"

if [ $CHIPSET = "0x00008911" ];then
    test=`cat /nmt/apps/VERSION`
	if [ ${test:6:6} > "130707" ];then
		NZB_LOCATION="/share/.nzb"
	fi
elif [ $CHIPSET = "0x00008647" ];then
    test=`cat /nmt/apps/VERSION`
	if [ ${test:6:6} > "130707" ];then
		NZB_LOCATION="/share/.nzb"
	fi
elif [ $CHIPSET = "0x00008643" ];then
    test=`cat /nmt/apps/VERSION`
	if [ ${test:6:6} > "130707" ];then
		NZB_LOCATION="/share/.nzb"
	fi
elif [ $CHIPSET = "0x00008635" ];then
	NMTAPPS_LOCATION="/mnt/syb8634"
fi

case "$1" in
  start)
    
    if [ "`pflash get nzb`" == "0" ]; then
        pflash set nzb 1
    fi
    
    if [ -n "`ps | grep "/share/Apps/NZBget/bin/nzbget" | grep -v "grep"`" ]; then
        #trying to start it twice
        exit 0
    fi
    
    if [ -n "`ps | grep nzbget | grep -v "Apps" | grep -v "grep"`" ]; then
        $NMTAPPS_LOCATION/server/nzb stop
        
        i=0
        while [ -n "`ps | grep nzbget | grep -v "Apps" | grep -v "grep"`" ] && [ $i -le 5 ]; do
            i=$(( $i + 1 ))
            sleep 1
        done
        
        kill -9 `pidof nzbget` >/dev/null 2>/dev/null
        sleep 2
    fi
    
    chmod 777 /tmp
    echo -n "Start NZBGet : "

	#for upgrade: remove any current NZB or lock files
    if [ -d "/share/Apps/NZBget/.nzbget/nzb" ] && [ ! -h "/share/Apps/NZBget/.nzbget/nzb" ]; then
        cp -R /share/Apps/NZBget/.nzbget/nzb/* $NZB_LOCATION/nzb
    fi
        
    #for ln: make sure tmp and nzb folder is present
    if [ ! -d "$NZB_LOCATION/nzb" ]; then
        mkdir -p $NZB_LOCATION/nzb
        chown nmt.nmt $NZB_LOCATION/nzb
    fi
    if [ ! -d "$NZB_LOCATION/tmp" ]; then
        mkdir -p $NZB_LOCATION/tmp
        chown nmt.nmt $NZB_LOCATION/tmp
    fi
    
    #Create symbolic links to the old locations, for maximum compatibility
    if [ ! -d "/share/Apps/NZBget/.nzbget/nzb" ] || [ ! -h "/share/Apps/NZBget/.nzbget/nzb" ]; then
        rm -Rf /share/Apps/NZBget/.nzbget/nzb
        ln -s $NZB_LOCATION/nzb /share/Apps/NZBget/.nzbget/nzb
    fi
    if [ ! -d "/share/Apps/NZBget/.nzbget/tmp" ] || [ ! -h "/share/Apps/NZBget/.nzbget/tmp" ]; then
        rm -Rf /share/Apps/NZBget/.nzbget/tmp
        ln -s $NZB_LOCATION/tmp /share/Apps/NZBget/.nzbget/tmp
    fi

    if [ ! -e /share/Download ]; then
        mkdir -p /share/Download -m 777
    fi

    chmod a+r /dev/random
    chmod a+r /dev/urandom

    /share/Apps/NZBget/bin/nzbget -D -c /share/Apps/NZBget/.nzbget/nzbget.conf
    if [ "$?" = "0" ]; then
        echo "[  OK  ]"
        chmod 777 -R /share/Apps/NZBget/.nzbget
    else
        echo "[FAILED]"
    fi
    ;;
  stop)
    if [ "`pflash get nzb`" == "1" ]; then
        pflash set nzb 0
    fi
  
    echo -n "Stop NZBGet Daemon : "
    killall nzbget 1>/dev/null 2>/dev/null
    if [ "$?" = "0" ]; then echo "[  OK  ]";
    else                    echo "[FAILED]"; fi
    ;;
  quit)
    if [ "`pflash get nzb`" == "1" ]; then
        pflash set nzb 0
    fi
  
    echo -n "Stop NZBGet Daemon : "
    /share/Apps/NZBget/bin/nzbget -Q -c /share/Apps/NZBget/.nzbget/nzbget.conf 1>/dev/null 2>/dev/null
    if [ "$?" = "0" ]; then
        echo "[  OK  ]"
    else
        echo "[FAILED]"
    fi
    ;;
  *)
    echo "Usage: $0 {start|stop|quit}"
    exit 1
esac

exit 0
