#!/bin/sh

LOCAL=/share/Apps/local
OPKG=$LOCAL/bin/opkg
NAME=mono
EXENAME=nzbdrone
LD_LIBRARY_PATH=/share/Apps/local/lib:/usr/local/lib:/opt/syb/sigma/lib:/opt/syb/app/lib:/nmt/apps/lib:/lib;export LD_LIBRARY_PATH

install()
{	
    if [ -d /opt/gaya ]; then
        MODEL=a110
    else
        CHIPSET=`/opt/syb/sigma/bin/gbus_read_uint32 0x0002fee8 2>&-`
        if [ $CHIPSET = "0x00008911" ];then
            MODEL=a400
        elif [ $CHIPSET = "0x00008647" -o $CHIPSET = "0x00008643" ];then
            MODEL=c200
        fi
    fi

    if [ ! -f $OPKG ]; then
        cd /share
        wget -q http://sourceforge.net/projects/nmtcsi/files/opkg_${MODEL}_latest.zip
        unzip opkg_${MODEL}_latest.zip
        if [ -f opkg.tar ];then
            /share/Apps/AppInit/appinit.cgi install opkg.tar
            rm opkg.tar opkg_${MODEL}_latest.zip
        fi
    fi

    if [ -f $OPKG ];then
        if [ -f $LOCAL/bin/$NAME ];then
            $OPKG remove $EXENAME -force-depends -V0
        fi
        $OPKG update -V0
        $OPKG install $EXENAME -force-overwrite -force-reinstall -V0
    fi
}

case "$1" in
    install)
    install
    ;;
esac
