#!/bin/sh

INSTALL_ROOT=/share/Apps/local
BASEDIR=/share/Apps/NzbDrone
NAME=mono
PIDFILE=/var/run/nzbdrone.pid
DAEMON=$BASEDIR/bin/$NAME
EXE=NzbDrone.exe
DAEMON_ARGS=${INSTALL_ROOT}/opt/NzbDrone/$EXE

start()
{	
    if [ -n "`ps | grep "$DAEMON" | grep "$EXE" | grep -v 'grep'`" ]; then
        #don't start it twice
	    echo "NzbDrone already running"
        exit 0
    fi
    ${INSTALL_ROOT}/etc/init.d/nzbdrone start
    echo "NzbDrone started"
}

stop()
{	
    ${INSTALL_ROOT}/etc/init.d/nzbdrone stop
}

case "$1" in
	start)
	start
	;;

	stop)
	stop
	;;

	restart)
	stop
	sleep 1
	start
esac
