<?php
// +-----------------------------------------------------------------------+
// |                                                                       |
// | THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS   |
// | "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT     |
// | LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR |
// | A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT  |
// | OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, |
// | SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT      |
// | LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, |
// | DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY |
// | THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT   |
// | (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE |
// | OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  |
// |                                                                       |
// +-----------------------------------------------------------------------+

include "functions.php";

if (isset($_GET['xml']) && $_GET['xml'] == 'getMovies') {
//define variables from incoming values
    header("Access-Control-Allow-Origin: *");

    if (isset($_GET["start"]))
        $posStart = $_GET['start'];
    else
        $posStart = 0;

    if (isset($_GET['sortby']))
        $sortby = $_GET['sortby'];

    if (isset($_GET['filterby']))
        $filterby = $_GET['filterby'];

    if (isset($_GET['orderby']))
        $orderby = $_GET['orderby'];

    if (isset($_GET["TYPE"]))
        $type = $_GET['TYPE'];
    else
        $type = "";

    if (isset($_GET["VALUE"]))
        $value = $_GET['VALUE'];
    else
        $value = "";

    if (isset($_GET["count"]))
        $count = $_GET['count'];
    else
        $count = 20;

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];

    if (isset($_GET['filter']))
        $filter = $_GET['filter'];

    if (file_exists($drivepath)) {
        $mediapath = dirname(dirname($drivepath));
        $command = "cd /share/Apps/NMJManagerTablet/webui;ln -s " . $mediapath . " .";
        shell_exec($command);
        $dbh = new PDO('sqlite:' . $drivepath);

        if ($posStart == 0) {
            if ($type == 'Videos' || $type == 'TV Shows' || $type == 'Movies' || $type == 'Watched' || $type == 'Unwatched' || $type == "Favorites") {
                if ($filterby == 'Genre') {
                    $sql = 'SELECT COUNT(SHOWS_GENRES.SHOWS_ID) FROM VIDEO_GENRES,SHOWS_GENRES,SHOWS ';
                    if ($type == 'Favorites')
                        $sql .= ',FAVOURITES ';
                    else if ($type == "Watched" || $type == "Unwatched")
                        $sql .= ',SHOWS_VIDEOS,VIDEOS ';
                    $sql .= ' WHERE VIDEO_GENRES.NAME="' . $value . '" ';
                    $sql .= 'AND SHOWS_GENRES.GENRES_ID=VIDEO_GENRES.ID ';
                    if ($type == 'Favorites')
                        $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                    $sql .= ' AND SHOWS.ID=SHOWS_GENRES.SHOWS_ID ';
                    if ($type == 'Videos')
                        $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2) ';
                    else if ($type == 'TV Shows')
                        $sql .= 'AND SHOWS.TITLE_TYPE = 2 ';
                    else
                        $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                    if ($type == "Watched" || $type == "Unwatched") {
                        $sql .= 'AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                        $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                        if ($type == "Watched")
                            $sql .= 'VIDEOS.PLAY_COUNT > 0 ';
                        else
                            $sql .= 'VIDEOS.PLAY_COUNT = 0 ';
                    }
                } else if ($filterby == 'Director' || $filtertype == 'Cast') {
                    $sql = 'SELECT COUNT(SHOWS_PERSONS.SHOWS_ID),VIDEO_PERSONS.ID FROM ';
                    $sql .= 'SHOWS_PERSONS,VIDEO_PERSONS,SHOWS ';
                    if ($type == "Watched" || $type == "Unwatched")
                        $sql .= ',SHOWS_VIDEOS,VIDEOS ';
                    $sql .= ' WHERE VIDEO_PERSONS.NAME="' . str_replace("'", "&apos;", $value) . '" AND ';
                    $sql .= 'VIDEO_PERSONS.ID=SHOWS_PERSONS.PERSONS_ID ';
                    $sql .= 'AND SHOWS.ID=SHOWS_PERSONS.SHOWS_ID ';
                    if ($type == 'Videos')
                        $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2) AND ';
                    else if ($type == 'TV Shows')
                        $sql .= 'AND SHOWS.TITLE_TYPE = 2 AND ';
                    else
                        $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) AND ';
                    if ($type == "Watched" || $type == "Unwatched") {
                        $sql .= 'VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                        $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                        if ($type == "Watched")
                            $sql .= 'VIDEOS.PLAY_COUNT > 0 AND ';
                        else
                            $sql .= 'VIDEOS.PLAY_COUNT = 0 AND ';
                    }
                    if ($filterby == 'Director')
                        $sql .= 'SHOWS_PERSONS.PERSON_TYPE = "DIRECTOR"';
                    else if ($filterby == 'Cast')
                        $sql .= 'SHOWS_PERSONS.PERSON_TYPE = "CAST"';
                } else if ($filterby == 'Year') {
                    $sql = 'SELECT COUNT(SHOWS.ID) FROM SHOWS ';
                    if ($type == 'Favorites')
                        $sql .= ',FAVOURITES ';
                    else if ($type == "Watched" || $type == "Unwatched")
                        $sql .= ',SHOWS_VIDEOS,VIDEOS ';
                    $sql .= 'WHERE YEAR="' . $value . '"  ';
                    if ($type == 'Videos')
                        $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2) ';
                    else if ($type == 'TV Shows')
                        $sql .= 'AND SHOWS.TITLE_TYPE = 2 ';
                    else
                        $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                    if ($type == 'Favorites')
                        $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                    else if ($type == "Watched" || $type == "Unwatched") {
                        $sql .= 'AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                        $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                        if ($type == "Watched")
                            $sql .= 'VIDEOS.PLAY_COUNT > 0 ';
                        else
                            $sql .= 'VIDEOS.PLAY_COUNT = 0 ';
                    }
                } else if ($filterby == 'Index') {
                    $sql = 'SELECT COUNT(SHOW_GROUPS_SHOWS.ID) FROM ';
                    $sql .= 'SHOW_GROUPS_SHOWS,SHOW_GROUPS WHERE ';
                    $sql .= 'SHOW_GROUPS.NAME="' . $value . '" AND ';
                    $sql .= 'SHOW_GROUPS_SHOWS.GROUPS_ID=SHOW_GROUPS.ID';
                } else if ($filterby == 'Certification') {
                    if ($value == 'NR')
                        $value = '';
                    $sql = 'SELECT COUNT(SHOWS.ID) FROM SHOWS ';
                    if ($type == "Watched" || $type == "Unwatched")
                        $sql .= ',SHOWS_VIDEOS,VIDEOS ';
                    $sql .= 'WHERE PARENTAL_CONTROL="' . $value . '"  ';
                    if ($type == 'Videos')
                        $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2) ';
                    else if ($type == 'TV Shows')
                        $sql .= 'AND SHOWS.TITLE_TYPE = 2 ';
                    else
                        $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                    if ($type == 'Favorites')
                        $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                    else if ($type == "Watched" || $type == "Unwatched") {
                        $sql .= 'AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                        $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                        if ($type == "Watched")
                            $sql .= 'VIDEOS.PLAY_COUNT > 0 ';
                        else
                            $sql .= 'VIDEOS.PLAY_COUNT = 0 ';
                    }
                } else if ($filterby == 'Rating') {
                    $sql = 'SELECT COUNT(SHOWS.ID) FROM SHOWS ';
                    if ($type == "Watched" || $type == "Unwatched")
                        $sql .= ',SHOWS_VIDEOS,VIDEOS ';
                    if ($value == 0)
                        $sql .= 'WHERE RATING=0  ';
                    else
                        $sql .= 'WHERE RATING>"' . ($value - 1) . '" AND RATING<="' . $value . '"  ';
                    if ($type == 'Videos')
                        $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2) ';
                    else if ($type == 'TV Shows')
                        $sql .= 'AND SHOWS.TITLE_TYPE = 2 ';
                    else
                        $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                    if ($type == 'Favorites')
                        $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                    else if ($type == "Watched" || $type == "Unwatched") {
                        $sql .= 'AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                        $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                        if ($type == "Watched")
                            $sql .= 'VIDEOS.PLAY_COUNT > 0 ';
                        else
                            $sql .= 'VIDEOS.PLAY_COUNT = 0 ';
                    }
                } else if ($filterby == 'filter') {
                    $sql = 'SELECT COUNT(ID) FROM SHOWS WHERE ';
                    $sql .= 'TITLE LIKE "%' . $filter . '%" AND ';
                    $sql .= '(SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2)';
                } else if ($filterby == 'All') {
                    $sql = 'SELECT COUNT(SHOWS.ID) FROM SHOWS ';
                    if ($type == 'Favorites')
                        $sql .= ',FAVOURITES  ';
                    else if ($type == "Watched" || $type == "Unwatched")
                        $sql .= ',VIDEOS,SHOWS_VIDEOS ';
                    if ($type == 'Videos')
                        $sql .= 'WHERE (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2) ';
                    else if ($type == 'TV Shows')
                        $sql .= 'WHERE SHOWS.TITLE_TYPE = 2 ';
                    else
                        $sql .= 'WHERE (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                    if ($type == 'Favorites')
                        $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                    if ($type == "Watched" || $type == "Unwatched") {
                        $sql .= ' AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                        $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                        if ($type == "Watched")
                            $sql .= 'VIDEOS.PLAY_COUNT > 0';
                        else
                            $sql .= 'VIDEOS.PLAY_COUNT = 0';
                    }
                }
            } else if ($type == 'Collections') {
                $sql = "SELECT count(*) FROM sqlite_master WHERE type='table' AND name='COLLECTIONS'";
                $result = DBQuery($dbh, $sql);
                $exists = $result->fetch(PDO::FETCH_NUM);

                if ($exists[0] == 0) {
                    $sql = 'CREATE TABLE COLLECTIONS ( ID INTEGER PRIMARY KEY, TITLE TEXT, ';
                    $sql .= 'OVERVIEW TEXT, POSTER TEXT, CONTENT_TTID TEXT, CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT)';
                    DBQuery($dbh, $sql);
                }

                $sql = "SELECT count(*) FROM sqlite_master WHERE type='table' AND name='SHOWS_COLLECTIONS'";
                $result = DBQuery($dbh, $sql);
                $exists = $result->fetch(PDO::FETCH_NUM);

                if ($exists[0] == 0) {
                    $sql = 'CREATE TABLE SHOWS_COLLECTIONS ( ID INTEGER PRIMARY KEY, COLLECTIONS_ID INTEGER, ';
                    $sql .= 'SHOW_ID INTEGER, CUSTOM1 TEXT, ';
                    $sql .= 'CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT)';
                    DBQuery($dbh, $sql);
                }
                $sql = 'SELECT COUNT(ID) FROM COLLECTIONS ';
            }
            $result = DBQuery($dbh, $sql);
            $totalCount = $result->fetch();
        } else
            $totalCount[0] = 0;

        if ($type == 'Videos' || $type == 'TV Shows' || $type == 'Movies' || $type == 'Watched' || $type == 'Unwatched' || $type == "Favorites") {
            if ($filterby == 'Genre') {
                $sql = 'SELECT VIDEO_GENRES.ID,SHOWS_GENRES.SHOWS_ID AS SHOW_ID,TITLE_TYPE ';
                $sql .= ' FROM VIDEO_GENRES,SHOWS_GENRES,SHOWS ';
                if ($type == 'Favorites')
                    $sql .= ',FAVOURITES ';
                else if ($type == "Watched" || $type == "Unwatched")
                    $sql .= ',SHOWS_VIDEOS,VIDEOS ';
                $sql .= ' WHERE VIDEO_GENRES.NAME="' . $value . '" ';
                $sql .= 'AND SHOWS_GENRES.GENRES_ID=VIDEO_GENRES.ID ';
                if ($type == 'Favorites')
                    $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                $sql .= 'AND SHOWS.ID=SHOWS_GENRES.SHOWS_ID ';
                if ($type == 'Videos')
                    $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2) ';
                else if ($type == 'TV Shows')
                    $sql .= 'AND SHOWS.TITLE_TYPE = 2 ';
                else
                    $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                if ($type == "Watched" || $type == "Unwatched") {
                    $sql .= 'AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                    $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                    if ($type == "Watched")
                        $sql .= 'VIDEOS.PLAY_COUNT > 0 ';
                    else
                        $sql .= 'VIDEOS.PLAY_COUNT = 0 ';
                }
            } else if ($filterby == 'Director' || $filterby == 'Cast') {
                $sql = 'SELECT SHOWS_PERSONS.SHOWS_ID AS SHOW_ID,VIDEO_PERSONS.ID,SHOWS.TITLE_TYPE FROM ';
                $sql .= 'SHOWS,SHOWS_PERSONS,VIDEO_PERSONS ';
                if ($type == "Watched" || $type == "Unwatched")
                    $sql .= ',VIDEOS,SHOWS_VIDEOS ';
                $sql .= 'WHERE VIDEO_PERSONS.NAME="' . str_replace("'", "&apos;", $value) . '" AND ';
                $sql .= 'VIDEO_PERSONS.ID=SHOWS_PERSONS.PERSONS_ID ';
                $sql .= 'AND SHOWS.ID=SHOWS_PERSONS.SHOWS_ID ';
                if ($type == 'Videos')
                    $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2) AND ';
                else if ($type == 'TV Shows')
                    $sql .= 'AND SHOWS.TITLE_TYPE = 2 AND ';
                else
                    $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) AND ';
                if ($type == "Watched" || $type == "Unwatched") {
                    $sql .= ' VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                    $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                    if ($type == "Watched")
                        $sql .= 'VIDEOS.PLAY_COUNT > 0 AND ';
                    else
                        $sql .= 'VIDEOS.PLAY_COUNT = 0 AND ';
                }
                if ($filterby == 'Director')
                    $sql .= 'SHOWS_PERSONS.PERSON_TYPE = "DIRECTOR"';
                else if ($filterby == 'Cast')
                    $sql .= 'SHOWS_PERSONS.PERSON_TYPE = "CAST"';

            } else if ($filterby == 'Year') {
                $sql = 'SELECT SHOWS.ID AS SHOW_ID,SHOWS.TITLE_TYPE AS TITLE_TYPE FROM SHOWS ';
                if ($type == 'Favorites')
                    $sql .= ',FAVOURITES ';
                else if ($type == "Watched" || $type == "Unwatched")
                    $sql .= ',VIDEOS,SHOWS_VIDEOS ';
                $sql .= 'WHERE SHOWS.YEAR="' . $value . '"  ';
                if ($type == 'Videos')
                    $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2) ';
                else if ($type == 'TV Shows')
                    $sql .= 'AND SHOWS.TITLE_TYPE = 2 ';
                else
                    $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                if ($type == 'Favorites')
                    $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                else if ($type == "Watched" || $type == "Unwatched") {
                    $sql .= 'AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                    $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                    if ($type == "Watched")
                        $sql .= 'VIDEOS.PLAY_COUNT > 0 ';
                    else
                        $sql .= 'VIDEOS.PLAY_COUNT = 0 ';
                }
            } else if ($filterby == 'Index') {
                $sql = 'SELECT SHOW_GROUPS_SHOWS.SHOWS_ID AS SHOW_ID,SHOWS.TITLE_TYPE FROM ';
                $sql .= 'SHOW_GROUPS_SHOWS,SHOW_GROUPS,SHOWS,FAVOURITES WHERE ';
                $sql .= 'SHOW_GROUPS.NAME="' . $value . '" AND ';
                $sql .= 'SHOW_GROUPS_SHOWS.GROUPS_ID=SHOW_GROUPS.ID AND ';
                $sql .= 'SHOWS.ID=SHOW_GROUPS_SHOWS.SHOWS_ID AND ';
                $sql .= '(SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2)';
            } else if ($filterby == 'Certification') {
                if ($value == 'NR')
                    $value = '';
                $sql = 'SELECT SHOWS.ID AS SHOW_ID,TITLE_TYPE FROM SHOWS ';
                if ($type == "Watched" || $type == "Unwatched")
                    $sql .= ',VIDEOS,SHOWS_VIDEOS ';
                $sql .= 'WHERE PARENTAL_CONTROL="' . $value . '"  ';
                if ($type == 'Videos')
                    $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2) ';
                else if ($type == 'TV Shows')
                    $sql .= 'AND SHOWS.TITLE_TYPE = 2 ';
                else
                    $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                if ($type == 'Favorites')
                    $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                else if ($type == "Watched" || $type == "Unwatched") {
                    $sql .= 'AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                    $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                    if ($type == "Watched")
                        $sql .= 'VIDEOS.PLAY_COUNT > 0 ';
                    else
                        $sql .= 'VIDEOS.PLAY_COUNT = 0 ';
                }
            } else if ($filterby == 'Rating') {
                $sql = 'SELECT SHOWS.ID AS SHOW_ID,TITLE_TYPE FROM SHOWS ';
                if ($type == "Watched" || $type == "Unwatched")
                    $sql .= ',VIDEOS,SHOWS_VIDEOS ';
                if ($value == 0)
                    $sql .= 'WHERE RATING=0  ';
                else
                    $sql .= 'WHERE RATING>"' . ($value - 1) . '" AND RATING<="' . $value . '"  ';
                if ($type == 'Videos')
                    $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2) ';
                else if ($type == 'TV Shows')
                    $sql .= 'AND SHOWS.TITLE_TYPE = 2 ';
                else
                    $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                if ($type == 'Favorites')
                    $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                else if ($type == "Watched" || $type == "Unwatched") {
                    $sql .= 'AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                    $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                    if ($type == "Watched")
                        $sql .= 'VIDEOS.PLAY_COUNT > 0 ';
                    else
                        $sql .= 'VIDEOS.PLAY_COUNT = 0 ';
                }
            } else if ($filterby == 'filter') {
                $sql = 'SELECT ID AS SHOW_ID,TITLE_TYPE FROM ';
                $sql .= 'SHOWS WHERE ';
                $sql .= 'TITLE LIKE "%' . $filter . '%" AND ';
                $sql .= '(SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2)';
            } else if ($filterby == 'All') {
                $sql = 'SELECT SHOWS.ID AS SHOW_ID,SHOWS.TITLE_TYPE AS TITLE_TYPE ';
                $sql .= 'FROM SHOWS ';
                if ($type == "Watched" || $type == "Unwatched")
                    $sql .= ',VIDEOS, SHOWS_VIDEOS ';
                else if ($type == 'Favorites')
                    $sql .= ',FAVOURITES  ';
                if ($type == 'Videos')
                    $sql .= 'WHERE (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6 OR SHOWS.TITLE_TYPE = 2) ';
                else if ($type == 'TV Shows')
                    $sql .= 'WHERE SHOWS.TITLE_TYPE = 2 ';
                else
                    $sql .= 'WHERE (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                if ($type == 'Favorites')
                    $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                else if ($type == "Watched" || $type == "Unwatched") {
                    $sql .= 'AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                    $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                    if ($type == "Watched")
                        $sql .= 'VIDEOS.PLAY_COUNT > 0 ';
                    else
                        $sql .= 'VIDEOS.PLAY_COUNT = 0 ';
                }
            }
        }
        if ($sortby == 'title')
            $sql .= 'ORDER BY SEARCH_TITLE ';
        else if ($sortby == 'release')
            $sql .= 'ORDER BY RELEASE_DATE ';
        else if ($sortby == 'duration')
            $sql .= 'ORDER BY RUNTIME ';
        else if ($sortby == 'rating')
            $sql .= 'ORDER BY RATING ';
        else if ($sortby == 'date')
            $sql .= 'ORDER BY SHOWS.CREATE_TIME ';

        if ($type == 'Collections') {
            $sql = 'SELECT SHOW_ID FROM SHOWS_COLLECTIONS,COLLECTIONS ';
            $sql .= 'ORDER BY COLLECTIONS.TITLE ';
        }

        if ($orderby == 'asc')
            $sql .= 'ASC';
        else if ($orderby == 'desc')
            $sql .= 'DESC';

        $sql .= ' LIMIT ' . $posStart . ',' . $count;

        $rcount = 0;
        $result = DBQuery($dbh, $sql);
        $all_data = $result->fetchAll(PDO::FETCH_ASSOC);
        $count = count($all_data);

        if ($count > 0) {
            print ("{\n");
            print (" pos:" . $posStart . ",\n");
            print (" data: [\n");

            foreach ($all_data as $show_row) {
                if ($type == 'Collections') {
                    $sql = 'SELECT SHOWS_ID AS SHOW_ID,TITLE,POSTER FROM SHOWS_COLLECTIONS,COLLECTIONS ';
                    $sql .= 'WHERE COLLECTIONS.ID=SHOWS_COLLECTIONS.COLLECTIONS_ID ';
                    $sql .= 'ORDER BY COLLECTIONS.TITLE ';
                } else {
                    $sql = 'SELECT SHOWS.ID AS SHOW_ID,SHOWS.TITLE,SHOWS.TITLE_TYPE';
                    //$sql .= ',SHOWS.RATING,SHOWS.PARENTAL_CONTROL,SHOWS.TITLE_TYPE,SHOWS.YEAR';
                    $sql .= ',VIDEO_POSTERS.THUMBNAIL,VIDEO_POSTERS.POSTER ';
                    if ($show_row['TITLE_TYPE'] == 1 || $show_row['TITLE_TYPE'] == 6)
                        $sql .= ',VIDEOS.PLAY_COUNT ';
                    $sql .= 'FROM SHOWS,VIDEO_POSTERS ';
                    if ($show_row['TITLE_TYPE'] == 1 || $show_row['TITLE_TYPE'] == 6)
                        $sql .= ',SHOWS_VIDEOS,VIDEOS ';
                    $sql .= 'WHERE SHOWS.ID=' . $show_row['SHOW_ID'] . ' AND ';
                    $sql .= 'VIDEO_POSTERS.ID=' . $show_row['SHOW_ID'] . ' ';
                    if ($show_row['TITLE_TYPE'] == 1 || $show_row['TITLE_TYPE'] == 6) {
                        $sql .= ' AND SHOWS_VIDEOS.SHOWS_ID=' . $show_row['SHOW_ID'] . ' AND ';
                        $sql .= 'VIDEOS.ID=SHOWS_VIDEOS.VIDEOS_ID ';
                    }
                }

                $result = DBQuery($dbh, $sql);
                $nmj_data = $result->fetch(PDO::FETCH_ASSOC);

                // Print XML
                $kcount = 0;
                print ("  {\n");
                print("    total_count : " . $totalCount[0] . ",\n");
                foreach ($nmj_data as $key => $value) {
                    $kcount++;
                    if ($key == 'TITLE')
                        $value = htmlspecialchars_decode($value);
                    if ($key == 'THUMBNAIL' || $key == 'POSTER') {
                        $pos = strpos($value, "/share/nmj_database");
                        if ($pos === false)
                            $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                        else
                            $value = substr($value, 1);
                    }
                    if ($value == '')
                        $value = "NULL";

                    if ($kcount == count($nmj_data))
                        print('    "' . $key . '" : "' . $value . '"' . "\n");
                    else
                        print('    "' . $key . '" : "' . $value . '"' . ",\n");
                }
                $rcount++;
                if ($rcount == $count)
                    print ("  }\n");
                else
                    print ("  },\n");
            }
            print("]}\n");
        } else {
            print ("{\n");
            print (" pos:" . $posStart . ",\n");
            print (" data: [\n");
            print ("  {\n");
            print("    total_count : " . $totalCount[0] . "\n");
            print ("  }\n");
            print("]}\n");
        }
    } else {
        print("{ }\n");
    }
// close the database connection
    $dbh = NULL;
} else if (isset($_GET['xml']) && $_GET['xml'] == 'updateCollection') {
    global $APIKEY;
    header("Access-Control-Allow-Origin: *");

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];
    if (file_exists($drivepath)) {
        $mediapath = dirname(dirname($drivepath));
        $dbh = new PDO('sqlite:' . $drivepath);
        $sql = 'SELECT ID AS SHOW_ID, CONTENT_TTID FROM SHOWS ';
        $sql .= 'WHERE (TITLE_TYPE = 1 OR TITLE_TYPE = 6) ';
        foreach ($dbh->query($sql) as $show_data) {
            if (str_replace('tmdb', '', $show_data['CONTENT_TTID']) == 36657) {
                $APIURL = 'http://api.themoviedb.org/3/movie/' . str_replace('tmdb', '', $show_data['CONTENT_TTID']) . '?api_key=' . $APIKEY;
                $json = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget '" . $APIURL . "' -qO-");
                $json_parser = json_decode($json, true);
                if (is_array($json_parser['belongs_to_collection'])) {
                    $collection_id = $json_parser['belongs_to_collection']['id'];
                    $APIURL = 'http://api.themoviedb.org/3/collection/' . $collection_id . '?api_key=' . $APIKEY;
                    $json = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget '" . $APIURL . "' -qO-");
                    $json_parser = json_decode($json, true);
                    foreach ($json_parser['parts'] as $movies) {
                        $nmj_data['CONTENT_TTID'] = $json_parser['id'];
                        $nmj_data['TITLE'] = $json_parser['name'];
                        $nmj_data['OVERVIEW'] = $json_parser['overview'];
                        $nmj_data['POSTER'] = $json_parser['poster_path'];
                        $sql1 = 'SELECT ID AS SHOW_ID FROM SHOWS WHERE CONTENT_TTID="tmdb' . $movies['id'] . '"';
                        foreach ($dbh->query($sql1) as $tmdb_data) {
                            $nmj_data['SHOW_ID'] = $tmdb_data['SHOW_ID'];
                            //handleCollections($dbh, $nmj_data, "add");
                            print_r($nmj_data);
                        }
                    }
                }
                exit;
            }
        }
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'editFavorite') {
    $showid = $_GET['showid'];
    $title_type = $_GET['ttype'];
    $mode = $_GET['mode'];
    header("Access-Control-Allow-Origin: *");

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];
    if (file_exists($drivepath)) {
        $mediapath = dirname(dirname($drivepath));
        $dbh = new PDO('sqlite:' . $drivepath);
        if ($mode == 'add') {
            $sql = 'INSERT INTO FAVOURITES VALUES(NULL,"' . $title_type . '",';
            $sql .= $showid . ',NULL,NULL,NULL,NULL,NULL)';
        } else if ($mode == 'remove') {
            $sql = 'DELETE FROM FAVOURITES WHERE MEDIA_ID=' . $showid;
        }
        $result = DBQuery($dbh, $sql);
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'editWatched') {
    $showid = $_GET['showid'];
    $title_type = $_GET['ttype'];
    $mode = $_GET['mode'];
    header("Access-Control-Allow-Origin: *");

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];
    if (file_exists($drivepath)) {
        $mediapath = dirname(dirname($drivepath));
        $dbh = new PDO('sqlite:' . $drivepath);
        if ($mode == 'add') {
            $sql = 'UPDATE VIDEOS SET PLAY_COUNT=1 WHERE VIDEOS.ID=(SELECT VIDEOS_ID FROM SHOWS_VIDEOS ';
            $sql .= 'WHERE SHOWS_ID=' . $showid . ')';
        } else if ($mode == 'remove') {
            $sql = 'UPDATE VIDEOS SET PLAY_COUNT=0 WHERE VIDEOS.ID=(SELECT VIDEOS_ID FROM SHOWS_VIDEOS ';
            $sql .= 'WHERE SHOWS_ID=' . $showid . ')';
        }
        $result = DBQuery($dbh, $sql);
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getSeasons') {
    $showid = $_GET['showid'];
    header("Access-Control-Allow-Origin: *");

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];

    if (file_exists($drivepath)) {
        $mediapath = dirname(dirname($drivepath));
        $dbh = new PDO('sqlite:' . $drivepath);

        $sql = 'SELECT DISTINCT SHOWS.ID AS SHOW_ID, SHOWS.TITLE,SHOWS.PARENTAL_CONTROL,';
        $sql .= 'SHOWS.YEAR,SHOWS.RATING,SHOWS.TITLE_TYPE,';
        $sql .= 'VIDEO_POSTERS.POSTER ';
        $sql .= 'FROM SHOWS,VIDEO_POSTERS,EPISODES ';
        $sql .= 'WHERE EPISODES.SERIES_ID=' . $showid . ' AND ';
        $sql .= 'SHOWS.ID=EPISODES.SEASON_ID AND ';
        $sql .= 'VIDEO_POSTERS.ID=SHOWS.ID ';
        $sql .= 'ORDER BY EPISODES.SEASON ';

        $result = DBQuery($dbh, $sql);
        $nmj_data = $result->fetchAll(PDO::FETCH_ASSOC);
        $count = count($nmj_data);

        print ("[\n");
        $rcount = 0;
        foreach ($nmj_data as $rowdata) {
            $kcount = 0;
            print ("  {\n");
            $rcount++;
            foreach ($rowdata as $key => $value) {
                $kcount++;
                if ($key == 'POSTER') {
                    $pos = strpos($value, "/share/nmj_database");
                    if ($pos === false)
                        $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                    else
                        $value = substr($value, 1);
                }
                if ($kcount == count($rowdata))
                    print('    "' . $key . '" : "' . $value . '"' . "\n");
                else
                    print('    "' . $key . '" : "' . $value . '"' . ",\n");
            }
            if ($rcount == $count)
                print ("  }\n");
            else
                print ("  },\n");
        }
        print ("]\n");
    }

} else if (isset($_GET['xml']) && $_GET['xml'] == 'getMusic') {
    header("Access-Control-Allow-Origin: *");

    //define variables from incoming values
    if (isset($_GET["start"]))
        $posStart = $_GET['start'];
    else
        $posStart = 0;

    if (isset($_GET["TYPE"]))
        $type = $_GET['TYPE'];
    else
        $type = "";

    if (isset($_GET["VALUE"]))
        $value = $_GET['VALUE'];
    else
        $value = "";

    if (isset($_GET["count"]))
        $count = $_GET['count'];
    else
        $count = 20;

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];

    if (isset($_GET['filter']))
        $filter = $_GET['filter'];

    if (file_exists($drivepath)) {
        $mediapath = dirname(dirname($drivepath));
        $command = "cd /share/Apps/NMJManagerTablet;ln -s " . $mediapath . " .";
        shell_exec($command);
        $dbh = new PDO('sqlite:' . $drivepath);

        if ($posStart == 0) {
            if ($type == 'Genre') {
                $sql = 'SELECT COUNT(SONG_GENRES_SONG_ALBUMS.ID),SONG_GENRES.ID FROM SONG_GENRES,';
                $sql .= 'SONG_GENRES_SONG_ALBUMS WHERE SONG_GENRES.NAME="' . $value . '" ';
                $sql .= 'AND SONG_GENRES_SONG_ALBUMS.GENRES_ID=SONG_GENRES.ID';
            } else if ($type == 'Year') {
                $sql = 'SELECT COUNT(*) FROM SONG_ALBUMS ';
                $sql .= 'WHERE RELEASE_DATE LIKE "' . $value . '-%"';
            } else if ($type == 'Artist') {
                $sql = 'SELECT COUNT(*) FROM SONG_PERSONS_SONG_ALBUMS,SONG_PERSONS ';
                $sql .= 'WHERE SONG_PERSONS.NAME="' . $value . '" AND ';
                $sql .= 'SONG_PERSONS_SONG_ALBUMS.PERSONS_ID=SONG_PERSONS.ID';
            } else if ($type == "Music") {
                $sql = 'SELECT COUNT(*) FROM SONG_ALBUMS';
            }

            $result = DBQuery($dbh, $sql);
            $totalCount = $result->fetch();
        } else
            $totalCount[0] = 0;

        if ($type == 'Genre') {
            $sql = 'SELECT SONG_GENRES_SONG_ALBUMS.ALBUMS_ID AS ALBUM_ID FROM SONG_GENRES,';
            $sql .= 'SONG_GENRES_SONG_ALBUMS,SONG_ALBUMS WHERE SONG_GENRES.NAME="' . $value . '" ';
            $sql .= 'AND SONG_GENRES_SONG_ALBUMS.GENRES_ID=SONG_GENRES.ID ';
            $sql .= 'AND SONG_ALBUMS.ID=ALBUM_ID ';
            $sql .= ' ORDER BY SONG_ALBUMS.SEARCH_TITLE ';
        } else if ($type == 'Year') {
            $sql = 'SELECT ID AS ALBUM_ID FROM SONG_ALBUMS ';
            $sql .= 'WHERE RELEASE_DATE LIKE "' . $value . '-%"';
        } else if ($type == 'Artist') {
            $sql = 'SELECT SONG_ALBUMS.ID AS ALBUM_ID FROM SONG_ALBUMS,SONG_PERSONS,';
            $sql .= 'SONG_PERSONS_SONG_ALBUMS WHERE ';
            $sql .= 'SONG_PERSONS_SONG_ALBUMS.PERSONS_ID = SONG_PERSONS.ID AND ';
            $sql .= 'SONG_PERSONS_SONG_ALBUMS.ALBUMS_ID = SONG_ALBUMS.ID AND ';
            $sql .= 'SONG_PERSONS.NAME = "' . $value . '" ';
        } else if ($type == 'Music') {
            $sql = 'SELECT ID AS ALBUM_ID FROM SONG_ALBUMS ';
            $sql .= 'ORDER BY SEARCH_TITLE ';
        }

        $sql .= ' LIMIT ' . $posStart . ',' . $count;
        $rcount = 0;
        $result = DBQuery($dbh, $sql);
        $all_data = $result->fetchAll(PDO::FETCH_ASSOC);
        $count = count($all_data);

        if ($count > 0) {
            print ("{\n");
            print (" pos:" . $posStart . ",\n");
            print (" data: [\n");

            foreach ($all_data as $music_row) {
                $sql = 'SELECT SONG_ALBUMS.ID AS ALBUM_ID,';
                $sql .= 'SONG_ALBUMS.TITLE,';
                $sql .= 'SONG_PERSONS.NAME,';
                $sql .= 'SONG_ALBUM_POSTERS.THUMBNAIL ';
                $sql .= 'FROM SONG_ALBUMS,SONG_PERSONS,SONG_ALBUM_POSTERS ';
                $sql .= 'WHERE SONG_ALBUMS.ID=' . $music_row['ALBUM_ID'] . ' AND ';
                $sql .= 'SONG_PERSONS.ID=' . $music_row['ALBUM_ID'] . ' AND ';
                $sql .= 'SONG_ALBUM_POSTERS.ID=' . $music_row['ALBUM_ID'] . ' ';

                $result = DBQuery($dbh, $sql);
                $nmj_data = $result->fetch(PDO::FETCH_ASSOC);

                // Print XML
                //print('    <item id="' . $nmj_data['VIDEO_ID'] . '">' . "\n");
                $kcount = 0;
                print ("  {\n");
                print("    total_count : " . $totalCount[0] . ",\n");
                foreach ($nmj_data as $key => $value) {
                    if ($key == 'TITLE')
                        $value = htmlspecialchars_decode($value);
                    $kcount++;
                    if ($key == 'THUMBNAIL') {
                        $pos = strpos($value, "/share/nmj_database");
                        if ($pos === false)
                            $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                        else
                            $value = substr($value, 1);
                    }
                    if ($value == '')
                        $value = "NULL";

                    if ($kcount == count($nmj_data))
                        print('    "' . $key . '" : "' . $value . '"' . "\n");
                    else
                        print('    "' . $key . '" : "' . $value . '"' . ",\n");
                }
                $rcount++;
                if ($rcount == $count)
                    print ("  }\n");
                else
                    print ("  },\n");
            }
            print("]}\n");
        } else {
            print("{}\n");
        }
    } else {
        print("{ }\n");
    }
    // close the database connection
    $dbh = NULL;
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getChapters') {

    $imdbid = $_GET['TTID'];

    if (stristr($_SERVER["HTTP_ACCEPT"], "application/xhtml+xml")) {
        header("Content-type: application/xhtml+xml");
    } else {
        header("Content-type: text/xml");
    }
    header("Access-Control-Allow-Origin: *");
    print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    print ("<data>\n");
    $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- http://www.imdb.com/title/" . $imdbid . "/";
    $imdb_content = preg_replace('~(\r|\n|\r\n)~', '', shell_exec($command));
    $IMDB_TITLE = "~og:title' content=\"(.*) \((.*)\)\"~Ui";
    $strReturn = str_replace(" ", "%20", matchRegex($imdb_content, $IMDB_TITLE, 1));

    $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- http://chapterdb.org/browse/?title=" . $strReturn;
    $chapterdb_content = preg_replace('~(\r|\n|\r\n)~', '', shell_exec($command));
    $count = preg_match_all("|<td style=\"width:8\%\">(.*)</abbr></td>|isU", $chapterdb_content, $output);
    if ($count > 0) {
        for ($i = 0; $i < $count; $i++) {
            $cnt = preg_match('|(.*)</td>(.*)<a href="/browse/(.*)">(.*)</a></td>(.*)<td style(.*)>(.*)</td>|isU',
                $output[1][$i], $result);
            print ("            <item id='" . $result[3] . "'><name>" . $result[1] . "&#160;&#160;&#160;&#160;&#160;&#160;" .
                $result[4] . "&#160;&#160;&#160;&#160;&#160;&#160;" . $result[7] . "</name></item>\n");
        }
    }
    print ("</data>\n");
} else if (isset($_GET['xml']) && $_GET['xml'] == 'editChapters') {
    $showid = $_GET['showid'];
    $chapterid = $_GET['chapterid'];

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];

    $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- http://chapterdb.org/browse/" . $chapterid;
    $chapterdb_content = preg_replace('~(\r|\n|\r\n)~', '', shell_exec($command));
    preg_match("|<table class=\"table table-condensed table-striped\">(.*)</table>|isU", $chapterdb_content, $output);

    $dom = new DOMDocument;
    $dom->loadHTML($output[1]);
    $rows = array();
    foreach ($dom->getElementsByTagName('tr') as $tr) {
        $cells = array();
        foreach ($tr->getElementsByTagName('td') as $td) {
            $cells[] = $td->nodeValue;
        }
        $rows[] = $cells;
    }

    if (file_exists($drivepath)) {
        $mediapath = dirname(dirname($drivepath));
        $dbh = new PDO('sqlite:' . $drivepath);

        $sql = "SELECT count(*) FROM sqlite_master WHERE type='table' AND name='CHAPTERS'";
        $result = DBQuery($dbh, $sql);
        $exists = $result->fetch(PDO::FETCH_NUM);

        if ($exists[0] == 0) {
            $sql = 'CREATE TABLE CHAPTERS ( ID INTEGER PRIMARY KEY, CHAPTER INTEGER, ';
            $sql .= 'CHAPTER_TEXT INTEGER, RUNTIME INTEGER, SHOW_ID INTEGER, CUSTOM1 TEXT, ';
            $sql .= 'CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT)';
            DBQuery($dbh, $sql);
        }
        $sql = 'SELECT COUNT(SHOW_ID) FROM CHAPTERS WHERE SHOW_ID=' . $showid;
        $result = DBQuery($dbh, $sql);
        $chap_count = $result->fetchAll();
        if ($chap_count > 0) {
            $sql = 'DELETE FROM CHAPTERS WHERE SHOW_ID=' . $showid;
            DBQuery($dbh, $sql);
        }

        for ($i = 0; $i < count($rows); $i++) {
            $time = explode(".", $rows[$i][2]);
            sscanf($time[0], "%d:%d:%d", $hours, $minutes, $seconds);
            $time_seconds = isset($seconds) ? $hours * 3600 + $minutes * 60 + $seconds : $hours * 60 + $minutes;
            $sql = 'INSERT INTO CHAPTERS VALUES(NULL,';
            $sql .= $rows[$i][0] . ',"' . str_replace('"', '&quot;', $rows[$i][1]) . '",' . $time_seconds . ',';
            $sql .= $showid . ',NULL,NULL,NULL,NULL,NULL)';
            DBQuery($dbh, $sql);
        }
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getMovieDetails') {
    header("Access-Control-Allow-Origin: *");

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];

    $showid = $_GET['showid'];
    $index = $_GET['INDEX'];

    if (file_exists($drivepath)) {
        $mediapath = dirname(dirname($drivepath));
        $dbh = new PDO('sqlite:' . $drivepath);

        $nmj_data = loadMovieData($dbh, $showid, $drivepath);
        print ("[\n");
        print ("  {\n");
        print('    "INDEX" : "' . $index . '"' . ",\n");
        $kcount = 0;
        foreach ($nmj_data as $key => $value) {
            $kcount++;
            if ($key == 'BOOKMARK_TIME')
                $value = sprintf('%02d:%02d:%02d', ($value / 3600), ($value / 60 % 60), $value % 60);
            if ($key == 'THUMBNAIL') {
                $pos = strpos($value, "/share/nmj_database");
                if ($pos === false)
                    $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                else
                    $value = substr($value, 1);
            }
            if ($key == 'POSTER') {
                $pos = strpos($value, "/share/nmj_database");
                if ($pos === false)
                    $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                else
                    $value = substr($value, 1);
            }
            if ($key == 'WALLPAPER') {
                $pos = strpos($value, "/share/nmj_database");
                if ($pos === false)
                    $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                else
                    $value = substr($value, 1);
            }
            if ($key == 'BOOKMARK_THUMBNAIL') {
                $pos = strpos($value, "/share/nmj_database");
                if ($pos === false)
                    $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                else
                    $value = substr($value, 1);
            }
            print('    "' . $key . '" : "' . $value . '"' . ",\n");
        }
        print ('    "changed": [' . "\n");
        print ("    {\n");
        print ("    }\n");
        print ("    ],\n");
        print ('    "chapters": [' . "\n");

        $sql = "SELECT count(*) FROM sqlite_master WHERE type='table' AND name='CHAPTERS'";
        $result = DBQuery($dbh, $sql);
        $exists = $result->fetch(PDO::FETCH_NUM);

        if ($exists[0] != 0) {
            $sql = 'SELECT CHAPTER,CHAPTER_TEXT,RUNTIME FROM CHAPTERS WHERE ';
            $sql .= 'SHOW_ID=' . $showid . ' ORDER BY CHAPTER';
            $result = DBQuery($dbh, $sql);
            $allchapters = $result->fetchAll(PDO::FETCH_ASSOC);
        }
        if (count($allchapters) > 0) {
            foreach ($allchapters as $chapters) {
                print ("    {\n");
                print ('      "EPISODE": "' . $chapters['CHAPTER'] . '",' . "\n");
                print ('      "TITLE": "' . $chapters['CHAPTER_TEXT'] . '",' . "\n");
                print ('      "RUNTIME": "' . $chapters['RUNTIME'] . '",' . "\n");
                print ('      "RUNTIME_TEXT": "' . sec2hms($chapters['RUNTIME']) . '"' . "\n");
                print ("    },\n");
            }
        } else {
            $no_chapters = floor($nmj_data['RUNTIME'] / 600) + 1;
            for ($z = 0; $z < $no_chapters - 1; $z++) {
                print ("    {\n");
                print ('      "EPISODE": "' . ($z + 1) . '",' . "\n");
                print ('      "TITLE": "Chapter ' . ($z + 1) . '",' . "\n");
                print ('      "RUNTIME": "' . (600 * $z) . '",' . "\n");
                print ('      "RUNTIME_TEXT": "' . sec2hms(600 * $z) . '"' . "\n");
                print ("    },\n");
            }
            print ("    {\n");
            print ('      "EPISODE": "' . $no_chapters . '",' . "\n");
            print ('      "TITLE": "Chapter ' . $no_chapters . '",' . "\n");
            print ('      "RUNTIME": "' . ($nmj_data['RUNTIME'] - (600 * ($no_chapters - 1))) . '",' . "\n");
            print ('      "RUNTIME_TEXT": "' . sec2hms(600 * ($no_chapters - 1)) . '"' . "\n");
            print ("    },\n");
        }
        print ("    ]\n");
        print ("  }\n");
        print ("]\n");
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getActors') {
    header("Access-Control-Allow-Origin: *");

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];

    $showid = $_GET['showid'];

    if (file_exists($drivepath)) {
        $mediapath = dirname(dirname($drivepath));
        $dbh = new PDO('sqlite:' . $drivepath);

        $nmj_data = loadActorData($dbh, $showid, $drivepath);
        print ("{\n");
        $kcount = 0;
        print ('  data: [' . "\n");
        for ($i = 0; $i < count($nmj_data); $i++) {
            print ("    {\n");
            print ('      "show_id" : ' . $showid . ",\n");
            foreach ($nmj_data[$i] as $key => $value) {
                if ($key == 'THUMBNAIL') {
                    $pos = strpos($value, "/share/nmj_database");
                    if ($pos === false)
                        $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                    else
                        $value = substr($value, 1);
                }
                print('      "' . $key . '" : "' . $value . '"' . ",\n");
            }
            print ("    },\n");

        }
        print ("    ]\n");
        print ("}\n");
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getActorDetails') {
    header("Access-Control-Allow-Origin: *");

    $actorid = $_GET['actorid'];
    $showid = $_GET['showid'];

    $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://api.themoviedb.org/3/person/" .
        $actorid . "?api_key=" . $APIKEY . " -qO-";
    $json_parser = json_decode(shell_exec($command), true);
    $json_parser['SHOW_ID'] = $showid;

    print_r(json_encode($json_parser));
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getActorMovieDetails') {
    header("Access-Control-Allow-Origin: *");

    $actorid = $_GET['actorid'];
    if (isset($_GET['source']))
        $drivepath = $_GET['source'];

    $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://api.themoviedb.org/3/person/" .
        $actorid . "/movie_credits?api_key=" . $APIKEY . " -qO-";
    $json_parser = json_decode(shell_exec($command), true);

    aasort($json_parser['cast'], "release_date");

    if (file_exists($drivepath)) {
        $mediapath = dirname(dirname($drivepath));
        $dbh = new PDO('sqlite:' . $drivepath);

        print ("{\n");
        $kcount = 0;
        print ('  data: [' . "\n");
        for ($i = 0; $i < count($json_parser['cast']); $i++) {
            print ("    {\n");
            foreach ($json_parser['cast'][$i] as $key => $value) {
                if ($key == 'id') {
                    $sql = 'SELECT SHOWS.ID,PLAY_COUNT FROM SHOWS,VIDEOS,SHOWS_VIDEOS WHERE ';
                    $sql.= 'CONTENT_TTID="tmdb' . $value . '" AND ';
                    $sql.= 'SHOWS_VIDEOS.SHOWS_ID=SHOWS.ID AND ';
                    $sql.='VIDEOS.ID=SHOWS_VIDEOS.VIDEOS_ID';

                    $result = DBQuery($dbh, $sql);
                    $show_data = $result->fetch(PDO::FETCH_ASSOC);
                    if ($show_data['ID'] != 0) {
                        print('      "in_collection" : "yes"' . ",\n");
                        print('      "SHOW_ID" : "' . $show_data['ID'] . '"' . ",\n");
                        print('      "PLAY_COUNT" : "' . $show_data['PLAY_COUNT'] . '"' . ",\n");
                    } else {
                        print('      "in_collection" : "no"' . ",\n");
                        print('      "SHOW_ID" : "0"' . ",\n");
                        print('      "PLAY_COUNT" : "0"' . ",\n");
                    }
                }
                print('      "' . $key . '" : "' . str_replace('"', '\"', $value) . '"' . ",\n");
            }
            print ("    },\n");

        }
        print ("    ]\n");
        print ("}\n");
    }

} else if (isset($_GET['xml']) && $_GET['xml'] == 'getSeasonDetails') {
    header("Access-Control-Allow-Origin: *");

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];

    $showid = $_GET['showid'];
    $index = $_GET['INDEX'];

    if (file_exists($drivepath)) {
        $mediapath = dirname(dirname($drivepath));
        $dbh = new PDO('sqlite:' . $drivepath);

        $remove = array("\n", "\r\n", "\r");
        $nmj_data = loadSeasonData($dbh, $showid, $drivepath);
        print ("[\n");
        print ("  {\n");
        print('    "INDEX" : "' . $index . '"' . ",\n");
        $kcount = 0;
        foreach ($nmj_data as $key => $value) {
            $kcount++;
            if ($key == 'BOOKMARK_TIME')
                $value = sprintf('%02d:%02d:%02d', ($value / 3600), ($value / 60 % 60), $value % 60);
            if ($key == 'CONTENT')
                $value = str_replace($remove, ' ', $value);
            if ($key == 'POSTER') {
                $pos = strpos($value, "/share/nmj_database");
                if ($pos === false)
                    $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                else
                    $value = substr($value, 1);
            }
            if ($key == 'WALLPAPER') {
                $pos = strpos($value, "/share/nmj_database");
                if ($pos === false)
                    $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                else
                    $value = substr($value, 1);
            }
            if ($key == 'BOOKMARK_THUMBNAIL') {
                $pos = strpos($value, "/share/nmj_database");
                if ($pos === false)
                    $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                else
                    $value = substr($value, 1);
            }
            print('    "' . $key . '" : "' . $value . '"' . ",\n");
        }

        print ('    "episodes": [' . "\n");

        $remove = array("\n", "\r\n", "\r");
        $sql = 'SELECT EPISODE_ID,EPISODE FROM EPISODES WHERE ';
        $sql .= 'SEASON_ID=' . $showid . ' ORDER BY EPISODE';
        foreach ($dbh->query($sql) as $episodes) {
            $sql = 'SELECT VIDEOS_ID AS VIDEO_ID FROM SHOWS_VIDEOS ';
            $sql .= 'WHERE SHOWS_ID=' . $episodes['EPISODE_ID'];
            $result = DBQuery($dbh, $sql);
            $video_id = $result->fetch(PDO::FETCH_ASSOC);
            $sql = 'SELECT PATH FROM VIDEOS WHERE ID=' . $video_id['VIDEO_ID'];
            $result = DBQuery($dbh, $sql);
            $path = $result->fetch(PDO::FETCH_ASSOC);
            $sql = 'SELECT SHOWS.TITLE,SHOWS.RUNTIME,SYNOPSISES.SUMMARY FROM ';
            $sql .= 'SHOWS,SYNOPSISES WHERE SHOWS.ID=' . $episodes['EPISODE_ID'] . ' AND ';
            $sql .= 'SYNOPSISES.ID=' . $episodes['EPISODE_ID'];
            $result = DBQuery($dbh, $sql);
            $result_row = $result->fetch(PDO::FETCH_ASSOC);
            print ("    {\n");
            print ('      "EPISODE": "' . $episodes['EPISODE'] . '",' . "\n");
            print ('      "TITLE": "' . $result_row['TITLE'] . '",' . "\n");
            print ('      "SYNOPSIS": "' . str_replace($remove, ' ', trim(str_replace("&apos;", "'", $result_row['SUMMARY']))) . '",' . "\n");
            print ('      "RUNTIME": "' . sec2ms($result_row['RUNTIME']) . '",' . "\n");
            print ('      "PATH": "' . $path['PATH'] . '"' . "\n");
            print ("    },\n");
        }

        print ("    ]\n");
        print ("  }\n");
        print ("]\n");
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getMusicDetails') {
    header("Access-Control-Allow-Origin: *");

    if (isset($_GET['source']))
        $drivepath = $_GET['source'];

    $albumid = $_GET['albumid'];
    $index = $_GET['INDEX'];
    $songby = $_GET['songby'];

    if (file_exists($drivepath)) {
        $mediapath = dirname(dirname($drivepath));
        $dbh = new PDO('sqlite:' . $drivepath);

        print ("[\n");
        print ("  {\n");
        if ($albumid != 0) {
            //$nmj_data = loadMusicData($dbh, $albumid, $drivepath);
            $nmj_data = array();
            $sql = 'SELECT SONG_ALBUMS.ID AS ALBUM_ID,';
            $sql .= 'SONG_ALBUMS.TITLE,';
            $sql .= 'SONG_ALBUMS.RELEASE_DATE AS ALBUM_YEAR,';
            $sql .= 'SONG_PERSONS.NAME AS ALBUM_ARTIST,';
            $sql .= 'SONG_ALBUM_POSTERS.POSTER ';
            $sql .= 'FROM SONG_ALBUMS,SONG_PERSONS,SONG_ALBUM_POSTERS ';
            $sql .= 'WHERE SONG_ALBUMS.ID=' . $albumid . ' AND ';
            $sql .= 'SONG_PERSONS.ID=' . $albumid . ' AND ';
            $sql .= 'SONG_ALBUM_POSTERS.ID=' . $albumid . ' ';

            $result = DBQuery($dbh, $sql);
            $nmj_data = $result->fetch(PDO::FETCH_ASSOC);
            $year = explode("-", $nmj_data['ALBUM_YEAR']);
            $nmj_data['ALBUM_YEAR'] = $year[0];
            $nmj_data['DRIVE_PATH'] = $drivepath;

            print('    "INDEX" : "' . $index . '"' . ",\n");
            $kcount = 0;
            foreach ($nmj_data as $key => $value) {
                $kcount++;
                if ($key == 'BOOKMARK_TIME')
                    $value = sprintf('%02d:%02d:%02d', ($value / 3600), ($value / 60 % 60), $value % 60);
                if ($key == 'POSTER')
                    $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                print('    "' . $key . '" : "' . $value . '"' . ",\n");
            }
        }

        if ($albumid != 0) {
            $sql = 'SELECT SONGS.TITLE, SONG_GENRES.NAME AS GENRE, SONGS.RUNTIME, ';
            $sql .= 'SONG_ALBUMS.TITLE AS ALBUM,SONG_PERSONS.NAME AS ARTIST,SONGS.PATH,';
            $sql .= 'SONG_ALBUMS_SONGS.SEQUENCE AS TRACK_NO ';
            $sql .= 'FROM SONGS, SONG_ALBUMS_SONGS, SONG_GENRES, SONG_GENRES_SONGS,';
            $sql .= 'SONG_ALBUMS, SONG_PERSONS_SONGS, SONG_PERSONS ';
            $sql .= 'WHERE SONG_ALBUMS_SONGS.ALBUMS_ID = ' . $albumid . ' AND ';
            $sql .= 'SONG_PERSONS_SONGS.SONGS_ID = SONGS.ID AND ';
            $sql .= 'SONG_PERSONS.ID = SONG_PERSONS_SONGS.PERSONS_ID AND ';
            $sql .= 'SONG_ALBUMS.ID = ' . $albumid . ' AND ';
            $sql .= 'SONG_GENRES_SONGS.SONGS_ID = SONGS.ID AND ';
            $sql .= 'SONG_GENRES.ID = SONG_GENRES_SONGS.GENRES_ID AND ';
            $sql .= 'SONG_ALBUMS_SONGS.SONGS_ID = SONGS.ID ';
            $sql .= 'ORDER BY SONG_ALBUMS_SONGS.SEQUENCE';
        } else {
            $sql = 'SELECT SONGS.TITLE, SONG_GENRES.NAME AS GENRE, SONGS.RUNTIME, ';
            $sql .= 'SONG_ALBUMS.TITLE AS ALBUM,SONG_PERSONS.NAME AS ARTIST,SONGS.PATH, ';
            $sql .= 'SONG_ALBUMS_SONGS.SEQUENCE AS TRACK_NO ';
            $sql .= 'FROM SONGS, SONG_ALBUMS_SONGS, SONG_GENRES, SONG_GENRES_SONGS,';
            $sql .= 'SONG_ALBUMS, SONG_PERSONS_SONGS, SONG_PERSONS ';
            $sql .= 'WHERE SONGS.TITLE LIKE "' . $songby . '%" AND ';
            $sql .= 'SONG_ALBUMS_SONGS.SONGS_ID = SONGS.ID AND ';
            $sql .= 'SONG_GENRES.ID = SONG_GENRES_SONGS.GENRES_ID AND ';
            $sql .= 'SONG_GENRES_SONGS.SONGS_ID = SONGS.ID AND ';
            $sql .= 'SONG_ALBUMS.ID = SONG_ALBUMS_SONGS.ALBUMS_ID AND ';
            $sql .= 'SONG_PERSONS_SONGS.SONGS_ID = SONGS.ID AND ';
            $sql .= 'SONG_PERSONS.ID = SONG_PERSONS_SONGS.PERSONS_ID ';
            $sql .= 'ORDER BY SONGS.SEARCH_TITLE';
        }

        $tracks = 0;
        print ('    "tracks": [' . "\n");
        foreach ($dbh->query($sql) as $track_data) {
            $tracks++;
            print ("    {\n");
            print ('      "TRACK_NO": "' . $track_data['TRACK_NO'] . '",' . "\n");
            print ('      "TITLE": "' . $track_data['TITLE'] . '",' . "\n");
            print ('      "RUNTIME": "' . sec2ms($track_data['RUNTIME']) . '",' . "\n");
            print ('      "ALBUM": "' . $track_data['ALBUM'] . '",' . "\n");
            print ('      "GENRE": "' . $track_data['GENRE'] . '",' . "\n");
            print ('      "PATH": "' . $track_data['PATH'] . '",' . "\n");
            print ('      "COMPOSER": "-",' . "\n");
            print ('      "ARTIST": "' . $track_data['ARTIST'] . '"' . "\n");
            print ("    },\n");
        }

        print ("    ]\n");
        print ("  }\n");
        print ("]\n");
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getFilter') {
    if (stristr($_SERVER["HTTP_ACCEPT"], "application/xhtml+xml")) {
        header("Content-type: application/xhtml+xml");
    } else {
        header("Content-type: text/xml");
    }
    header("Access-Control-Allow-Origin: *");
    print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    print ("<data>\n");
    print ("    <item id='Genre'><name>Genre</name>\n");
    print ("    </item>\n");
    print ("</data>\n");
    /*} else if (isset($_GET['xml']) && $_GET['xml'] == 'getMenu') {
        if (isset($_GET['source']))
            $drivepath = $_GET['source'];
        if (file_exists($drivepath)) {
            $mediapath = dirname(dirname($drivepath));
            $dbh = new PDO('sqlite:' . $drivepath);

    //include XML Header (as response will be in xml format)
            if (stristr($_SERVER["HTTP_ACCEPT"], "application/xhtml+xml")) {
                header("Content-type: application/xhtml+xml");
            } else {
                header("Content-type: text/xml");
            }
            header("Access-Control-Allow-Origin: *");
            print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            print ("<data>\n");
            $sql = 'SELECT COUNT(*) FROM SHOWS WHERE TITLE_TYPE = 1 OR TITLE_TYPE = 6 OR TITLE_TYPE = 2';
            $result = DBQuery($dbh, $sql);
            $totalCount = $result->fetch();
            if ($totalCount[0] > 0) {
                print ("    <item id='Video'><name>Video</name>\n");
                $sql = 'SELECT COUNT(*) FROM SHOWS WHERE TITLE_TYPE = 1 OR TITLE_TYPE = 6';
                $result = DBQuery($dbh, $sql);
                $totalCount = $result->fetch();
                if ($totalCount[0] > 0)
                    print ("        <item id='Movie'><name>Movie</name></item>\n");
                $sql = 'SELECT COUNT(*) FROM SHOWS WHERE TITLE_TYPE = 2';
                $result = DBQuery($dbh, $sql);
                $totalCount = $result->fetch();
                if ($totalCount[0] > 0)
                    print ("        <item id='TV_Series'><name>TV Series</name></item>\n");
                print ("        <item id='Movie_Boxset'><name>Boxset</name></item>\n");
                print ("        <item id='Movie_Genre'><name>By Genre</name>\n");
                $sql = 'SELECT DISTINCT NAME FROM VIDEO_GENRES ORDER BY NAME';
                foreach ($dbh->query($sql) as $row)
                    print ("            <item id='" . $row['NAME'] . "'><name>" . $row['NAME'] . "</name></item>\n");
                print ("        </item>\n");
                print ("        <item id='Movie_Year'><name>By Year</name>\n");
                $sql = 'SELECT DISTINCT YEAR FROM SHOWS ORDER BY YEAR DESC';
                foreach ($dbh->query($sql) as $row)
                    print ("            <item id='" . $row['YEAR'] . "'><name>" . $row['YEAR'] . "</name></item>\n");
                print ("        </item>\n");
                print ("        <item id='Movie_Certification'><name>By Certification</name>\n");
                $remove = array("\n", "\r\n", "\r");
                $sql = 'SELECT DISTINCT PARENTAL_CONTROL FROM SHOWS ORDER BY PARENTAL_CONTROL';
                foreach ($dbh->query($sql) as $row) {
                    if ($row['PARENTAL_CONTROL'] == '')
                        $row['PARENTAL_CONTROL'] = 'Not Specified';
                    print ("            <item id='" . $row['PARENTAL_CONTROL'] . "'><name>" . $row['PARENTAL_CONTROL'] . "</name></item>\n");
                }
                print ("        </item>\n");
                print ("        <item id='Movie_Index'><name>By Index</name>\n");
                $sql = 'SELECT DISTINCT NAME FROM SHOW_GROUPS ORDER BY NAME';
                foreach ($dbh->query($sql) as $row) {
                    print ("            <item id='" . $row['NAME'] . "'><name>" . $row['NAME'] . "</name></item>\n");
                }
                print ("        </item>\n");
                print ("        <item id='Movie_Rating'><name>By Rating</name>\n");
                print ("            <item id='10'><name><![CDATA[<img src='images/common_star_10.png'>]]></name></item>\n");
                print ("            <item id='9'><name><![CDATA[<img src='images/common_star_9.png'>]]></name></item>\n");
                print ("            <item id='8'><name><![CDATA[<img src='images/common_star_8.png'>]]></name></item>\n");
                print ("            <item id='7'><name><![CDATA[<img src='images/common_star_7.png'>]]></name></item>\n");
                print ("            <item id='6'><name><![CDATA[<img src='images/common_star_6.png'>]]></name></item>\n");
                print ("            <item id='5'><name><![CDATA[<img src='images/common_star_5.png'>]]></name></item>\n");
                print ("            <item id='4'><name><![CDATA[<img src='images/common_star_4.png'>]]></name></item>\n");
                print ("            <item id='3'><name><![CDATA[<img src='images/common_star_3.png'>]]></name></item>\n");
                print ("            <item id='2'><name><![CDATA[<img src='images/common_star_2.png'>]]></name></item>\n");
                print ("            <item id='1'><name><![CDATA[<img src='images/common_star_1.png'>]]></name></item>\n");
                print ("            <item id='0'><name><![CDATA[<img src='images/common_star_0.png'>]]></name></item>\n");
                print ("        </item>\n");
                print ("    </item>\n");
            }
            $sql = 'SELECT COUNT(TITLE) FROM SONGS';
            $result = DBQuery($dbh, $sql);
            $totalCount = $result->fetch();
            if ($totalCount[0] > 0) {
                print ("    <item id='Music_Music'><name>Music</name>\n");
                print ("        <item id='Music_Album'><name>By Album</name></item>\n");
                print ("        <item id='Music_Playlist'><name>By Playlist</name>\n");
                print ("        </item>\n");
                print ("        <item id='Music_Song'><name>By Song</name>\n");
                $sql = 'SELECT DISTINCT TITLE FROM SONGS ORDER BY SEARCH_TITLE';
                foreach ($dbh->query($sql) as $row) {
                    $alphabet = substr($row['TITLE'], 0, 1);
                    $output[$alphabet] = $alphabet;
                }
                foreach ($output as $key => $alphabet)
                    print ("            <item id='" . $alphabet . "'><name>" . $alphabet . "</name></item>\n");
                print ("        </item>\n");
                print ("        <item id='Music_Genre'><name>By Genre</name>\n");
                $sql = 'SELECT DISTINCT NAME FROM SONG_GENRES ORDER BY NAME';
                foreach ($dbh->query($sql) as $row)
                    print ("            <item id='" . $row['NAME'] . "'><name>" . $row['NAME'] . "</name></item>\n");
                print ("        </item>\n");
                print ("        <item id='Music_Artist'><name>By Artist</name>\n");*/
    /*$sql = 'SELECT DISTINCT SONG_GROUPS.NAME FROM SONG_GROUPS,SONG_PERSONS_SONG_ALBUMS ';
    $sql .= 'WHERE SONG_PERSONS_SONG_ALBUMS.CUSTOM1 = SONG_GROUPS.ID';
    foreach ($dbh->query($sql) as $row) {
        print ("            <item id='".$row['NAME']."'><name>".$row['NAME']."</name>\n");
        $sql = 'SELECT SONG_PERSONS.NAME FROM SONG_PERSONS,SONG_PERSONS_SONG_ALBUMS,SONG_GROUPS ';
        $sql .= 'WHERE SONG_PERSONS_SONG_ALBUMS.CUSTOM1 = SONG_GROUPS.ID AND ';
        $sql .= 'SONG_PERSONS.ID = SONG_PERSONS_SONG_ALBUMS.PERSONS_ID AND ';
        $sql .= 'SONG_GROUPS.NAME = "'.$row['NAME'].'" ';
        foreach ($dbh->query($sql) as $artist)
            print ("                <item id='".$artist['NAME']."'><name>".$artist['NAME']."</name></item>\n");
            print ("            </item>\n");
    }*/
    /*$sql = 'SELECT DISTINCT NAME FROM SONG_PERSONS ORDER BY NAME';
    foreach ($dbh->query($sql) as $row) {
        $name = str_replace('&', '&amp;', str_replace('&amp;', '&', $row['NAME']));
        print ("            <item id='" . $name . "'><name><![CDATA[" . $name . "]]></name></item>\n");
    }
    print ("        </item>\n");
    print ("        <item id='Music_Year'><name>By Year</name>\n");
    $sql = 'SELECT DISTINCT RELEASE_DATE FROM SONG_ALBUMS ORDER BY RELEASE_DATE DESC';
    foreach ($dbh->query($sql) as $row) {
        $year = explode("-", $row[0]);
        $yr[$year[0]] = $year[0];
    }
    foreach ($yr as $year)
        print ("            <item id='" . $year . "'><name>" . $year . "</name></item>\n");
    print ("        </item>\n");
    print ("        <item id='By Rating'><name>By Rating</name>\n");
    print ("        </item>\n");
    print ("    </item>\n");
}
print ("    <item id='Source'><name>Source</name>\n");
print ("    </item>\n");
print ("    <item id='Remote Control'><name>Remote Control</name>\n");
print ("    </item>\n");
print ("    <item id='Now Playing'><name>Now Playing</name>\n");
print ("    </item>\n");
print ("</data>\n");
}
*/
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getList') {
    if (isset($_GET['source']))
        $drivepath = $_GET['source'];

    if (isset($_GET['type']))
        $type = $_GET['type'];

    if (file_exists($drivepath)) {
        $mediapath = dirname(dirname($drivepath));
        $dbh = new PDO('sqlite:' . $drivepath);

        if (stristr($_SERVER["HTTP_ACCEPT"], "application/xhtml+xml")) {
            header("Content-type: application/xhtml+xml");
        } else {
            header("Content-type: text/xml");
        }
        header("Access-Control-Allow-Origin: *");
        print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        print ("<data>\n");
        if ($type == "genre") {
            $sql = 'SELECT DISTINCT NAME FROM VIDEO_GENRES ORDER BY NAME';
            print ("            <item id='All genres'><name>All genres</name></item>\n");
            foreach ($dbh->query($sql) as $row)
                print ("            <item id='" . $row['NAME'] . "'><name>" . $row['NAME'] . "</name></item>\n");
        } else if ($type == "year") {
            $sql = 'SELECT DISTINCT YEAR FROM SHOWS ORDER BY YEAR DESC';
            print ("            <item id='All years'><name>All years</name></item>\n");
            foreach ($dbh->query($sql) as $row)
                print ("            <item id='" . $row['YEAR'] . "'><name>" . $row['YEAR'] . "</name></item>\n");
        } else if ($type == "certification") {
            $sql = 'SELECT DISTINCT PARENTAL_CONTROL FROM SHOWS ORDER BY PARENTAL_CONTROL';
            print ("            <item id='All certifications'><name>All certifications</name></item>\n");
            foreach ($dbh->query($sql) as $row) {
                if ($row['PARENTAL_CONTROL'] == '')
                    $row['PARENTAL_CONTROL'] = 'NR';
                print ("            <item id='" . $row['PARENTAL_CONTROL'] . "'><name>" . $row['PARENTAL_CONTROL'] . "</name></item>\n");
            }
        } else if ($type == "rating") {
            print ("            <item id='All ratings'><name>All ratings</name></item>\n");
            print ("            <item id='10'><name><![CDATA[<img src='images/common_star_10.png'>]]></name></item>\n");
            print ("            <item id='9'><name><![CDATA[<img src='images/common_star_9.png'>]]></name></item>\n");
            print ("            <item id='8'><name><![CDATA[<img src='images/common_star_8.png'>]]></name></item>\n");
            print ("            <item id='7'><name><![CDATA[<img src='images/common_star_7.png'>]]></name></item>\n");
            print ("            <item id='6'><name><![CDATA[<img src='images/common_star_6.png'>]]></name></item>\n");
            print ("            <item id='5'><name><![CDATA[<img src='images/common_star_5.png'>]]></name></item>\n");
            print ("            <item id='4'><name><![CDATA[<img src='images/common_star_4.png'>]]></name></item>\n");
            print ("            <item id='3'><name><![CDATA[<img src='images/common_star_3.png'>]]></name></item>\n");
            print ("            <item id='2'><name><![CDATA[<img src='images/common_star_2.png'>]]></name></item>\n");
            print ("            <item id='1'><name><![CDATA[<img src='images/common_star_1.png'>]]></name></item>\n");
            print ("            <item id='0'><name><![CDATA[<img src='images/common_star_0.png'>]]></name></item>\n");
        }
        print ("</data>\n");
    }
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getMenu') {
    if (isset($_GET['type']))
        $type = $_GET['type'];

    if (stristr($_SERVER["HTTP_ACCEPT"], "application/xhtml+xml")) {
        header("Content-type: application/xhtml+xml");
    } else {
        header("Content-type: text/xml");
    }
    header("Access-Control-Allow-Origin: *");
    print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    print ("<data>\n");
    if ($type == "main") {
        print ("    <item id='Videos'><name>All Videos</name></item>\n");
        print ("    <item id='Movies'><name>Movies</name></item>\n");
        print ("    <item id='TV Shows'><name>TV Shows</name></item>\n");
        print ("    <item id='Favorites'><name>Favorites</name></item>\n");
        print ("    <item id='Collections'><name>Collections</name></item>\n");
        print ("    <item id='Watched'><name>Watched videos</name></item>\n");
        print ("    <item id='Unwatched'><name>Unwatched videos</name></item>\n");
        print ("    <item id='Unidentified'><name>Unidentified videos</name></item>\n");
    } else if ($type == "settingsmain") {
        print ("    <item id='settings'><name>Settings</name><img>images/overview.png</img></item>\n");
    } else if ($type == "settingsdetail") {
        print ("    <item id='settings'><name>Settings</name><img>images/overview.png</img></item>\n");
        print ("    <item id='add_chapters'><name>Add Chapters</name><img>images/chapters.png</img></item>\n");
        print ("    <item id='edit'><name>Edit Movie</name><img>images/edit.png</img></item>\n");
        print ("    <item id='identify'><name>Identify Movie</name><img>images/search.png</img></item>\n");
        print ("    <item id='delete'><name>Delete Movie</name><img>images/delete.png</img></item>\n");
        print ("    <item id='imdb'><name>Open in IMDb</name><img>images/imdb.png</img></item>\n");
        print ("    <item id='tmdb'><name>Open in TMDb</name><img>images/tmdb.png</img></item>\n");
    } else if ($type == "sort") {
        print ("    <item id='title'><name>Sort by title</name></item>\n");
        print ("    <item id='release'><name>Sort by release</name></item>\n");
        print ("    <item id='duration'><name>Sort by duration</name></item>\n");
        print ("    <item id='rating'><name>Sort by rating</name></item>\n");
        print ("    <item id='date'><name>Sort by date added</name></item>\n");
    } else if ($type == "filter") {
        print ("    <item id='genres'><name>Genres</name><img>images/genres.png</img></item>\n");
        print ("    <item id='certification'><name>Certification</name><img>images/certification.png</img></item>\n");
        print ("    <item id='rating'><name>Rating</name><img>images/rating.png</img></item>\n");
        print ("    <item id='year'><name>Year</name><img>images/year.png</img></item>\n");
        print ("    <item id='clear'><name>Clear Filter</name><img>images/filter.png</img></item>\n");
    } else if ($type == "detail") {
        print ("    <item id='overview'><name>Overview</name></item>\n");
        print ("    <item id='actors'><name>Actors</name></item>\n");
    } else if ($type == "actor") {
        print ("    <item id='biography'><name>Biography</name></item>\n");
        print ("    <item id='filmography'><name>Filmography</name></item>\n");
    }
    print ("</data>\n");
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getDrives') {
    if (isset($_GET['type']))
        $type = $_GET['type'];
//include XML Header (as response will be in xml format)
    if (stristr($_SERVER["HTTP_ACCEPT"], "application/xhtml+xml")) {
        header("Content-type: application/xhtml+xml");
    } else {
        header("Content-type: text/xml");
    }
    header("Access-Control-Allow-Origin: *");
    print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");

    print ("<data>\n");
    if ($type == "local") {
        $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;/bin/wget -qO- \"http://127.0.0.1:8008/system?arg0=list_devices\"";
        $davidbox_output = shell_exec($command);
        $xml_parser = xml_parser_create();
        xml_parse_into_struct($xml_parser, $davidbox_output, $vals, $index);
        xml_parser_free($xml_parser);
        $drive_count = 0;

        foreach ($vals as $drive_data) {
            if ($drive_data['tag'] == 'ACCESSPATH')
                $drive[$drive_count]['ACCESSPATH'] = $drive_data['value'];
            if ($drive_data['tag'] == 'NAME')
                $drive[$drive_count]['NAME'] = $drive_data['value'];
            if ($drive_data['tag'] == 'TYPE')
                $drive[$drive_count]['TYPE'] = $drive_data['value'];
            if ($drive_data['tag'] == 'URL')
                $drive[$drive_count++]['URL'] = $drive_data['value'];
            if ($drive_data['tag'] == 'RETURNVALUE' && $drive_data['level'] == 2)
                $return_value = $drive_data['value'];
        }
        for ($i = 0; $i < count($drive); $i++) {
            print ("    <item id='" . $drive[$i]['NAME'] . "'>\n");
            print ("        <title>" . $drive[$i]['NAME'] . "</title>\n");
            print ("        <accesspath>" . $drive[$i]['ACCESSPATH'] . "</accesspath>\n");
            print ("        <drivepath>" . $drive[$i]['URL'] . "</drivepath>\n");
            print ("        <type>" . $drive[$i]['TYPE'] . "</type>\n");
            if (file_exists($drive[$i]['URL'] . "/nmj_database/media.db")) {
                print ("        <dbpath>" . $drive[$i]['URL'] . "/nmj_database/media.db</dbpath>\n");
                print ("        <image>images/selectsource_icon_harddisk_jukebox.png</image>\n");
                print ("        <jukebox>yes</jukebox>\n");
            } else {
                print ("        <image>images/selectsource_icon_harddisk.png</image>\n");
                print ("        <jukebox>no</jukebox>\n");
            }
            print ("    </item>\n");
        }
    } else if ($type == "network") {
        $davidbox_output = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;/bin/wget -qO- 'http://127.0.0.1:8008/setting?arg0=list_network_shared_folder'");
        $xml_parser = xml_parser_create();
        xml_parse_into_struct($xml_parser, $davidbox_output, $vals, $index);
        xml_parser_free($xml_parser);
        $drive_count = 0;
        foreach ($vals as $drive_data) {
            if ($drive_data['tag'] == 'SHARENAME')
                $drive[$drive_count]['SHARENAME'] = $drive_data['value'];
            if ($drive_data['tag'] == 'URL')
                $drive[$drive_count++]['URL'] = $drive_data['value'];
            if ($drive_data['tag'] == 'RETURNVALUE' && $drive_data['level'] == 2)
                $return_value = $drive_data['value'];
        }
        print ("    <item id='Network Browser'>\n");
        print ("        <title>Network Browser</title>\n");
        print ("        <dbpath></dbpath>\n");
        print ("        <image>images/selectsource_icon_network_browser.png</image>\n");
        print ("        <jukebox>no</jukebox>\n");
        print ("    </item>\n");
        for ($i = 0; $i < count($drive); $i++) {
            print ("    <item id='" . $drive[$i]['SHARENAME'] . "'>\n");
            print ("        <title>" . $drive[$i]['SHARENAME'] . "</title>\n");
            $share_name = explode("/", $drive[$i]['URL']);
            $share_name = $share_name[count($share_name) - 1];
            $command = "mount |grep '" . $share_name . " on'|cut -d' ' -f3";
            $output = trim(shell_exec($command));
            print ("        <drivepath>" . $drive[$i]['URL'] . "</drivepath>\n");
            $jukebox_available = 0;
            if (file_exists($output . "/nmj_database/media.db")) {
                print ("        <dbpath>" . $output . "/nmj_database/media.db</dbpath>\n");
                print ("        <image>images/selectsource_icon_network_shared.png</image>\n");
                print ("        <jukebox>yes</jukebox>\n");
                $jukebox_available = 1;
            }
            $list = glob('/share/nmj_database_*');
            if (count($list) > 0) {
                for ($k = 0; $k < count($list); $k++) {
                    $temp_dbh = new PDO('sqlite:' . $list[$k] . '/media.db');
                    $sql = 'SELECT DIRECTORY FROM SCAN_DIRS';
                    $result = DBQuery($temp_dbh, $sql);
                    $all_data = $result->fetch(PDO::FETCH_ASSOC);
                    if ($all_data['DIRECTORY'] == $drive[$i]['URL']) {
                        print ("        <dbpath>" . $list[$k] . "/media.db</dbpath>\n");
                        print ("        <image>images/selectsource_icon_network_shared.png</image>\n");
                        print ("        <jukebox>yes</jukebox>\n");
                        $jukebox_available = 1;
                    }
                }
            }
            if ($jukebox_available == 0) {
                print ("        <image>images/selectsource_icon_network_shared.png</image>\n");
                print ("        <jukebox>no</jukebox>\n");
            }
            print ("    </item>\n");
        }
    }
    print ("</data>\n");
} else if (isset($_GET['xml']) && $_GET['xml'] == 'getImages') {
    if (isset($_GET['type']))
        $type = $_GET['type'];

    if (isset($_GET["imdbid"]))
        $imdbid = $_GET["imdbid"];
    else
        $imdbid = "tt0111257";

//include XML Header (as response will be in xml format)
    if (stristr($_SERVER["HTTP_ACCEPT"], "application/xhtml+xml")) {
        header("Content-type: application/xhtml+xml");
    } else {
        header("Content-type: text/xml");
    }
    header("Access-Control-Allow-Origin: *");

    print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");


    if (isset($_GET["image"]))
        $image = str_replace("w1280", "w300", $_GET['image']);
    else {
        if ($type == "DETAIL_POSTER")
            $image = "images/poster.jpg";
        else
            $image = "images/no_wallpaper.jpg";
    }

    $APIKEY = "b626260be86175272e48fa6347e58100";

    $conf = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://api.themoviedb.org/3/configuration?api_key=" . $APIKEY . " -qO-");
    $json_parser = json_decode($conf, true);
    if ($type == 'DETAIL_POSTER')
        $base_url = $json_parser['images']['base_url'] . $json_parser['images']['poster_sizes'][1];
    else if ($type == 'WALLPAPER')
        $base_url = $json_parser['images']['base_url'] . $json_parser['images']['backdrop_sizes'][0];

    $data = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://api.themoviedb.org/3/movie/" . $imdbid . "/images?api_key=" . $APIKEY . " -qO-");
    $json_parser = json_decode($data, true);

    $i = 0;
    $img_array[0] = $image;
    if ($type == 'WALLPAPER') {
        foreach ($json_parser['backdrops'] as $backdrop)
            $img_array[++$i] = $base_url . $backdrop['file_path'];
    } else if ($type == 'DETAIL_POSTER') {
        foreach ($json_parser['posters'] as $poster)
            $img_array[++$i] = $base_url . $poster['file_path'];
    }
    print ("<data>\n");
    for ($j = 0; $j < count($img_array); $j++) {
        print("    <item id ='" . $j . "'><image>" . $img_array[$j] . "</image></item>\n");
    }
    print ("</data>\n");
} else if (isset($_GET['xml']) && $_GET['xml'] == 'playMedia') {
    if (isset($_GET['media']))
        $media = $_GET['media'];
    if (isset($_GET['type']))
        $type = $_GET['type'];
    if (isset($_GET['time']))
        $time = $_GET['time'];
    if ($time == 0)
        $time = '';
    $host = trim(shell_exec("hostname"));
    $APIURL = '';
    if ($type == "movie") {
        $movies = explode("#", $media);
        if (count($movies) == 1) {
            $APIURL = " 'http://127.0.0.1:8008/playback?arg0=start_vod&arg1=MyMovieFile&arg2=file://" . $movies[0] . "&arg3=show&arg4=" . $time . "&arg5=0&arg6=disable' ";
        } else {
            for ($h = 0; $h < count($movies); $h++)
                $APIURL = $APIURL . " 'http://127.0.0.1:8008/playback?arg0=insert_vod_queue&arg1=MyMovieFile&arg2=file://" . $movies[$h] . "&arg3=show&arg4=' ";
        }
    } else {
        $music = explode("#", $media);
        if (count($music) == 1)
            $APIURL = " 'http://127.0.0.1:8008/playback?arg0=start_aod&arg1=MyAudioFile&arg2=file://" . $music[0] . "&arg3=show&arg4=disable' ";
        else {
            for ($h = 0; $h < count($music); $h++)
                $APIURL = $APIURL . " 'http://127.0.0.1:8008/playback?arg0=insert_aod_queue&arg1=MyAudioFile&arg2=file://" . $music[$h] . "&arg3=show' ";
        }
    }
    if ($host != "raspberrypi") {
        $current = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- 'http://127.0.0.1:8008/playback?arg0=stop_vod'");
        $current = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- 'http://127.0.0.1:8008/playback?arg0=stop_aod'");

        $url = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- " . $APIURL;
        $xml_data = shell_exec($url);
        $xml_parser = xml_parser_create();
        xml_parse_into_struct($xml_parser, $xml_data, $vals, $index);
        xml_parser_free($xml_parser);
        foreach ($vals as $drive_data) {
            if ($drive_data['tag'] == 'RETURNVALUE' && $drive_data['level'] == 2)
                $return_value = $drive_data['value'];
        }
    } else {
        $return_value = 0;
    }
    print_r($return_value);
}
?>
