<?php
// +-----------------------------------------------------------------------+
// |                                                                       |
// | THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS   |
// | "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT     |
// | LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR |
// | A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT  |
// | OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, |
// | SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT      |
// | LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, |
// | DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY |
// | THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT   |
// | (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE |
// | OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.  |
// |                                                                       |
// +-----------------------------------------------------------------------+

$TMDBAPI = "b626260be86175272e48fa6347e58100";
$TVDBAPI = "BAA99452E3BA7E07";
$convert_location = "/usr/bin/convert";
$datadir = "data";

function fixImagePath($mediapath, $nmj_data)
{
    if(isset($nmj_data['THUMBNAIL'])) {
    $pos = strpos($nmj_data['THUMBNAIL'], "/share/nmj_database");
    if ($pos === false)
        $nmj_data['THUMBNAIL'] = ($nmj_data['THUMBNAIL']) ? basename($mediapath) . '/' . $nmj_data['THUMBNAIL'] : $nmj_data['THUMBNAIL'];
    else
        $nmj_data['THUMBNAIL'] = substr($nmj_data['THUMBNAIL'], 1);
    }
    if(isset($nmj_data['POSTER'])) {
    $pos = strpos($nmj_data['POSTER'], "/share/nmj_database");
    if ($pos === false)
        $nmj_data['POSTER'] = ($nmj_data['POSTER']) ? basename($mediapath) . '/' . $nmj_data['POSTER'] : $nmj_data['POSTER'];
    else
        $nmj_data['POSTER'] = substr($nmj_data['POSTER'], 1);
    }
    if(isset($nmj_data['WALLPAPER'])) {
    $pos = strpos($nmj_data['WALLPAPER'], "/share/nmj_database");
    if ($pos === false)
        $nmj_data['WALLPAPER'] = ($nmj_data['WALLPAPER']) ? basename($mediapath) . '/' . $nmj_data['WALLPAPER'] : $nmj_data['WALLPAPER'];
    else
        $nmj_data['WALLPAPER'] = substr($nmj_data['WALLPAPER'], 1);
    }
    if(isset($nmj_data['BOOKMARK_THUMBNAIL'])) {
    $pos = strpos($nmj_data['BOOKMARK_THUMBNAIL'], "/share/nmj_database");
    if ($pos === false)
        $nmj_data['BOOKMARK_THUMBNAIL'] = ($nmj_data['BOOKMARK_THUMBNAIL']) ? basename($mediapath) . '/' . $nmj_data['BOOKMARK_THUMBNAIL'] : $nmj_data['BOOKMARK_THUMBNAIL'];
    else
        $nmj_data['BOOKMARK_THUMBNAIL'] = substr($nmj_data['BOOKMARK_THUMBNAIL'], 1);
    }
    return $nmj_data;
}

function array_push_assoc($array, $key, $value)
{
    $array[$key] = $value;
    return $array;
}

function scan_dir($dir)
{
    $dh = opendir($dir);
    while (false !== ($filename = readdir($dh))) {
        $files[] = $filename;
    }
    sort($files);
    return $files;
}

function getXMLSafe($input)
{
    return html_entity_decode(str_replace('&#x27;', '&#39;', str_replace('&apos;', '&#39;', $input)), ENT_QUOTES);
    //return str_replace("&#039;", "&apos;", htmlentities(html_entity_decode($input), ENT_QUOTES));
    //return str_replace("&#039;", "'", $input);
}

function checkNaddListTable($dbh)
{
        $sql = "SELECT count(*) FROM sqlite_master WHERE type='table' AND name='LISTS'";
        $result = DBQuery($dbh, $sql);
        $exists = $result->fetch(PDO::FETCH_NUM);

        if ($exists[0] == 0) {
            $sql = 'CREATE TABLE LISTS ( ID INTEGER PRIMARY KEY, TITLE TEXT, ';
            $sql .= 'POSTER TEXT, PLAY_COUNT INTEGER, TITLE_TYPE INTEGER, LIST_ID TEXT, CUSTOM1 TEXT, ';
            $sql .= 'CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT)';
            DBQuery($dbh, $sql);
        }

        $sql = "SELECT count(*) FROM sqlite_master WHERE type='table' AND name='SHOWS_LISTS'";
        $result = DBQuery($dbh, $sql);
        $exists = $result->fetch(PDO::FETCH_NUM);

        if ($exists[0] == 0) {
            $sql = 'CREATE TABLE SHOWS_LISTS ( ID INTEGER PRIMARY KEY, LIST_ID INTEGER, ';
            $sql .= 'SHOW_ID INTEGER, CUSTOM1 TEXT, ';
            $sql .= 'CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT)';
            DBQuery($dbh, $sql);
        }
}

function setXMLSafe($input)
{
    return str_replace("&#039;", "&apos;", htmlentities($input, ENT_QUOTES));
}

function getIMDBdata($imdbid)
{
    global $tmpdir;

    $nmj_data = array();

    $command = "wget 'http://www.omdbapi.com/?i=".$imdbid."&plot=full&r=json' -qO-";
    $data = shell_exec($command);
    $json_parser = json_decode($data, true);

    foreach($json_parser as $key => $tdata){
        if ($key == 'Title')
            $nmj_data['TITLE'] = $tdata;
        else if ($key == 'Year')
	    $nmj_data['YEAR'] = $tdata;
        else if ($key == 'imdbID')
	    $nmj_data['TTID'] = $tdata;
        else if ($key == 'Released')
            $nmj_data['RELEASE_DATE'] = $tdata;
        else if ($key == 'imdbRating')
            $nmj_data['RATING'] = $tdata;
        else if ($key == 'Plot')
            $nmj_data['CONTENT'] = $tdata;
        else if ($key == 'Rated')
            $nmj_data['PARENTAL_CONTROL'] = $tdata;
        else if ($key == 'Genre')
           $nmj_data['GENRE'] = explode(", ", $tdata);
        else if ($key == 'Director')
           $nmj_data['DIRECTOR'] = explode(", ", $tdata);
    }
    return ($nmj_data);
}

function getTMDBdata($imdbid)
{
    global $tmpdir, $TMDBAPI;

    $nmj_data['CONTENT_TTID'] = $imdbid;

    if (file_exists($tmpdir . "/cache." . $nmj_data['CONTENT_TTID']) && filesize($tmpdir . "/cache." . $nmj_data['CONTENT_TTID']) > 0)
        $data = file_get_contents($tmpdir . "/cache." . $nmj_data['CONTENT_TTID']);
    else {
        $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget 'http://api.themoviedb.org/3/movie/" .
        str_replace('tmdb','',$nmj_data['CONTENT_TTID']) . "?api_key=" . $TMDBAPI . "&language=".$nmj_data['LANG']."' -qO-";
        $data = shell_exec($command);
        file_put_contents($tmpdir . "/cache." . $nmj_data['CONTENT_TTID'], $data);
    }
    $json_parser = json_decode($data, true);

    foreach($json_parser as $key => $tdata){
        if ($key == 'title')
            $nmj_data['TITLE'] = $tdata;
        else if ($key == 'release_date') {
	    $nmj_data['RELEASE_DATE'] = $tdata;
            $nmj_data['YEAR'] = date('Y', strtotime($tdata));
        }
        else if ($key == 'imdb_id')
            $nmj_data['TTID'] = $tdata;
        else if ($key == 'vote_average')
            $nmj_data['RATING'] = strval($tdata);
        else if ($key == 'overview')
            $nmj_data['CONTENT'] = $tdata;
    }

    for($i=0;$i<count($json_parser['genres']);$i++) {
       $grow[]= $json_parser['genres'][$i]['name'];
    }
    if (is_array($grow))
        $nmj_data['GENRE'] = $grow;

    $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://api.themoviedb.org/3/movie/" .
    str_replace('tmdb','',$nmj_data['CONTENT_TTID']) . "/credits?api_key=" . $TMDBAPI . " -qO-";
    $data = shell_exec($command);
    $json_parser = json_decode($data, true);

    for($i=0;$i<count($json_parser['crew']);$i++) {
       if ($json_parser['crew'][$i]['job'] == 'Director')
           $drow[]= $json_parser['crew'][$i]['name'];
    }
    $nmj_data['DIRECTOR'] = $drow;

    $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://api.themoviedb.org/3/movie/" .
    str_replace('tmdb','',$nmj_data['CONTENT_TTID']) . "/releases?api_key=" . $TMDBAPI . " -qO-";
    $data = shell_exec($command);
    $json_parser = json_decode($data, true);
    $nmj_data['PARENTAL_CONTROL'] = $json_parser['countries'][0]['certification'];

    $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://api.themoviedb.org/3/movie/" .
    str_replace('tmdb','',$nmj_data['CONTENT_TTID']) . "/keywords?api_key=" . $TMDBAPI . " -qO-";
    $data = shell_exec($command);
    $json_parser = json_decode($data, true);

    for($i=0;$i<count($json_parser['keywords']);$i++) {
       $krow[]= $json_parser['keywords'][$i]['name'];
    }
    $nmj_data['KEYWORD'] = $krow;

    return($nmj_data);
}

function getMediaInfo($media_data)
{
    $mediainfo = trim(shell_exec("which mediainfo"));
    if (substr($media_data['VIDEO']['PATH'], 0, 6) == "smb://" || substr($media_data['VIDEO']['PATH'], 0, 6) == "nfs://")
        $mediafile = $media_data['VIDEO']['DRIVE']."/".str_replace($media_data['VIDEO']['SOURCEURL'], '', $media_data['VIDEO']['PATH']);
    else
        $mediafile = $media_data['VIDEO']['DRIVE']."/".$media_data['VIDEO']['PATH'];
    if (file_exists($mediafile)) {
    if ($mediainfo != "") {
        $command = $mediainfo." --Full --Output=XML";
        $cmd = $command . " \"" . $mediafile . "\"";
        $media_output = shell_exec($cmd);
        $xml = simplexml_load_string($media_output);
        $json = json_encode($xml);
        $array = json_decode($json,TRUE);

        foreach ($array['File']['track'][1] as $key => $value){
            if ($key == 'Width')
                $media_data['VIDEO']['WIDTH'] = $value[0];
            else if ($key == 'Height')
                $media_data['VIDEO']['HEIGHT'] = $value[0];
            else if ($key == 'Frame_rate')
                $media_data['VIDEO']['FPS'] = $value[0];
            else if ($key == 'Display_aspect_ratio')
                $media_data['VIDEO']['ASPECT_RATIO'] = $value[1];
            else if ($key == 'Writing_library_Name')
                $media_data['VIDEO']['VIDEO_CODEC'] = $value;
            else if ($key == 'Codecs_Video' )
                $media_data['VIDEO']['VIDEO_CODEC'] = $value;
        }
        foreach ($array['File']['track'][0] as $key => $value){
            if ($key == 'Format')
                $media_data['VIDEO']['SYSTEM'] = $value[0];
            else if ($key == 'File_size' )
                $media_data['VIDEO']['SIZE'] = $value[0];
            else if ($key == 'Duration' )
                $media_data['VIDEO']['RUNTIME'] = floor($value[0]/1000);
            else if ($key == 'Text_Language_List' )
                $media_data['VIDEO']['SUBTITLE']['INTERNAL'] = explode(" / ", $value);
        }
        if ($media_data['VIDEO']['HEIGHT'] != '' && $media_data['VIDEO']['WIDTH'] != '')
            $media_data['VIDEO']['RESOLUTION'] = $media_data['VIDEO']['WIDTH'] . 'x' . $media_data['VIDEO']['HEIGHT'];

        $media_data['VIDEO']['CREATE_TIME'] = date("Y-m-d H:i:s");
        $media_data['status'] = "success";
        $media_data['message'] = "Video details updated.";
    }
    else {
        $media_data['status'] = "error";
        $media_data['message'] = "Mediainfo binary not found.";
    }

    $media_woe_fpath = substr($media_data['VIDEO']['DRIVE'] . $media, 0, strrpos($media_data['VIDEO']['DRIVE'] . $media, "."));
    $media_woe = substr($media, 0, strrpos($media, "."));

    $extn = array(".srt", ".ssa", ".sub", ".idx");
    for($j=0;$j<count($extn);$j++) {
        if (file_exists($media_woe_fpath . $extn[$j]))
            $media_data['VIDEO']['SUBTITLE']['EXTERNAL'] = $media_woe . $extn[$j];
    }
    }
    else {
        $media_data['status'] = "error";
        $media_data['message'] = "File does not exist.";
    }
    return ($media_data);
}

function handleNMJData($dbh, $data, $mode)
{
    switch ($mode) {
        case "inserted":
            // Insert VIDEO_PERSON
            $data['castid'] = handleVideoPerson($dbh, $data, "insert");

            // Insert SHOW N VIDEO
            $data['SHOW_ID'] = handleShow($dbh, $data, "insert");
            $data['VIDEO_ID'] = handleVideo($dbh, $data, "insert");
            handleMediaInfo($dbh, $data, "update");

            $data['p_sql_data'] = getPosterData($data);
            handleImages($dbh, $data, "updated");

            $data['t_sql_data'] = getThumbnailData($data);
            handleShowThumbnail($dbh, $data, "update");
            handleVideoThumbnail($dbh, $data, "update");

            $data['w_sql_data'] = getWallpaperData($data);
            handleShowWallpaper($dbh, $data, "update");
            handleVideoWallpaper($dbh, $data, "update");

            // Insert VIDEO_ATTR
            handleSubtitle($dbh, $data, "inserted");
            handleGenre($dbh, $data, "inserted");
            if ($data['KEYWORD'] != '')
                handleKeyword($dbh, $data, "inserted");
            if ($data['DIRECTOR'] != '')
                handleDirector($dbh, $data, "insert");

            if (isset($data['synopsis']))
                handleVideoSynopsis($dbh, $data, "insert");

            if ((!isset($data['GROUPS_ID'])) || $data['GROUPS_ID'] == '')
                $data = handleVideoGroupName($dbh, $data, "insert");
            handleVideoGroup($dbh, $data, "insert");
            break;
        case "updated":
            if(!isset($data['MODE']) || $data['MODE'] == 'single'){
              $nmj_data = $data;
              $tmpdata = $data['SHOW_ID'];
              unset($data['SHOW_ID']);
              $data['SHOW_ID'][] = $tmpdata;
            }
            else
              file_put_contents("data/percent_completed", "");
            for($i=0;$i<count($data['SHOW_ID']);$i++) {
              if($data['MODE'] == "multiple") {
                if($data['db'] == 'tmdb')
                  $sql = 'SELECT CONTENT_TTID FROM SHOWS WHERE ID='.$data['SHOW_ID'][$i];
                else if($data['db'] == 'imdb')
                  $sql = 'SELECT TTID FROM SHOWS WHERE ID='.$data['SHOW_ID'][$i];
                $result = DBQuery($dbh, $sql);
                $tmdb = $result->fetch(PDO::FETCH_ASSOC);
                if($data['db'] == 'tmdb')
                  $nmj_data = getTMDBdata($tmdb['CONTENT_TTID']);
                else if($data['db'] == 'imdb')
                  $nmj_data = getIMDBdata($tmdb['TTID']);
              }
        
            // Update Show Poster
            if (isset($nmj_data['TITLE']))
                handleShow($dbh, $nmj_data, $mode, $data['SHOW_ID'][$i]);
            if (isset($nmj_data['CONTENT']))
                handleVideoSynopsis($dbh, $nmj_data, $mode, $data['SHOW_ID'][$i]);
            if (isset($nmj_data['GENRE']))
                handleGenre($dbh, $nmj_data, $mode, $data['SHOW_ID'][$i]);
            if (isset($nmj_data['KEYWORD']))
                handleKeyword($dbh, $nmj_data, $mode, $data['SHOW_ID'][$i]);
            if (isset($nmj_data['DIRECTOR']))
                handleDirector($dbh, $nmj_data, $mode, $data['SHOW_ID'][$i]);
            //if (isset($data['POSTER']) || isset($data['THUMBNAIL']) || isset($data['WALLPAPER']))
                //handleImages($dbh, $data, $mode);

            if ($data['GROUPS_CHANGED'] == 1)
                handleVideoGroup($dbh, $data, $mode);
            if ($data['SUBTITLE_CHANGED'] == 1)
                handleSubtitle($dbh, $data, $mode);

            if ($data['MEDIAINFO_CHANGED'] == 1)
                handleMediaInfo($dbh, $data, $mode);
              if($data['MODE'] == 'multiple') {
                $percent = (($i+1) * 100) / count($data['SHOW_ID']);
                file_put_contents("data/percent_completed", $percent."\n");
              }
            }

            break;
        case "deleted":
            // Delete SHOW N VIDEO
            handleImages($dbh, $data, $mode);

            handleVideo($dbh, $data, $mode);
            handleShow($dbh, $data, $mode);

            handleSubtitle($dbh, $data, $mode);
            handleGenre($dbh, $data, $mode);
            handleKeyword($dbh, $data, $mode);
            handleDirector($dbh, $data, $mode);

            handleVideoSynopsis($dbh, $data, $mode);
            handleVideoGroup($dbh, $data, $mode);
            break;
    }
}

function sec2hms($sec, $padHours = false)
{
    $hms = "";
    $hours = intval(intval($sec) / 3600);
    $hms .= str_pad($hours, 2, "0", STR_PAD_LEFT) . ":";
    $minutes = intval(($sec / 60) % 60);
    $hms .= str_pad($minutes, 2, "0", STR_PAD_LEFT) . ":";
    $seconds = intval($sec % 60);
    $hms .= str_pad($seconds, 2, "0", STR_PAD_LEFT);
    return $hms;
}

function sec2ms($sec, $padHours = false)
{
    $hms = "";
    $hours = intval(intval($sec) / 3600);
    $minutes = intval(($sec / 60) % 60);
    $hms .= str_pad($minutes, 2, "0", STR_PAD_LEFT) . ":";
    $seconds = intval($sec % 60);
    $hms .= str_pad($seconds, 2, "0", STR_PAD_LEFT);
    return $hms;
}

function sec2hm($sec, $padHours = false)
{
    $hm = "";
    $hours = intval(intval($sec) / 3600);
    if ($hours > 1)
        $hrtxt = "hrs ";
    else
        $hrtxt = "hr ";
    $hm .= ($padHours)
        ? str_pad($hours, 2, "0", STR_PAD_LEFT) . $hrtxt
        : $hours . $hrtxt;
    $minutes = intval(($sec / 60) % 60);
    $hm .= str_pad($minutes, 2, "0", STR_PAD_LEFT) . "min";
    return $hm;
}

function DBQuery($dbh, $sql)
{
    //file_put_contents("sql.txt", $sql . "\n", FILE_APPEND);
    $result = $dbh->query($sql);
    $err = $dbh->errorInfo();
    if (!$result) {
        $dbh = NULL;
        $error = $sql."\n".$err[2];
        die($err[2]);
    } else {
        return $result;
    }
}

function handleList($dbh, $data, $mode)
{
    switch ($mode) {
        case "updated":
            $sql = 'SELECT ID FROM LISTS WHERE TITLE="'. $data['NAME'].'"';
            $result = DBQuery($dbh, $sql);
            $row = $result->fetch(PDO::FETCH_ASSOC);
            if (!isset($row['ID'])) {
                $sql = 'INSERT INTO LISTS VALUES(NULL,';
                $sql .= '"'.$data['NAME'].'",';
                $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL)';
                DBQuery($dbh, $sql);
                $row['ID'] = $dbh->lastInsertId();
            }
            if (isset($row['ID'])) {
                $sql = 'SELECT ID AS LID FROM SHOWS_LISTS WHERE LIST_ID='.$row['ID'].' AND ';
                $sql .= 'SHOW_ID='.$data['SHOW_ID'];
                $result = DBQuery($dbh, $sql);
                $nrow = $result->fetch(PDO::FETCH_ASSOC);
                if (!isset($nrow['LID'])) {
                    $sql = 'INSERT INTO SHOWS_LISTS VALUES(NULL,' . $row['ID'] . ',';
                    $sql .= $data['SHOW_ID'] . ',NULL,NULL,NULL,NULL,NULL)';
                    $result = DBQuery($dbh, $sql);
                }
            }
            break;
        case "deleted":
            break;
    }
}

// Function to Add/Delete/Edit Genre
function handleCollections($dbh, $data, $mode)
{
    switch ($mode) {
        case "updated":
            $urltype = substr($data['POSTER'], 0, 4);
            if ($urltype == 'http') {
                $poster_url = str_replace("/w300/", "/original/", $data['POSTER']);
                $suffix = $data['TITLE'].".jpg";
                $poster_fname = "collection_". $row['ID'] . "_" . $suffix;
                $data['POSTER'] = "nmj_database/media/video/poster/" . $poster_fname;
                $command = 'wget -q "http://images1-focus-opensocial.googleusercontent.com/gadgets/proxy?url=' . $poster_url . '&resize_w=220&resize_h=330&container=focus" -O "' . $data['DRIVE'] . "/" . $data['POSTER'] . '"';
                shell_exec($command);
            }
            $sql = 'SELECT ID FROM COLLECTIONS WHERE CONTENT_TTID="tmdb' . $data['CONTENT_TTID'] . '"';
            $result = DBQuery($dbh, $sql);
            $row = $result->fetch(PDO::FETCH_ASSOC);
            if (!isset($row['ID'])) {
                $sql = 'INSERT INTO COLLECTIONS VALUES(NULL,"' . $data['TITLE'] . '",';
                $sql .= '"'.setXMLSafe($data['OVERVIEW']).'",';
                $sql .= '"'.$data['POSTER'].'",';
                $sql .= '0, 10,';
                $sql .= '"tmdb'.$data['CONTENT_TTID'].'",';
                $sql .= 'NULL,NULL,NULL,NULL,NULL)';
                DBQuery($dbh, $sql);
                $row['ID'] = $dbh->lastInsertId();
            }
            if (isset($row['ID'])) {
                for($i=0;$i<count($data['SHOW_ID']);$i++){
                    $sql = 'SELECT ID AS BID FROM SHOWS_COLLECTIONS WHERE COLLECTIONS_ID='.$row['ID'].' AND ';
                    $sql .= 'SHOW_ID='.$data['SHOW_ID'][$i];
                    $result = DBQuery($dbh, $sql);
                    $nrow = $result->fetch(PDO::FETCH_ASSOC);
                    if (!isset($nrow['BID'])) {
                        $sql = 'INSERT INTO SHOWS_COLLECTIONS VALUES(NULL,' . $row['ID'] . ',';
                        $sql .= $data['SHOW_ID'][$i] . ',NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                    }
                }
            }
            break;
        case "deleted":
            break;
    }
}

// Function to Add/Delete/Edit Genre
function handleGenre($dbh, $data, $mode, $show_id)
{
    switch ($mode) {
        case "inserted":
            if ($data['TITLE_TYPE'] != 2 || $data['TITLE_TYPE'] != 3 || $data['TITLE_TYPE'] != 4) {
                for ($i = 0; $i < count($data['GENRE']); $i++) {
                    $sql = 'SELECT ID FROM VIDEO_GENRES WHERE NAME="' . $data['GENRE'][$i] . '"';
                    $result = DBQuery($dbh, $sql);
                    $row = $result->fetch(PDO::FETCH_ASSOC);
                    if (!isset($row['ID'])) {
                        $sql = 'INSERT INTO VIDEO_GENRES VALUES(NULL,"' . $data['GENRE'][$i] . '",';
                        $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                        $row['ID'] = $dbh->lastInsertId();
                    }
                    if (isset($row['ID'])) {
                        $sql = 'INSERT INTO SHOWS_GENRES VALUES(NULL,' . $row['ID'] . ',';
                        $sql .= $show_id . ',NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                    }
                }
            }
            return $result;
        break;
        case "updated":
            handleGenre($dbh, $data, "deleted", $show_id);
            handleGenre($dbh, $data, "inserted", $show_id);
        break;
        case "deleted":
            $sql = 'DELETE FROM SHOWS_GENRES WHERE SHOWS_ID=' . $show_id;
            DBQuery($dbh, $sql);
        break;
    }
}

// Function to Add/Edit/Delete Keyword
function handleKeyword($dbh, $data, $mode, $show_id)
{
    switch ($mode) {
        case "inserted":
            // Insert KEYWORD
                if ($data['TITLE_TYPE'] != 2 || $data['TITLE_TYPE'] != 3 ||
                    $data['TITLE_TYPE'] != 4) {
                    for ($i = 0; $i < count($data['KEYWORD']); $i++) {
                        $sql = 'SELECT ID FROM KEYWORDS WHERE KEYWORD="' . $data['KEYWORD'][$i] . '"';
                        $result = DBQuery($dbh, $sql);
                        $row = $result->fetch(PDO::FETCH_ASSOC);
                        if (!isset($row['ID'])) {
                            $sql = 'INSERT INTO KEYWORDS VALUES(NULL,"' . $data['KEYWORD'][$i] . '",';
                            $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL)';
                            DBQuery($dbh, $sql);
                            $row['ID'] = $dbh->lastInsertId();
                        }
                        if (isset($row['ID'])) {
                            $sql = 'INSERT INTO SHOWS_KEYWORDS VALUES(NULL,' . $row['ID'] . ',';
                            $sql .= $show_id . ',NULL,NULL,NULL,NULL,NULL)';
                            DBQuery($dbh, $sql);
                        }
                    }
                }
            break;
        case "updated":
            handleKeyword($dbh, $data, "deleted", $show_id);
            handleKeyword($dbh, $data, "inserted", $show_id);
            break;
        case "deleted":
                $sql = 'DELETE FROM SHOWS_KEYWORDS WHERE SHOWS_ID=' . $show_id;
                DBQuery($dbh, $sql);
            break;
    }
}

// Function to Add/Edit/Delete Director
function handleDirector($dbh, $data, $mode, $show_id)
{
    switch ($mode) {
        case "inserted":
            // Insert DIRECTOR
            for ($i = 0; $i < count($data['DIRECTOR']); $i++) {
                $sql = 'SELECT ID FROM VIDEO_PERSONS WHERE NAME="' . $data['DIRECTOR'][$i] . '"';
                $result = DBQuery($dbh, $sql);
                $row = $result->fetch(PDO::FETCH_ASSOC);
                if (!isset($row['ID'])) {
                    $sql = 'INSERT INTO VIDEO_PERSONS VALUES(NULL,"' . $data['DIRECTOR'][$i] . '",';
                    $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL)';
                    DBQuery($dbh, $sql);
                    $row['ID'] = $dbh->lastInsertId();
                }
                if (isset($row['ID'])) {
                    $sql = 'INSERT INTO SHOWS_PERSONS VALUES(NULL,' . $row['ID'] . ',';
                    $sql .= $show_id . ',"DIRECTOR",NULL,NULL,NULL,NULL,NULL)';
                    DBQuery($dbh, $sql);
                }
            }
            break;
        case "updated":
            handleDirector($dbh, $data, "deleted", $show_id);
            handleDirector($dbh, $data, "inserted", $show_id);
            break;
        case "deleted":
            $sql = 'DELETE FROM SHOWS_PERSONS WHERE SHOWS_ID=' . $show_id;
            $sql .= ' AND PERSON_TYPE="DIRECTOR"';
            DBQuery($dbh, $sql);
            break;
    }
}

// Function to Add/Edit/Delete VideoAttr
function handleSubtitle($dbh, $nmj_data, $mode)
{
    switch ($mode) {
        // Insert
        case "inserted":
                if (isset($nmj_data['SUBTITLE']) && $nmj_data['SUBTITLE'] != '') {
                    $subtitle = explode("#", $nmj_data['SUBTITLE']);
                    for ($i = 0; $i < count($subtitle); $i++) {
                        $sql = 'INSERT INTO VIDEO_SUBTITLES VALUES(NULL,';
                        $sql .= $nmj_data['VIDEO_ID'] . ',';
                        $sql .= (strpos($subtitle[$i], "/") === false) ? 'NULL,' : '"' . $subtitle[$i] . '",';
                        $sql .= (strpos($subtitle[$i], "/") === false) ? '"' . $subtitle[$i] . '",' : '"EXTERNAL",';
                        $sql .= '0,';
                        $sql .= '"' . date("Y-m-d H:i:s") . '",';
                        $sql .= (strpos($subtitle[$i], "/") === false) ? '"INTERNAL",' : '"EXTERNAL",';
                        $sql .= 'NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                    }
                }
            break;

        // Update
        case "updated":
            handleSubtitle($dbh, $nmj_data, "deleted");
            handleSubtitle($dbh, $nmj_data, "inserted");
            break;

        // Delete GENRE
        case "deleted":
            $sql = 'DELETE FROM VIDEO_SUBTITLES WHERE VIDEOS_ID=' . $nmj_data['VIDEO_ID'];
            DBQuery($dbh, $sql);
            break;
    }
}

function handleMediaInfo($dbh, $nmj_data, $mode)
{
    switch ($mode) {
        case "updated":
            $sql = 'UPDATE VIDEO_PROPERTIES SET ';
            $sql .= 'RUNTIME=' . $nmj_data['RUNTIME'] . ',';
            $sql .= 'RESOLUTION="' . $nmj_data['RESOLUTION'] . '",';
            $sql .= 'WIDTH="' . $nmj_data['WIDTH'] . '",';
            $sql .= 'HEIGHT="' . $nmj_data['HEIGHT'] . '",';
            $sql .= 'ASPECT_RATIO="' . $nmj_data['ASPECT_RATIO'] . '",';
            $sql .= 'SYSTEM="' . $nmj_data['SYSTEM'] . '",';
            $sql .= 'VIDEO_CODEC="' . $nmj_data['VIDEO_CODEC'] . '",';
            $sql .= 'FPS="' . $nmj_data['FPS'] . '" ';
            $sql .= ' WHERE ID=' . $nmj_data['VIDEO_ID'];
            DBQuery($dbh, $sql);
            break;
        case "deleted":
            $sql = 'DELETE FROM VIDEO_PROPERTIES WHERE VIDEOS_ID=' . $nmj_data['VIDEO_ID'];
            DBQuery($dbh, $sql);
            break;
    }
}

// Function to Add/Edit/Delete Show And Video
function setImageData($data, $show_id)
{
    if (isset($data['POSTER']) && $data['POSTER'] != '') {
        $urltype = substr($data['POSTER'], 0, 4);
        if ($urltype == 'http') {
            $poster_url = str_replace("/w185/", "/original/", $data['POSTER']);
            //$suffix = basename(substr($data['VIDEO']['PATH'], 0, strrpos($data['VIDEO']['PATH'], "."))).".jpg";
            $suffix = basename($data['POSTER']);
            $poster_fname = "poster_s_" . $show_id . "_" . $suffix;
            $data['POSTER'] = "nmj_database/media/video/poster/" . $poster_fname;
            $command = 'wget -q "http://images1-focus-opensocial.googleusercontent.com/gadgets/proxy?url=' . $poster_url . '&resize_w=220&resize_h=330&container=focus" -O "' . $data['DRIVE'] . "/" . $data['POSTER'] . '"';
            shell_exec($command);
        }
        else 
            $data['POSTER'] = str_replace(basename($data['DRIVE'])."/", "", $data['POSTER']);
    }
    if (isset($data['THUMBNAIL']) && $data['THUMBNAIL'] != '') {
        $urltype = substr($data['THUMBNAIL'], 0, 4);
        if ($urltype == 'http') {
            $thumb_url = str_replace("/w185/", "/original/", $data['THUMBNAIL']);
            //$suffix = basename(substr($data['VIDEO']['PATH'], 0, strrpos($data['VIDEO']['PATH'], "."))).".jpg";
            $suffix = basename($data['THUMBNAIL']);
            $thumb_fname = "thumbnail_s_" . $show_id . "_" . $suffix;
            $data['THUMBNAIL'] = "nmj_database/media/video/thumbnail/" . $thumb_fname;
            $command = 'wget -q "http://images1-focus-opensocial.googleusercontent.com/gadgets/proxy?url=' . $poster_url . '&resize_w=202&resize_h=303&container=focus" -O "' . $data['DRIVE'] . "/" . $data['THUMBNAIL'] . '"';
            shell_exec($command);
        }
        else 
            $data['THUMBNAIL'] = str_replace(basename($data['DRIVE'])."/", "", $data['THUMBNAIL']);
    }
    if (isset($data['WALLPAPER']) && $data['WALLPAPER'] != '') {
        $urltype = substr($data['WALLPAPER'], 0, 4);
        if ($urltype == 'http') {
            $wallpaper_url = str_replace("/w780/", "/original/", $data['WALLPAPER']);
            //$suffix = basename(substr($data['VIDEO']['PATH'], 0, strrpos($data['VIDEO']['PATH'], "."))).".jpg";
            $suffix = basename($data['WALLPAPER']);
            $wall_fname = "wallpaper_s_" . $show_id . "_" . $suffix;
            $data['WALLPAPER'] = "nmj_database/media/video/poster/" . $wall_fname;
            $command = 'wget -q ' . $wallpaper_url . ' -O "' . $data['DRIVE'] . "/" . $data['WALLPAPER'] . '"';
            shell_exec($command);
        }
        else 
            $data['WALLPAPER'] = str_replace(basename($data['DRIVE'])."/", "", $data['WALLPAPER']);
    }
    if (isset($data['POSTER']))
      $dt['POSTER'] = $data['POSTER'];
    if (isset($data['THUMBNAIL']))
      $dt['THUMBNAIL'] = $data['THUMBNAIL'];
    if (isset($data['WALLPAPER']))
      $dt['WALLPAPER'] = $data['WALLPAPER'];
    return $dt;
}

// Function to Add/Edit/Delete Show And Video
function handleImages($dbh, $data, $mode)
{
    global $delete_images, $TMDBAPI;
    switch ($mode) {
        case "updated":
            if(!isset($data['MODE']) || $data['MODE'] == 'single'){
              $tmpdata = $data['SHOW_ID'];
              unset($data['SHOW_ID']);
              $data['SHOW_ID'][] = $tmpdata;
            }
            else
              file_put_contents("data/percent_completed", "");
            for($i=0;$i<count($data['SHOW_ID']);$i++) {
              if($data['MODE'] == "multiple") {
                $sql = 'SELECT CONTENT_TTID,PATH FROM SHOWS,VIDEOS,SHOWS_VIDEOS WHERE VIDEOS.ID=VIDEOS_ID ';
                $sql .= 'AND SHOWS.ID=SHOWS_ID AND SHOWS.ID='.$data['SHOW_ID'][$i];
                $result = DBQuery($dbh, $sql);
                $data['VIDEO'] = $result->fetch(PDO::FETCH_ASSOC);
                $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://api.themoviedb.org/3/movie/" .
                str_replace('tmdb','',$data['VIDEO']['CONTENT_TTID']) . "/images?api_key=" . $TMDBAPI . " -qO-";
                $output = shell_exec($command);
                $json_parser = json_decode($output, true);
                if(count($json_parser['posters']) > 0) {
                  $data['POSTER'] =  "http://image.tmdb.org/t/p/w185" . $json_parser['posters'][0]['file_path'];
                  $data['THUMBNAIL'] = "http://image.tmdb.org/t/p/w185" . $json_parser['posters'][0]['file_path'];
                }
                if(count($json_parser['backdrops']) > 0)
                  $data['WALLPAPER'] = "http://image.tmdb.org/t/p/w780" . $json_parser['backdrops'][0]['file_path'];
              }
            $imgdata = setImageData($data, $data['SHOW_ID'][$i]);
            $sql = 'UPDATE VIDEO_POSTERS SET ';
            $tarry = array();
            if (isset($imgdata['POSTER']))
                $tarry[] .= 'POSTER="' . $imgdata['POSTER'] . '"';
            if (isset($imgdata['THUMBNAIL']))
                $tarry[] .= 'THUMBNAIL="' . $imgdata['THUMBNAIL'] . '"';
            if (isset($imgdata['WALLPAPER']))
                $tarry[] .= 'WALLPAPER="' . $imgdata['WALLPAPER'] . '"';
            $sql .= implode(",", $tarry);
            $sql .= ',TYPE="1",';
            $sql .= 'CREATE_TIME="' . date("Y-m-d H:i:s") . '" ';
            $sql .= 'WHERE ID=' . $data['SHOW_ID'][$i];
            DBQuery($dbh, $sql);
            if($data['MODE'] == 'multiple') {
            $percent = (($i+1) * 100) / count($data['SHOW_ID']);
            file_put_contents("data/percent_completed", $percent."\n");
            }
            if($data['MODE'] == 'single')
              return $imgdata;
            }
        break;

        case "deleted":
            $sql = 'DELETE FROM VIDEO_POSTERS ';
            $sql .= 'WHERE ID=' . $data['SHOW_ID'];
            DBQuery($dbh, $sql);
        if ($delete_images == "yes") {
            if (file_exists($data['DRIVE_PATH'] . $row['POSTER']))
                unlink($data['DRIVE_PATH'] . $row['POSTER']);
            if (file_exists($data['DRIVE_PATH'] . $row['THUMBNAIL']))
                unlink($data['DRIVE_PATH'] . $row['THUMBNAIL']);
            if (file_exists($data['DRIVE_PATH'] . $row['WALLPAPER']))
                unlink($data['DRIVE_PATH'] . $row['WALLPAPER']);
        }
        break;
    }
}

// Function to Add/Edit/Delete Show And Video
function handleShow($dbh, $data, $mode, $show_id)
{
    $search = array("A ", "An ", "The ", "Le ", "Les ", "&quot;");
    $data['SEARCH_TITLE'] = str_replace($search, "", $data['TITLE']);
    switch ($mode) {
        case "inserted":
                $sql = 'INSERT INTO SHOWS VALUES(NULL,';
                $sql .= '"' . $data['TITLE'] . '",';
                $sql .= '"' . $data['SEARCH_TITLE'] . '",';
                $sql .= 'NULL,1,';
                $sql .= '"' . $data['RELEASE_DATE'] . '",';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= '"' . $data['RATING'] . '",';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= $data['PARENTAL_CONTROL'] . ',';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= $data['TITLE_TYPE'] . ',';
                $sql .= 'NULL,';
                $sql .= '"' . $data['CAST_ID'] . '",';
                $sql .= '3,';
                $sql .= '"' . $data['TTID'] . '",';
                $sql .= '0,NULL,NULL,NULL,NULL,NULL)';
                DBQuery($dbh, $sql);
                $showid = $dbh->lastInsertId();
            break;

        // Update
        case "updated":
            // Update Show
                $sql = 'UPDATE SHOWS SET TITLE="' . $data['TITLE'] . '",';
                $sql .= 'SEARCH_TITLE="' . $data['SEARCH_TITLE'] . '",';
                $sql .= 'YEAR="' . $data['YEAR'] . '",';
                $sql .= 'RELEASE_DATE="' . $data['RELEASE_DATE'] . '",';
                $sql .= 'RATING="' . $data['RATING'] . '",';
                $sql .= 'PARENTAL_CONTROL="' . $data['PARENTAL_CONTROL'] . '",';
                $sql .= 'CONTENT_TTID="' . $data['CONTENT_TTID'] . '",';
                $sql .= 'UPDATE_STATE=6,';
                $sql .= 'TTID="' . $data['TTID'] . '" WHERE ID=' . $show_id;
            DBQuery($dbh, $sql);
            break;

        // Delete
        case "deleted":
            // Check any VIDEO is using SHOW_ID
                $sql = 'DELETE FROM SHOWS WHERE ID=' . $data['SHOW_ID'];
                DBQuery($dbh, $sql);
            break;
    }
}

// Function to Add/Edit/Delete Show And Video
function handleVideo($dbh, $nmj_data, $mode)
{
    switch ($mode) {
        case "inserted":
                $sql = 'INSERT INTO VIDEOS VALUES(NULL,';
                $sql .= '"' . $nmj_data['PATH'] . '",';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= '0,';
                $sql .= '"' . $nmj_data['RATING'] . '",';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= '"' . $nmj_data['PARENTAL_RATING'] . '",';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= '0,';
                $sql .= '0,';
                $sql .= '0,';
                $sql .= $nmj_data['SHOW_ID'] . ',';
                $sql .= '0,';
                $sql .= 'NULL,';
                $sql .= 'NULL,';
                $sql .= '"' . $nmj_data['CAST_ID'] . '",';
                $sql .= '2,';
                $sql .= 'NULL,NULL,';
                $sql .= '"' . $nmj_data['TTID'] . '",';
                $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL)';
                DBQuery($dbh, $sql);
                $videoid = $dbh->lastInsertId();
                return $videoid;
            break;

        // Update
        case "updated":
                $sql = 'UPDATE VIDEOS SET ';
                $sql .= 'PATH="' . $nmj_data['PATH'] . '",';
                $sql .= 'UPDATE_STATE="6",';
                $sql .= 'SIZE=' . $nmj_data['SIZE'];
                $sql .= ' WHERE ID=' . $nmj_data['VIDEO_ID'];
                DBQuery($dbh, $sql);
            break;

        // Delete
        case "deleted":
                $sql = 'DELETE FROM VIDEOS WHERE ID=' . $nmj_data['VIDEO_ID'];
                DBQuery($dbh, $sql);
            break;
    }
}

// Function to Add/Edit/Delete Video Synopsis
function handleVideoSynopsis($dbh, $data, $mode, $show_id)
{
    if ($data['CONTENT'] == '')
        $synopsis = 'NULL';
    else
        $synopsis = '"' . setXMLSafe($data['CONTENT']) . '"';
    switch ($mode) {
        case "inserted":
                $sql = 'INSERT INTO SYNOPSISES VALUES(' . $show_id . ',' . $synopsis . ',NULL,';
                $sql .= 'NULL,NULL,NULL,NULL,NULL)';
                DBQuery($dbh, $sql);
            break;

        // Update
        case "updated":
                $sql = 'SELECT SUMMARY FROM SYNOPSISES WHERE ';
                $sql .= 'ID=' . $show_id;
                $result = DBQuery($dbh, $sql);
                $row = $result->fetch(PDO::FETCH_ASSOC);
                if (isset($row['SUMMARY'])) {
                    $sql = 'UPDATE SYNOPSISES SET SUMMARY=' . $synopsis . ' ';
                    $sql .= 'WHERE ID=' . $show_id;
                    DBQuery($dbh, $sql);
                } else
                    handleVideoSynopsis($dbh, $data, "inserted");
            break;

        // Delete
        case "deleted":
            break;
    }
}

// Function to Add/Delete Video Group Name (i.e. movie by alphabet)
function handleVideoGroupName($dbh, $nmj_data, $mode)
{
    $search = array("A ", "An ", "The ", "Le ", "Les ", "&quot;");
    $replace = array("", "", "", "", "", "");
    if (isset($nmj_data['TITLE']))
        $alphabet = strtoupper(substr(str_replace($search, $replace, $nmj_data['TITLE']), 0, 1));
    switch ($mode) {
        case "inserted":
                $sql = 'SELECT ID FROM SHOW_GROUPS WHERE NAME="' . $alphabet . '"';
                $result = DBQuery($dbh, $sql);
                $row = $result->fetch(PDO::FETCH_ASSOC);
                if (!isset($row['ID'])) {
                    $sql = 'INSERT INTO SHOW_GROUPS VALUES(NULL,';
                    $sql .= '"' . $alphabet . '",NULL,"EN",NULL,NULL,NULL,NULL,NULL)';
                    DBQuery($dbh, $sql);
                    $nmj_data['GROUPS_ID'] = $dbh->lastInsertId();
                } else
                    $nmj_data['GROUPS_ID'] = $row['ID'];
            return $nmj_data;
            break;
    }
}

// Function to Add/Delete/Edit MPAA
function handleVideoGroup($dbh, $data, $mode, $show_id)
{
    switch ($mode) {
        case "inserted":
                $sql = 'INSERT INTO SHOW_GROUPS_SHOWS VALUES(NULL,' . $data['GROUPS_ID'] . ',';
                $sql .= $show_id . ',"' . $data['TITLE_TYPE'] . '",';
                $sql .= 'NULL,NULL,NULL,NULL,NULL)';
                DBQuery($dbh, $sql);
            break;

        // Update
        case "updated":
                $sql = 'UPDATE SHOW_GROUPS_SHOWS SET GROUPS_ID=' . $data['GROUPS_ID'] . ',';
                $sql .= 'TITLE_TYPE=' . $data['TITLE_TYPE'];
                $sql .= ' WHERE SHOWS_ID=' . $show_id;
                DBQuery($dbh, $sql);
            break;

        // Delete
        case "deleted":
                $sql = 'DELETE FROM SHOW_GROUPS_SHOWS WHERE SHOWS_ID=' . $show_id;
                DBQuery($dbh, $sql);
            break;
    }
}

// Function to Add/Remove/Edit Person
function handleVideoPerson($dbh, $nmj_data, $mode, $show_id)
{
    $cast = explode("#", $nmj_data['CAST']);
    $cast_array = array();
    $cast_array[0] = 0;
    switch ($mode) {
        case "inserted":
            // Insert
                for ($i = 0; $i < count($cast); $i++) {
                    $sql = 'SELECT ID FROM VIDEO_PERSONS WHERE ';
                    $sql .= 'NAME="' . $cast[$i] . '"';
                    $result = DBQuery($dbh, $sql);
                    $row = $result->fetch(PDO::FETCH_ASSOC);
                    if (!isset($row['ID'])) {
                        $sql = 'INSERT INTO "VIDEO_PERSONS" VALUES(NULL,';
                        $sql .= '"' . $cast[$i] . '",';
                        $sql .= 'NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                        $row['ID'] = $dbh->lastInsertId();
                    }
                    if (isset($row['ID'])) {
                        $sql = 'INSERT INTO SHOWS_PERSONS VALUES(NULL,' . $row['ID'] . ',';
                        $sql .= $show_id . ',"CAST",NULL,NULL,NULL,NULL,NULL)';
                        DBQuery($dbh, $sql);
                    }
                }
            return $nmj_data;
            break;
        case "updated":
            handleVideoPerson($dbh, $nmj_data, "deleted");
            handleVideoPerson($dbh, $nmj_data, "inserted");
            return $nmj_data;
            break;
        case "deleted":
                $sql = 'DELETE FROM SHOWS_PERSONS WHERE SHOWS_ID=' . $show_id;
                $sql .= ' AND PERSON_TYPE="CAST"';
                DBQuery($dbh, $sql);
            break;
    }
}

function getDefaultImageFromTMDB($tmdbid)
{
    global $TMDBAPI;

    $data = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://api.themoviedb.org/3/configuration?api_key=" . $TMDBAPI . " -qO-");
    $json_parser = json_decode($data, true);
    $config['base_url']= $json_parser['images']['base_url'];

    $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://api.themoviedb.org/3/movie/" .
    str_replace('tmdb','',$tmdbid) . "?api_key=" . $TMDBAPI . " -qO-";
    $data = shell_exec($command);
    $json_parser = json_decode($data, true);

    foreach($json_parser as $key => $tdata){
        if ($key == 'poster_path') {
            if ($tdata != '') {
                $nmj_data['THUMBNAIL'] = $config['base_url'].'w300'.$tdata;
                $nmj_data['POSTER'] = $config['base_url'].'w300'.$tdata;
            }
            else {
                $nmj_data['THUMBNAIL'] = '';
                $nmj_data['POSTER'] = '';
            }
        }
        else if ($key == 'backdrop_path') {
            if ($tdata != '')
                $nmj_data['WALLPAPER'] = $config['base_url'].'w1920'.$tdata;
            else
                $nmj_data['WALLPAPER'] = '';
        }
    }
    return($nmj_data);
}

function findMovies($input_folder)
{
    global $file_extensions;
    $count = 0;
    $movie_names = array();
    foreach ($input_folder as $folder) {
        if (file_exists($folder)) {
            $files = preg_find('/./', $folder, PREG_FIND_RECURSIVE);
            if ($files != false && count($files) > 0) {
                foreach ($files as $file) {
                    foreach ($file_extensions as $extension) {
                        if (strtoupper(substr(strrchr($file, "."), 1)) == $extension) {
                            if ($extension == "VOB") {
                                $folder_name = strtoupper(substr(strrchr(dirname($file), "/"), 1));
                                if ($folder_name == "VIDEO_TS") {
                                    $dvd_movie = basename(dirname(dirname($file)));
                                    if (array_search_r(dirname($file), $movie_names) == 0) {
                                        $movie_names[$count]['id'] = dirname($file);
                                        $movie_names[$count++]['name'] = $dvd_movie;
                                    }
                                } else {
                                    $movie_names[$count]['id'] = $file;
                                    $movie_names[$count++]['name'] = substr(basename($file), 0, strrpos(basename($file), "."));
                                }
                            } else if ($extension == "M2TS") {
                                $folder_name = strtoupper(substr(strrchr(dirname($file), "/"), 1));
                                if ($folder_name == "STREAM") {
                                    $parent_folder = basename(dirname(dirname($file)));
                                    if ($parent_folder == "BDMV")
                                        $bd_movie = basename(dirname(dirname(dirname($file))));
                                    else
                                        $bd_movie = basename(dirname(dirname($file)));
                                    if (array_search_r(dirname($file), $movie_names) == 0) {
                                        $movie_names[$count]['id'] = dirname($file);
                                        $movie_names[$count++]['name'] = $bd_movie;
                                    }
                                } else {
                                    $movie_names[$count]['id'] = $file;
                                    $movie_names[$count++]['name'] = substr(basename($file), 0, strrpos(basename($file), "."));
                                }
                            } else {
                                $mov_name = substr(basename($file), 0, strrpos(basename($file), "."));
                                $part_number = strtoupper(substr(strrchr($mov_name, "."), 1));
                                if ($part_number != "CD2" && $part_number != "CD3" &&
                                    $part_number != "CD4"
                                ) {
                                    $movie_names[$count]['id'] = $file;
                                    $movie_names[$count++]['name'] = substr(basename($file), 0, strrpos(basename($file), "."));
                                }
                            }
                            break;
                        }
                    }
                }
            }
        }
    }
    return $movie_names;
}

function readNFOFile($nfofile)
{
    $fp = fopen($nfofile, "r");
    $xdata = fread($fp, filesize($nfofile));
    fclose($fp);
    $xml_parser = xml_parser_create();
    xml_parse_into_struct($xml_parser, $xdata, $vals, $index);
    xml_parser_free($xml_parser);
    $genre_count = 0;
    $actor_count = 0;
    $nfo_array = array();
    $prev_tag = array();
    $director = array();
    $actor = array();

    foreach ($vals as $xml_elem) {
        if ($xml_elem['tag'] == 'TITLE')
            $nfo_array = array_push_assoc($nfo_array, "title", utf8_decode($xml_elem['value']));
        if ($xml_elem['tag'] == 'RATING')
            $nfo_array = array_push_assoc($nfo_array, "rating", $xml_elem['value']);
        if ($xml_elem['tag'] == 'YEAR')
            $nfo_array = array_push_assoc($nfo_array, "year", $xml_elem['value']);
        if ($xml_elem['tag'] == 'OUTLINE')
            $nfo_array = array_push_assoc($nfo_array, "synopsis", $xml_elem['value']);
        if ($xml_elem['tag'] == 'THUMB' && $xml_elem['level'] == 2)
            $nfo_array = array_push_assoc($nfo_array, "poster", $xml_elem['value']);
        if ($xml_elem['tag'] == 'THUMBS')
            $nfo_array = array_push_assoc($nfo_array, "posters", $xml_elem['value']);
        if ($xml_elem['tag'] == 'FANART')
            $nfo_array = array_push_assoc($nfo_array, "wallpaper", $xml_elem['value']);
        if ($xml_elem['tag'] == 'FANARTS')
            $nfo_array = array_push_assoc($nfo_array, "fanarts", $xml_elem['value']);
        if ($xml_elem['tag'] == 'CERTIFICATION') {
            $mpaa = explode(" / ", $xml_elem['value']);
            $arr = preg_grep("|USA:(.*)|", $mpaa);
            $arr = array_values($arr);
            if (count($arr) > 0)
                $mpaa = explode(":", $arr[0]);
            $nfo_array = array_push_assoc($nfo_array, "mpaa", $mpaa[1]);
        }
        if ($xml_elem['tag'] == 'ID') {
            if ($xml_elem['value'] != '') {
                $nfo_array = array_push_assoc($nfo_array, "imdbid", $xml_elem['value']);
            }
        }
        if ($xml_elem['tag'] == 'ID' && array_key_exists('attributes', $xml_elem) && $xml_elem['attributes']['MOVIEDB'] == 'tmdb')
            $nfo_array = array_push_assoc($nfo_array, "tmdbid", $xml_elem['value']);
        if ($xml_elem['tag'] == 'DIRECTOR') {
            $director = array_push_assoc($director, "name", utf8_decode($xml_elem['value']));
            $nfo_array = array_push_assoc($nfo_array, "director", $director);
        }
        if ($xml_elem['tag'] == 'GENRE') {
            $genre[$genre_count++] = $xml_elem['value'];
        }
        if ($xml_elem['tag'] == 'NAME' && $prev_tag == 'ACTOR') {
            $actor[$actor_count] = array_push_assoc($actor[$actor_count], "name", utf8_decode($xml_elem['value']));
            $principal_cast[$actor_count] = utf8_decode($xml_elem['value']);
        }
        if ($xml_elem['tag'] == 'THUMB' && $prev_tag == 'ACTOR') {
            $actor[$actor_count] = array_push_assoc($actor[$actor_count], "thumb", $xml_elem['value']);
            $actor_count++;
        }
        if ($xml_elem['tag'] == 'RELEASEDATE')
            $nfo_array = array_push_assoc($nfo_array, "release_date", date("Y-m-d", strtotime($xml_elem['value'])));
        $prev_tag = $xml_elem['tag'];
    }
    if (count($genre) == 1) {
        $genre = explode(" / ", $genre[0]);
        $nfo_array = array_push_assoc($nfo_array, "genre", $genre);
    } else
        $nfo_array = array_push_assoc($nfo_array, "genre", $genre);
    $nfo_array = array_push_assoc($nfo_array, "actor", $actor);
    $nfo_array = array_push_assoc($nfo_array, "principal_cast", $principal_cast);
    return $nfo_array;
}

function aasort (&$array, $key) {
    $sorter=array();
    $ret=array();
    reset($array);
    foreach ($array as $ii => $va) {
        $sorter[$ii]=$va[$key];
    }
    arsort($sorter);
    $i=0;
    foreach ($sorter as $ii => $va) {
        $ret[$i++]=$array[$ii];
    }
    $array=$ret;
}

function loadCollectionData($dbpath, $showid, $drivepath, $sourceurl)
{
    $dbh = new PDO('sqlite:' . $dbpath);
    $sql = 'SELECT ID,TITLE,OVERVIEW,POSTER,CONTENT_TTID ';
    $sql .= 'FROM COLLECTIONS ';
    $sql .= 'WHERE ID='. $showid;
    $result = DBQuery($dbh, $sql);
    $nmj_data = $result->fetch(PDO::FETCH_ASSOC);
    $nmj_data['tmdbid'] = str_replace("tmdb", "", $nmj_data['CONTENT_TTID']);
    $sql = 'SELECT SHOW_ID FROM SHOWS_COLLECTIONS WHERE COLLECTIONS_ID='.$showid;
    $count = 0;
    foreach ($dbh->query($sql) as $collection_data) {
      $sql = 'SELECT CONTENT_TTID,PLAY_COUNT,TITLE,TITLE_TYPE,POSTER,THUMBNAIL,WALLPAPER ';
      $sql .= 'FROM SHOWS_VIDEOS,SHOWS,VIDEOS,VIDEO_POSTERS WHERE ';
      $sql .= ' SHOWS.ID='.$collection_data['SHOW_ID'].' AND SHOWS_ID=SHOWS.ID ';
      $sql .= ' AND VIDEO_POSTERS.ID=SHOWS.ID';
      $result = DBQuery($dbh, $sql);
      $nmj_data['Movies'][$count] = $result->fetch(PDO::FETCH_ASSOC);
      $nmj_data['Movies'][$count]['tmdbid'] = str_replace("tmdb", "", $nmj_data['Movies'][$count]['CONTENT_TTID']);
      $count++;
    }
    return $nmj_data;
}

function loadMovieData($dbpath, $showid, $drivepath, $sourceurl)
{
    $nmj_data = array();
    $mediapath = dirname(dirname($dbpath));
    $dbh = new PDO('sqlite:' . $dbpath);
    $sql .= 'SELECT SHOWS.ID AS SHOW_ID, SHOWS.TITLE,SHOWS.SEARCH_TITLE,SHOWS.RELEASE_DATE,SHOWS.UPDATE_STATE,';
    $sql .= 'SHOWS.RATING,SHOWS.PARENTAL_CONTROL,SHOWS.TOTAL_ITEM,SHOWS.THREE_D,';
    $sql .= 'SHOWS.YEAR,SHOWS.TTID,SHOWS.RUNTIME,SHOWS.TITLE_TYPE,';
    $sql .= 'SHOWS.CREATE_TIME,SHOWS.CONTENT_TTID,SHOWS.CONTENT_TTID AS tmdbid,';
    $sql .= 'SYNOPSISES.SUMMARY AS CONTENT,VIDEO_POSTERS.POSTER,';
    $sql .= 'VIDEO_POSTERS.THUMBNAIL,VIDEO_POSTERS.WALLPAPER ';
    $sql .= 'FROM SHOWS,SYNOPSISES,VIDEO_POSTERS,SHOWS_VIDEOS ';
    $sql .= 'WHERE SHOWS.ID=' . $showid . ' AND ';
    $sql .= 'SYNOPSISES.ID=SHOWS.ID AND ';
    $sql .= 'VIDEO_POSTERS.ID=SHOWS.ID ';
    $sql .= ' ORDER BY SHOWS.ID'; 

    $result = DBQuery($dbh, $sql);
    $nmj_data = $result->fetch(PDO::FETCH_ASSOC);
    $nmj_data['tmdbid'] = str_replace("tmdb", "", $nmj_data['tmdbid']);

    $sql = 'SELECT NAME FROM VIDEO_GENRES WHERE ID IN (SELECT GENRES_ID FROM SHOWS_GENRES WHERE SHOWS_ID='.$showid.')';
    $result = DBQuery($dbh, $sql);
    $grow = $result->fetchAll(PDO::FETCH_COLUMN);
    if (is_array($grow))
        $nmj_data['GENRE'] = $grow;
    else
        $nmj_data['GENRE'] = array();

    //$nmj_data = fixImagePath($mediapath, $nmj_data);

    if (!isset($nmj_data['WALLPAPER']))
        $nmj_data['WALLPAPER'] = '';
    if (!isset($nmj_data['POSTER']))
        $nmj_data['POSTER'] = '';
    if (!isset($nmj_data['THUMBNAIL']))
        $nmj_data['THUMBNAIL'] = '';

    $nmj_data['CONTENT'] = html_entity_decode(str_replace("&rsquo;","'", $nmj_data['CONTENT']), ENT_QUOTES|ENT_HTML5);

    if ($nmj_data['PARENTAL_CONTROL'] == '')
        $nmj_data['PARENTAL_CONTROL'] = "NR";

    /*$sql = 'SELECT GROUPS_ID FROM SHOW_GROUPS_SHOWS ';
    $sql .= 'WHERE SHOWS_ID=' . $nmj_data['SHOW_ID'];
    $result = DBQuery($dbh, $sql);
    $result_row = $result->fetch(PDO::FETCH_ASSOC);
    $nmj_data = array_merge($nmj_data, $result_row);

    if (is_array($result_row)) {
        $sql = 'SELECT NAME AS GROUP_NAME FROM SHOW_GROUPS ';
        $sql .= 'WHERE ID=' . $result_row['GROUPS_ID'];
        $result = DBQuery($dbh, $sql);
        $result_row = $result->fetch(PDO::FETCH_ASSOC);
        if ($result_row)
            $nmj_data = array_merge($nmj_data, $result_row);
    }*/

    $sql = 'SELECT VIDEOS_ID AS VIDEO_ID ';
    $sql .= 'FROM SHOWS_VIDEOS WHERE SHOWS_ID='.$showid;
    $result = DBQuery($dbh, $sql);
    $shows_videos = $result->fetchAll(PDO::FETCH_ASSOC);

    for($i=0;$i<count($shows_videos);$i++) {
    $sql = 'SELECT VIDEOS.ID AS VIDEO_ID, VIDEOS.SIZE,VIDEOS.PATH,VIDEO_PROPERTIES.RESOLUTION,VIDEO_PROPERTIES.WIDTH,';
    $sql .= 'VIDEOS.FILE_TYPE, VIDEOS.SCAN_DIRS_ID, VIDEOS.CREATE_TIME,VIDEOS.UPDATE_STATE,';
    $sql .= 'VIDEOS.FILE_STATUS,VIDEOS.THREE_D,VIDEO_PROPERTIES.RUNTIME,';
    $sql .= 'VIDEO_PROPERTIES.HEIGHT,VIDEO_PROPERTIES.ASPECT_RATIO,VIDEO_PROPERTIES.SYSTEM,';
    $sql .= 'VIDEO_PROPERTIES.VIDEO_CODEC,VIDEO_PROPERTIES.FPS,VIDEOS.PLAY_COUNT ';
    $sql .= 'FROM VIDEOS,VIDEO_PROPERTIES WHERE ';
    $sql .= 'VIDEO_PROPERTIES.ID=VIDEOS.ID AND ';
    $sql .= 'VIDEOS.ID='.$shows_videos[$i]['VIDEO_ID'];
    $result = DBQuery($dbh, $sql);
    $nmj_data['VIDEO'][$i] = $result->fetch(PDO::FETCH_ASSOC);
    $sql = 'SELECT FILE_NAME,LANGUAGE,TYPE FROM VIDEO_SUBTITLES ';
    $sql .= 'WHERE VIDEOS_ID='.$shows_videos[$i]['VIDEO_ID'];
    $result = DBQuery($dbh, $sql);
    $result_row = $result->fetch(PDO::FETCH_ASSOC);
    if (is_array($result_row))
      $nmj_data['VIDEO'][$i] = array_merge($nmj_data['VIDEO'][$i], $result_row);

    $sql = 'SELECT BOOKMARK_TIME,THUMBNAIL AS BOOKMARK_THUMBNAIL FROM VIDEO_BOOKMARKS ';
    $sql .= 'WHERE VIDEOS_ID=' . $shows_videos[$i]['VIDEO_ID'];
    $result = DBQuery($dbh, $sql);
    $result_row = $result->fetch(PDO::FETCH_ASSOC);
    if (is_array($result_row)) {
        $nmj_data['VIDEO'][$i] = array_merge($nmj_data['VIDEO'][$i], $result_row);
        $nmj_data['VIDEO'][$i]['BOOKMARK_SECONDS'] = $nmj_data['VIDEO'][$i]['BOOKMARK_TIME'];
        $nmj_data['VIDEO'][$i]['BOOKMARK_TIME'] = sprintf('%02d:%02d:%02d', ($nmj_data['VIDEO'][$i]['BOOKMARK_TIME'] / 3600), ($nmj_data['VIDEO'][$i]['BOOKMARK_TIME'] / 60 % 60), $nmj_data['VIDEO'][$i]['BOOKMARK_TIME'] % 60);
    }
}
    /*$sql = 'SELECT NAME FROM VIDEO_PERSONS WHERE ID IN (SELECT PERSONS_ID FROM ';
    $sql .= 'SHOWS_PERSONS WHERE SHOWS_ID=' . $showid . ' AND PERSON_TYPE="CAST")';
        $result = $dbh->query($sql);
        $trow = $result->fetchAll(PDO::FETCH_COLUMN);
    if (is_array($trow))
        $nmj_data['CAST'] = $trow;
    else
        $nmj_data['CAST'] = array();*/

    /*$sql = 'SELECT PERSONS_ID FROM SHOWS_PERSONS WHERE SHOWS_ID=' . $showid . ' AND PERSON_TYPE="CAST"';
    $cast_array[] = 0;
    foreach ($dbh->query($sql) as $cast_row)
        $cast_array[] = $cast_row['PERSONS_ID'];
    $cast_array[] = 0;

    $cnt=0;
    for ($z = 1; $z < count($cast_array) - 1; $z++) {
        $sql = 'SELECT NAME FROM VIDEO_PERSONS WHERE ID=' . $cast_array[$z];
        $result = $dbh->query($sql);
        $trow = $result->fetch(PDO::FETCH_ASSOC);
        $cast[$cnt] = html_entity_decode($trow['NAME'], ENT_QUOTES|ENT_HTML5);
        $cnt++;
    }
    if (is_array($cast))
        $nmj_data['CAST'] = $cast;
    else
        $nmj_data['CAST'] = array();*/

    /*$sql = 'SELECT KEYWORDS_ID FROM SHOWS_KEYWORDS WHERE SHOWS_ID=' . $showid;
    foreach ($dbh->query($sql) as $key_row) {
        $sql = 'SELECT KEYWORD FROM KEYWORDS WHERE ID=' . $key_row['KEYWORDS_ID'];
        $result = DBQuery($dbh, $sql);
        $krow[] = $result->fetch(PDO::FETCH_COLUMN);
    }
    if (is_array($krow))
        $nmj_data['KEYWORD'] = $krow;
    else
        $nmj_data['KEYWORD'] = array();*/

    /*$sql = 'SELECT PERSONS_ID FROM SHOWS_PERSONS WHERE SHOWS_ID=' . $showid . ' AND PERSON_TYPE="DIRECTOR"';
    $cnt=0;
    foreach ($dbh->query($sql) as $cast_row) {
        $sql = 'SELECT NAME FROM VIDEO_PERSONS WHERE ID=' . $cast_row['PERSONS_ID'];
        $result = DBQuery($dbh, $sql);
        $trow = $result->fetch(PDO::FETCH_ASSOC);
        $drow[$cnt] = html_entity_decode($trow['NAME'], ENT_QUOTES|ENT_HTML5);
        $cnt++;
    }
    if (is_array($drow))
        $nmj_data['DIRECTOR'] = $drow;
    else
        $nmj_data['DIRECTOR'] = array();*/

    $sql = 'SELECT ID FROM FAVOURITES WHERE MEDIA_ID=' . $showid;
    $result = DBQuery($dbh, $sql);
    $favid = $result->fetch();
    if (isset($favid['ID']))
        $nmj_data['FAVOURITE'] = $favid['ID'];
    else
        $nmj_data['FAVOURITE'] = '';

    //$nmj_data['DRIVE'] = str_replace("nmj_database/media.db", "", $drivepath);
    //$nmj_data['DB_PATH'] = $dbpath;

    $sql = "SELECT count(*) FROM sqlite_master WHERE type='table' AND name='CHAPTERS'";
    $result = DBQuery($dbh, $sql);
    $exists = $result->fetch(PDO::FETCH_NUM);

    if ($exists[0] != 0) {
        $sql = 'SELECT CHAPTER,CHAPTER_TEXT,RUNTIME FROM CHAPTERS WHERE ';
        $sql .= 'SHOW_ID=' . $nmj_data['SHOW_ID'] . ' ORDER BY CHAPTER';
        $result = DBQuery($dbh, $sql);
        $allchapters = $result->fetchAll(PDO::FETCH_ASSOC);
        if ($allchapters) {
            for($i=0;$i<count($allchapters);$i++) {
                $allchapters[$i]['RUNTIME_TEXT'] = sec2hms($allchapters[$i]['RUNTIME']);
                $allchapters[$i]['CHAPTER_TEXT'] = html_entity_decode($allchapters[$i]['CHAPTER_TEXT'], ENT_QUOTES|ENT_HTML5);
            }
            $nmj_data['CHAPTERS'] = $allchapters;
        }
    }
    if (! is_array($nmj_data['CHAPTERS'])) {
        $no_chapters = floor($nmj_data['RUNTIME'] / 600) + 1;
        $tdata=array();
        for ($z = 0; $z < $no_chapters - 1; $z++) {
            $tdata[$z]['CHAPTER'] = ($z + 1);
            $tdata[$z]['CHAPTER_TEXT'] = 'Chapter ' . ($z + 1);
            $tdata[$z]['RUNTIME'] = (600 * $z);
            $tdata[$z]['RUNTIME_TEXT'] = sec2hms(600 * $z);
        }
        $nmj_data['CHAPTERS'] = $tdata;
    }
    return $nmj_data;
}

function loadSeasons($dbh, $showid, $mediapath)
{
    $sql = 'SELECT SHOWS.TITLE,SHOWS.SEARCH_TITLE,SHOWS.RELEASE_DATE,';
    $sql .= 'SHOWS.RATING,SHOWS.PARENTAL_CONTROL,SHOWS.TOTAL_ITEM,';
    $sql .= 'SHOWS.YEAR,SHOWS.TTID,SHOWS.RUNTIME,SHOWS.TITLE_TYPE,';
    $sql .= 'SHOWS.ID AS SHOW_ID,SHOWS.CREATE_TIME,SHOWS.CONTENT_TTID,';
    $sql .= 'SYNOPSISES.SUMMARY AS CONTENT,VIDEO_POSTERS.POSTER,';
    $sql .= 'VIDEO_POSTERS.THUMBNAIL,VIDEO_POSTERS.WALLPAPER ';
    $sql .= 'FROM SHOWS,SYNOPSISES,VIDEO_POSTERS ';
    $sql .= 'WHERE SHOWS.ID=' . $showid . ' AND ';
    $sql .= 'SYNOPSISES.ID=' . $showid . ' AND ';
    $sql .= 'VIDEO_POSTERS.ID=' . $showid;

    $result = DBQuery($dbh, $sql);
    $nmj_data = $result->fetch(PDO::FETCH_ASSOC);
    //$nmj_data = fixImagePath($mediapath, $nmj_data);

       $sql = 'SELECT DISTINCT SHOWS.ID AS SEASON_ID, SHOWS.TITLE,SHOWS.PARENTAL_CONTROL,SEASON,';
        $sql .= 'SHOWS.YEAR,SHOWS.RATING,SHOWS.TITLE_TYPE,';
        $sql .= 'VIDEO_POSTERS.POSTER,VIDEO_POSTERS.THUMBNAIL ';
        $sql .= 'FROM SHOWS,VIDEO_POSTERS,EPISODES ';
        $sql .= 'WHERE EPISODES.SERIES_ID=' . $showid . ' AND ';
        $sql .= 'SHOWS.ID=EPISODES.SEASON_ID AND ';
        $sql .= 'VIDEO_POSTERS.ID=SHOWS.ID ';
        $sql .= 'ORDER BY EPISODES.SEASON ';

        $result = DBQuery($dbh, $sql);
        $nmj_data['seasons'] = $result->fetchAll(PDO::FETCH_ASSOC);

    $sql = 'SELECT GENRES_ID FROM SHOWS_GENRES WHERE SHOWS_ID=' . $showid;
    foreach ($dbh->query($sql) as $genre_row) {
        $sql = 'SELECT NAME FROM VIDEO_GENRES WHERE ID=' . $genre_row['GENRES_ID'];
        $result = DBQuery($dbh, $sql);
        $grow[] = $result->fetch(PDO::FETCH_COLUMN);
    }
    if (isset($grow))
        $nmj_data['GENRE'] = $grow;
    else
        $nmj_data['GENRE'] = '';

        $count = count($nmj_data['seasons']);
        for($i=0;$i<count($nmj_data['seasons']);$i++){
          //$nmj_data['seasons'][$i] = fixImagePath($mediapath, $nmj_data['seasons'][$i]);
    $sql = 'SELECT COUNT(*) FROM EPISODES WHERE ';
    $sql .= 'SEASON_ID=' . $nmj_data['seasons'][$i]['SEASON_ID']; 
        $result = DBQuery($dbh, $sql);
        $nmj_data['seasons'][$i]['episode_count'] = $result->fetch(PDO::FETCH_COLUMN);
        }
        return $nmj_data;
}

function loadSeasonData($dbh, $showid, $season, $mediapath)
{
    $nmj_data = array();
       $sql = 'SELECT DISTINCT SHOWS.ID AS SEASON_ID, SHOWS.TITLE,SHOWS.PARENTAL_CONTROL,SEASON,';
        $sql .= 'SHOWS.YEAR,SHOWS.RATING,SHOWS.TITLE_TYPE,';
        $sql .= 'VIDEO_POSTERS.POSTER,VIDEO_POSTERS.THUMBNAIL,';
        $sql .= 'SYNOPSISES.SUMMARY AS CONTENT ';
        $sql .= 'FROM SHOWS,VIDEO_POSTERS,EPISODES,SYNOPSISES ';
        $sql .= 'WHERE EPISODES.SERIES_ID=' . $showid . ' AND ';
        $sql .= 'SHOWS.ID=EPISODES.SEASON_ID AND ';
        $sql .= 'VIDEO_POSTERS.ID=SHOWS.ID AND ';
        $sql .= 'SYNOPSISES.ID=' . $showid . ' ';
        $sql .= 'ORDER BY EPISODES.SEASON ';

        $result = DBQuery($dbh, $sql);
        $nmj_data = $result->fetch(PDO::FETCH_ASSOC);
print_r($nmj_data);
exit;

    $sql = 'SELECT GENRES_ID FROM SHOWS_GENRES WHERE SHOWS_ID=' . $showid;
    foreach ($dbh->query($sql) as $genre_row) {
        $sql = 'SELECT NAME FROM VIDEO_GENRES WHERE ID=' . $genre_row['GENRES_ID'];
        $result = DBQuery($dbh, $sql);
        $grow[] = $result->fetch(PDO::FETCH_COLUMN);
    }
    if (isset($grow))
        $nmj_data['GENRE'] = $grow;
    else
        $nmj_data['GENRE'] = '';

       $sql = 'SELECT DISTINCT SHOWS.ID AS SHOW_ID,SEASON ';
        $sql .= 'FROM SHOWS,EPISODES ';
        $sql .= 'WHERE EPISODES.SERIES_ID=' . $showid . ' AND ';
        $sql .= 'SHOWS.ID=EPISODES.SEASON_ID';

    $scount = 0;
    foreach ($dbh->query($sql) as $seasons) {
    $sdata[$scount]['SEASON_ID'] = $seasons['SHOW_ID'];
    $sdata[$scount]['SEASON'] = $seasons['SEASON'];

    $sql = 'SELECT EPISODE_ID,EPISODE FROM EPISODES WHERE ';
    $sql .= 'SEASON_ID=' . $seasons['SHOW_ID'] . ' ORDER BY EPISODE';
    foreach ($dbh->query($sql) as $episodes) {
        $sql = 'SELECT VIDEOS_ID AS VIDEO_ID FROM SHOWS_VIDEOS ';
        $sql .= 'WHERE SHOWS_ID=' . $episodes['EPISODE_ID'];
        $result = DBQuery($dbh, $sql);
        $video_id = $result->fetch(PDO::FETCH_ASSOC);
        $sql = 'SELECT PATH FROM VIDEOS WHERE ID=' . $video_id['VIDEO_ID'];
        $result = DBQuery($dbh, $sql);
        $path = $result->fetch(PDO::FETCH_ASSOC);
        $sql = 'SELECT SHOWS.TITLE,SHOWS.RUNTIME,SYNOPSISES.SUMMARY FROM ';
        $sql .= 'SHOWS,SYNOPSISES WHERE SHOWS.ID=' . $episodes['EPISODE_ID'] . ' AND ';
        $sql .= 'SYNOPSISES.ID=' . $episodes['EPISODE_ID'];
        $result = DBQuery($dbh, $sql);
        $result_row = $result->fetch(PDO::FETCH_ASSOC);
        $result_row = array_merge($result_row, $path);
        $result_row['EPISODE_ID'] = $episodes['EPISODE_ID'];
        $result_row['EPISODE'] = $episodes['EPISODE'];
        $sdata[$scount]['EPISODES'][] = $result_row;
    }
    $scount++;
    }
    $nmj_data['SEASONS'] = $sdata;
    return $nmj_data;
}

function loadMusicData($dbh, $albumid, $drivepath)
{
    $nmj_data = array();
    $sql = 'SELECT SONG_ALBUMS.ID AS ALBUM_ID,';
    $sql .= 'SONG_ALBUMS.TITLE,';
    $sql .= 'SONG_ALBUMS.RELEASE_DATE AS ALBUM_YEAR,';
    $sql .= 'SONG_PERSONS.NAME AS ALBUM_ARTIST,';
    $sql .= 'SONG_ALBUM_POSTERS.POSTER ';
    $sql .= 'FROM SONG_ALBUMS,SONG_PERSONS,SONG_ALBUM_POSTERS ';
    $sql .= 'WHERE SONG_ALBUMS.ID=' . $albumid . ' AND ';
    $sql .= 'SONG_PERSONS.ID=' . $albumid . ' AND ';
    $sql .= 'SONG_ALBUM_POSTERS.ID=' . $albumid . ' ';

    $result = DBQuery($dbh, $sql);
    $nmj_data = $result->fetch(PDO::FETCH_ASSOC);

    $sql = 'SELECT SONGS.TITLE, SONG_GENRES.NAME AS GENRE, SONGS.RUNTIME, ';
    $sql .= 'SONG_ALBUMS.TITLE AS ALBUM,SONG_PERSONS.NAME AS ARTIST, ';
    $sql .= 'SONG_ALBUMS_SONGS.SEQUENCE AS TRACK_NO ';
    $sql .= 'FROM SONGS, SONG_ALBUMS_SONGS, SONG_GENRES, SONG_GENRES_SONGS,';
    $sql .= 'SONG_ALBUMS, SONG_PERSONS_SONGS, SONG_PERSONS ';
    $sql .= 'WHERE SONG_ALBUMS_SONGS.ALBUMS_ID = ' . $albumid . ' AND ';
    $sql .= 'SONG_PERSONS_SONGS.SONGS_ID = SONGS.ID AND ';
    $sql .= 'SONG_PERSONS.ID = SONG_PERSONS_SONGS.PERSONS_ID AND ';
    $sql .= 'SONG_ALBUMS.ID = ' . $albumid . ' AND ';
    $sql .= 'SONG_GENRES_SONGS.SONGS_ID = SONGS.ID AND ';
    $sql .= 'SONG_GENRES.ID = SONG_GENRES_SONGS.GENRES_ID AND ';
    $sql .= 'SONG_ALBUMS_SONGS.SONGS_ID = SONGS.ID ';
    $sql .= 'ORDER BY SONG_ALBUMS_SONGS.SEQUENCE';

    $tracks = 0;
    foreach ($dbh->query($sql) as $track_data) {
        $tracks++;
        $nmj_data["ID_" . $track_data['TRACK_NO']] = $track_data['TITLE'] . '#' . sec2hms($track_data['RUNTIME']) . '#' . $track_data['ALBUM'] . '#' . $track_data['TRACK_NO'] . '#' . $track_data['GENRE'] . '#' . $track_data['ARTIST'];
    }
    //$nmj_data = array_merge($nmj_data, $result_row);

    $year = explode("-", $nmj_data['ALBUM_YEAR']);
    $nmj_data['ALBUM_YEAR'] = $year[0];
    $nmj_data['TRACKS'] = $tracks;
    $nmj_data['DRIVE_PATH'] = $drivepath;

    return $nmj_data;
}

function matchRegex($strContent, $strRegex, $intIndex = null)
{
    $arrMatches = null;
    preg_match_all($strRegex, $strContent, $arrMatches);
    if ($arrMatches === FALSE) return false;
    if ($intIndex != null && is_int($intIndex)) {
        if ($arrMatches[$intIndex]) {
            return $arrMatches[$intIndex][0];
        }
        return false;
    }
    return $arrMatches;
}

function clean_num($num)
{
    $pos = strpos($num, '.');
    if ($pos === false) { // it is integer number
        return $num;
    } else { // it is decimal number
        return rtrim(rtrim($num, '0'), '.');
    }
}

date_default_timezone_set('Asia/Kolkata');

header("Access-Control-Allow-Origin: *");
if (isset($_GET['action']) && $_GET['action'] == 'updateProgram') {
$command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://www.pchvten.com/NMJManagerTablet/getData.txt -qO ".getcwd()."/getData.php 2>&1";
$output = shell_exec($command);
if ($output != "") {
$result['status'] = "error";
$result['message'] = trim($output);
}
else {
$result['status'] = "success";
$result['message'] = "";
}
print_r(json_encode($result));
} else if (isset($_GET['action']) && $_GET['action'] == 'getMD5sum') {
$result['md5sum'] = md5_file("getData.php");
print_r(json_encode($result));
} else if (isset($_GET['action']) && $_GET['action'] == 'getVideos') {
//define variables from incoming values

    if (isset($_GET["start"]))
        $posStart = $_GET['start'];
    else
        $posStart = 0;

    if (isset($_GET['sortby']))
        $sortby = $_GET['sortby'];
    else
        $sortby = "title";

    if (isset($_GET['filterby']))
        $filterby = $_GET['filterby'];

    if (isset($_GET['orderby']))
        $orderby = $_GET['orderby'];
    else
        $orderby = "asc";

    if (isset($_GET["load"]))
        $load = $_GET['load'];
    else
        $load = "all";

    if (isset($_GET["TYPE"]))
        $type = $_GET['TYPE'];
    else
        $type = "Movies";

    if (isset($_GET["VALUE"]))
        $value = $_GET['VALUE'];
    else
        $value = "";

    if (isset($_GET["count"]))
        $count = $_GET['count'];
    else
        $count = 60;

    if (isset($_GET['drivepath']))
        $drivepath = $_GET['drivepath'];

    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];

    if (isset($_GET['searchtype']))
        $searchtype = $_GET['searchtype'];

    if (file_exists($dbpath)) {
        $dbh = new PDO('sqlite:' . $dbpath);
        $mediapath = dirname(dirname($dbpath));

        if ($posStart == 0) {
            if ($load == 'all' || $load == 'watched' || $load == 'unwatched' || $load == "favorites" || $load == 'Unidentified' || $load == 'newReleases' ) {
                if ($filterby == 'Filter') {
                  $table = array();
                  $sql = 'SELECT COUNT(DISTINCT SHOWS.ID) FROM ';
                  if (isset($_GET['Genre'])){
                      $genres = explode(",", $_GET['Genre']);
                      if ($genres[0] != ''){
                        $table[]= 'VIDEO_GENRES';
                        $table[] = 'SHOWS_GENRES';
                      }
                   }
                  if (isset($_GET['Index'])){
                      $index = explode(",", $_GET['Index']);
                      if ($index[0] != ''){
                        $table[] = 'SHOW_GROUPS_SHOWS';
                        $table[] = 'SHOW_GROUPS';
                      }
                   }
                  if (isset($_GET['Certification']))
                      $cert = explode(",", $_GET['Certification']);
                  if (isset($_GET['Year']))
                      $year = explode(",", $_GET['Year']);
                  if (isset($_GET['Resolution'])){
                      $resolution = explode(",", $_GET['Resolution']);
                      if ($resolution[0] != ''){
                          $table[] = 'SHOWS_VIDEOS';
                          $table[] = 'VIDEO_PROPERTIES';
                      }
                  }
                    $table[] = 'SHOWS';
                    if ($load == 'favorites')
                        $table[] = 'FAVOURITES';
                    else if ($load == "watched" || $load == "unwatched") {
                        $table[] = 'SHOWS_VIDEOS';
                        $table[] = 'VIDEOS';
                    }
                    $sql .= implode(",", array_unique($table));
                    $sql .= ' WHERE ';
                    if ($genres[0] != ''){
                        for($i=0;$i<count($genres);$i++)
                            $gen[$i] = ' VIDEO_GENRES.NAME="' . $genres[$i] . '" ';
                        $sql .= "( ". implode(" OR ", $gen) . " )";
                        $sql .=  ' AND SHOWS_GENRES.GENRES_ID=VIDEO_GENRES.ID ';
                        $sql .= ' AND SHOWS.ID=SHOWS_GENRES.SHOWS_ID ';
                    }
                    if ($index[0] != ''){
                        if ($genres[0] != '')
                            $sql.= ' AND ';
                        for($i=0;$i<count($index);$i++)
                            $ind[$i] = ' SHOW_GROUPS.NAME="' . $index[$i] . '" ';
                        $sql .= "( ". implode(" OR ", $ind) . " )";
                        $sql .= ' AND SHOW_GROUPS_SHOWS.GROUPS_ID=SHOW_GROUPS.ID ';
                        $sql .= ' AND SHOWS.ID=SHOW_GROUPS_SHOWS.SHOWS_ID ';
                    }
                    if ($cert[0] != ''){
                        if ($genres[0] != '' || $index[0] != '')
                            $sql.= ' AND ';
                        for($i=0;$i<count($cert);$i++){
                            if ($cert[$i] == 'NR')
                                $cert_t = '';
                            else
                                $cert_t = $cert[$i];
                            $cer[$i] = ' SHOWS.PARENTAL_CONTROL="' . $cert_t . '" ';
                        }
                        $sql .= "( ". implode(" OR ", $cer) . " )";
                    }
                    if ($year[0] != ''){
                        if ($genres[0] != '' || $index[0] != '' || $cert[0] != '')
                            $sql.= ' AND ';
                        for($i=0;$i<count($year);$i++)
                            $yea[$i] = ' SHOWS.YEAR="' . $year[$i] . '" ';
                        $sql .= "( ". implode(" OR ", $yea) . " )";
                    }
                    if ($resolution[0] != ''){
                        if ($genres[0] != '' || $index[0] != '' || $cert[0] != '' || $year[0] != '')
                            $sql.= ' AND ';
                        for($i=0;$i<count($resolution);$i++){
                            if ($resolution[$i] == 'Full HD')
                                $value = '1920';
                            else if ($resolution[$i] == 'HD')
                                $value = '1280';
                            else if ($resolution[$i] == 'SD')
                                $value = '720';
                            $res[$i] = ' VIDEO_PROPERTIES.WIDTH<="' . $value . '" ';
                        }
                        $sql .= "( ". implode(" OR ", $res) . " )";
                        $sql .= ' AND SHOWS_VIDEOS.SHOWS_ID=SHOWS.ID ';
                        $sql .= ' AND SHOWS_VIDEOS.VIDEOS_ID=VIDEO_PROPERTIES.ID ';
                    }
                    
                    if ($genres[0] != '' || $index[0] != '' || $cert[0] != '' || $year[0] != '' || $resolution[0] != '')
                        $sql.= ' AND ';
                    if ($load == 'favorites')
                        $sql .= ' FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                    if ($type == 'Movies')
                        $sql .= ' (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                    else if ($type == 'TV Shows')
                        $sql .= ' SHOWS.TITLE_TYPE = 2 ';
                    if ($load == "watched" || $load == "unwatched") {
                        $sql .= ' AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                        $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                        if ($load == "watched")
                            $sql .= 'VIDEOS.PLAY_COUNT > 0 ';
                        else
                            $sql .= 'VIDEOS.PLAY_COUNT = 0 ';
                    }
                } else if ($filterby == 'Director' || $filtertype == 'Cast') {
                    $sql = 'SELECT COUNT(SHOWS_PERSONS.SHOWS_ID),VIDEO_PERSONS.ID FROM ';
                    $sql .= 'SHOWS_PERSONS,VIDEO_PERSONS,SHOWS ';
                    if ($load == "watched" || $load == "unwatched")
                        $sql .= ',SHOWS_VIDEOS,VIDEOS ';
                    $sql .= ' WHERE VIDEO_PERSONS.NAME="' . str_replace("'", "&apos;", $value) . '" AND ';
                    $sql .= 'VIDEO_PERSONS.ID=SHOWS_PERSONS.PERSONS_ID ';
                    $sql .= 'AND SHOWS.ID=SHOWS_PERSONS.SHOWS_ID ';
                    if ($type == 'Movies')
                        $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) AND ';
                    else if ($type == 'TV Shows')
                        $sql .= 'AND SHOWS.TITLE_TYPE = 2 AND ';
                    $sql .= " AND ";
                    if ($load == "watched" || $load == "unwatched") {
                        $sql .= 'VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                        $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                        if ($load == "watched")
                            $sql .= 'VIDEOS.PLAY_COUNT > 0 AND ';
                        else
                            $sql .= 'VIDEOS.PLAY_COUNT = 0 AND ';
                    }
                    if ($filterby == 'Director')
                        $sql .= 'SHOWS_PERSONS.PERSON_TYPE = "DIRECTOR"';
                    else if ($filterby == 'Cast')
                        $sql .= 'SHOWS_PERSONS.PERSON_TYPE = "CAST"';
                } else if ($filterby == 'Rating') {
                    $sql = 'SELECT COUNT(SHOWS.ID) FROM SHOWS ';
                    if ($value == 0)
                        $sql .= 'WHERE RATING=0  ';
                    else
                        $sql .= 'WHERE RATING>"' . ($value - 1) . '" AND RATING<="' . $value . '"  ';
                } else if ($filterby == 'search') {
                    $sql = 'SELECT COUNT(DISTINCT SHOWS.ID) FROM SHOWS';
                    if ($searchtype == 'keyword')
                        $sql .= ',SHOWS_KEYWORDS,KEYWORDS';
                    else if ($searchtype == 'cast')
                        $sql .= ',SHOWS_PERSONS,VIDEO_PERSONS';
                    if ($load == 'favorites')
                        $sql .= ',FAVOURITES';
                    else if ($load == "watched" || $load == "unwatched")
                        $sql .= ',VIDEOS,SHOWS_VIDEOS';
                    $sql .= ' WHERE ';
                    if ($searchtype == 'title')
                        $sql .= 'SHOWS.TITLE LIKE "%' . $value . '%" ';
                    else if ($searchtype == 'keyword') {
                        $sql .= 'KEYWORDS.KEYWORD LIKE "%' . $value . '%" AND ';
                        $sql .= 'SHOWS_KEYWORDS.ID=KEYWORDS.ID AND SHOWS_KEYWORDS.SHOWS_ID=SHOWS.ID ';
                    } else if ($searchtype == 'cast') {
                        $sql .= 'VIDEO_PERSONS.NAME LIKE "%' . $value . '%" AND ';
                        $sql .= 'SHOWS_PERSONS.PERSONS_ID=VIDEO_PERSONS.ID AND SHOWS_PERSONS.SHOWS_ID=SHOWS.ID AND ';
                        $sql .= 'SHOWS_PERSONS.PERSON_TYPE="CAST" ';
                    }
                    if ($type == 'Movies')
                        $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                    else if ($type == 'TV Shows')
                        $sql .= 'AND SHOWS.TITLE_TYPE = 2 ';
                    if ($load == 'favorites')
                        $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                    if ($load == "watched" || $load == "unwatched") {
                        $sql .= ' AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                        $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                        if ($load == "watched")
                            $sql .= 'VIDEOS.PLAY_COUNT > 0';
                        else
                            $sql .= 'VIDEOS.PLAY_COUNT = 0';
                    }
                } else if ($filterby == 'All') {
                    $sql = 'SELECT COUNT(SHOWS.ID) FROM SHOWS';
                    if ($load == 'favorites')
                        $sql .= ',FAVOURITES';
                    else if ($load == "watched" || $load == "unwatched")
                        $sql .= ',VIDEOS,SHOWS_VIDEOS';
		    $dt = strtotime(date('Y-m-d')." -1 month");
                    if ($type == 'Movies')
                        $sql .= ' WHERE (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                    else if ($type == 'TV Shows')
                        $sql .= ' WHERE SHOWS.TITLE_TYPE = 2 ';
                    else if ($load == 'Unidentified')
                        $sql .= ' WHERE (SHOWS.TITLE_TYPE = 0 OR SHOWS.TITLE_TYPE = 4) ';
                    if ($load == 'newReleases'){
                        $sql .= ' AND (RELEASE_DATE BETWEEN "';
                        $sql .= date('Y-m-d', strtotime(date("Y-m-d")." -1 month"));
                        $sql .= '" AND "';
                        $sql .= date("Y-m-d").'")';
                    }
                    if ($load == 'favorites')
                        $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                    if ($load == "watched" || $load == "unwatched") {
                        $sql .= ' AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                        $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                        if ($load == "watched")
                            $sql .= 'VIDEOS.PLAY_COUNT > 0';
                        else
                            $sql .= 'VIDEOS.PLAY_COUNT = 0';
                    }
                }
            } else if ($load == 'collections') {
                $sql = "SELECT count(*) FROM sqlite_master WHERE type='table' AND name='COLLECTIONS'";
                $result = DBQuery($dbh, $sql);
                $exists = $result->fetch(PDO::FETCH_NUM);

                if ($exists[0] == 1)
                    $sql = 'SELECT COUNT(ID) FROM COLLECTIONS ';
                if ($filterby == 'search') {
                    if ($searchtype == 'title')
                        $sql .= 'WHERE TITLE LIKE "%' . $value . '%" ';
                }
            } else if ($load == 'lists') {
                checkNaddListTable($dbh);
                $sql = 'SELECT COUNT(ID) FROM LISTS ';
                if ($filterby == 'search') {
                    if ($searchtype == 'title')
                        $sql .= 'WHERE TITLE LIKE "%' . $value . '%" ';
                }
            }
            $result = DBQuery($dbh, $sql);
            $totalCount = $result->fetch();
        } else
            $totalCount[0] = 0;

        if ($load == 'all' || $load == 'watched' || $load == 'unwatched' || $load == "favorites" || $load == 'Unidentified' || $load == 'newReleases' ) {
                if ($filterby == 'Filter') {
                  $table = array();
                  $sql = 'SELECT DISTINCT SHOWS.ID AS SHOW_ID,SHOWS.TITLE_TYPE FROM ';
                  if (isset($_GET['Genre'])){
                      $genres = explode(",", $_GET['Genre']);
                      if ($genres[0] != ''){
                        $table[]= 'VIDEO_GENRES';
                        $table[] = 'SHOWS_GENRES';
                      }
                   }
                  if (isset($_GET['Index'])){
                      $index = explode(",", $_GET['Index']);
                      if ($index[0] != ''){
                        $table[] = 'SHOW_GROUPS_SHOWS';
                        $table[] = 'SHOW_GROUPS';
                      }
                   }
                  if (isset($_GET['Certification']))
                      $cert = explode(",", $_GET['Certification']);
                  if (isset($_GET['Year']))
                      $year = explode(",", $_GET['Year']);
                  if (isset($_GET['Resolution'])){
                      $resolution = explode(",", $_GET['Resolution']);
                      if ($resolution[0] != ''){
                          $table[] = 'SHOWS_VIDEOS';
                          $table[] = 'VIDEO_PROPERTIES';
                      }
                  }
                    $table[] = 'SHOWS';
                    if ($load == 'favorites')
                        $table[] = 'FAVOURITES';
                    else if ($load == "watched" || $load == "unwatched") {
                        $table[] = 'SHOWS_VIDEOS';
                        $table[] = 'VIDEOS';
                    }
                    $sql .= implode(",", array_unique($table));
                    $sql .= ' WHERE ';
                    if ($genres[0] != ''){
                        for($i=0;$i<count($genres);$i++)
                            $gen[$i] = ' VIDEO_GENRES.NAME="' . $genres[$i] . '" ';
                        $sql .= "( ". implode(" OR ", $gen) . " )";
                        $sql .=  ' AND SHOWS_GENRES.GENRES_ID=VIDEO_GENRES.ID ';
                        $sql .= ' AND SHOWS.ID=SHOWS_GENRES.SHOWS_ID ';
                    }
                    if ($index[0] != ''){
                        if ($genres[0] != '')
                            $sql.= ' AND ';
                        for($i=0;$i<count($index);$i++)
                            $ind[$i] = ' SHOW_GROUPS.NAME="' . $index[$i] . '" ';
                        $sql .= "( ". implode(" OR ", $ind) . " )";
                        $sql .= ' AND SHOW_GROUPS_SHOWS.GROUPS_ID=SHOW_GROUPS.ID ';
                        $sql .= ' AND SHOWS.ID=SHOW_GROUPS_SHOWS.SHOWS_ID ';
                    }
                    if ($cert[0] != ''){
                        if ($genres[0] != '' || $index[0] != '')
                            $sql.= ' AND ';
                        for($i=0;$i<count($cert);$i++){
                            if ($cert[$i] == 'NR')
                                $cert_t = '';
                            else
                                $cert_t = $cert[$i];
                            $cer[$i] = ' SHOWS.PARENTAL_CONTROL="' . $cert_t . '" ';
                        }
                        $sql .= "( ". implode(" OR ", $cer) . " )";
                    }
                    if ($year[0] != ''){
                        if ($genres[0] != '' || $index[0] != '' || $cert[0])
                            $sql.= ' AND ';
                        for($i=0;$i<count($year);$i++)
                            $yea[$i] = ' SHOWS.YEAR="' . $year[$i] . '" ';
                        $sql .= "( ". implode(" OR ", $yea) . " )";
                    }
                    if ($resolution[0] != ''){
                        if ($genres[0] != '' || $index[0] != '' || $cert[0] != '' || $year[0] != '')
                            $sql.= ' AND ';
                        for($i=0;$i<count($resolution);$i++){
                            if ($resolution[$i] == 'Full HD')
                                $value = '1920';
                            else if ($resolution[$i] == 'HD')
                                $value = '1280';
                            else if ($resolution[$i] == 'SD')
                                $value = '720';
                            $res[$i] = ' VIDEO_PROPERTIES.WIDTH<="' . $value . '" ';
                        }
                        $sql .= "( ". implode(" OR ", $res) . " )";
                        $sql .= ' AND SHOWS_VIDEOS.SHOWS_ID=SHOWS.ID ';
                        $sql .= ' AND SHOWS_VIDEOS.VIDEOS_ID=VIDEO_PROPERTIES.ID ';
                    }
                    if ($genres[0] != '' || $index[0] != '' || $cert[0] != '' || $year[0] != '' || $resolution[0] != '')
                        $sql.= ' AND ';
                    if ($load == 'favorites')
                        $sql .= ' FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                    if ($type == 'Movies')
                        $sql .= ' (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                    else if ($type == 'TV Shows')
                        $sql .= ' SHOWS.TITLE_TYPE = 2 ';
                    if ($load == "watched" || $load == "unwatched") {
                        $sql .= ' AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                        $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                        if ($load == "watched")
                            $sql .= 'VIDEOS.PLAY_COUNT > 0 ';
                        else
                            $sql .= 'VIDEOS.PLAY_COUNT = 0 ';
                    }
            } else if ($filterby == 'Director' || $filterby == 'Cast') {
                $sql = 'SELECT SHOWS_PERSONS.SHOWS_ID AS SHOW_ID,VIDEO_PERSONS.ID,SHOWS.TITLE_TYPE,CONTENT_TTID,TTID FROM ';
                $sql .= 'SHOWS,SHOWS_PERSONS,VIDEO_PERSONS ';
                if ($load == "watched" || $load == "unwatched")
                    $sql .= ',VIDEOS,SHOWS_VIDEOS ';
                $sql .= 'WHERE VIDEO_PERSONS.NAME="' . str_replace("'", "&apos;", $value) . '" AND ';
                $sql .= 'VIDEO_PERSONS.ID=SHOWS_PERSONS.PERSONS_ID ';
                $sql .= 'AND SHOWS.ID=SHOWS_PERSONS.SHOWS_ID ';
                if ($type == 'Movies')
                    $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                else if ($type == 'TV Shows')
                    $sql .= 'AND SHOWS.TITLE_TYPE = 2 ';
                $sql .= " AND ";
                if ($load == "watched" || $load == "unwatched") {
                    $sql .= 'VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                    $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                    if ($load == "watched")
                        $sql .= 'VIDEOS.PLAY_COUNT > 0 AND ';
                    else
                        $sql .= 'VIDEOS.PLAY_COUNT = 0 AND ';
                }
                if ($filterby == 'Director')
                    $sql .= 'SHOWS_PERSONS.PERSON_TYPE = "DIRECTOR"';
                else if ($filterby == 'Cast')
                    $sql .= 'SHOWS_PERSONS.PERSON_TYPE = "CAST"';

            } else if ($filterby == 'search') {
                $sql = 'SELECT DISTINCT SHOWS.ID AS SHOW_ID,TITLE_TYPE,CONTENT_TTID,TTID FROM ';
                $sql .= 'SHOWS';
                if ($searchtype == 'keyword')
                    $sql .= ',SHOWS_KEYWORDS,KEYWORDS';
                else if ($searchtype == 'cast')
                    $sql .= ',SHOWS_PERSONS,VIDEO_PERSONS';
                if ($load == "watched" || $load == "unwatched")
                    $sql .= ',VIDEOS, SHOWS_VIDEOS';
                else if ($load == 'favorites')
                    $sql .= ',FAVOURITES';
                $sql .= ' WHERE ';
                if ($searchtype == 'title')
                    $sql .= 'SHOWS.TITLE LIKE "%' . $value . '%" ';
                else if ($searchtype == 'keyword') {
                    $sql .= 'KEYWORDS.KEYWORD LIKE "%' . $value . '%" AND ';
                    $sql .= 'SHOWS_KEYWORDS.ID=KEYWORDS.ID AND SHOWS_KEYWORDS.SHOWS_ID=SHOWS.ID ';
                } else if ($searchtype == 'cast') {
                    $sql .= 'VIDEO_PERSONS.NAME LIKE "%' . $value . '%" AND ';
                    $sql .= 'SHOWS_PERSONS.PERSONS_ID=VIDEO_PERSONS.ID AND SHOWS_PERSONS.SHOWS_ID=SHOWS.ID AND ';
                    $sql .= 'SHOWS_PERSONS.PERSON_TYPE="CAST" ';
                }
                if ($type == 'Movies')
                    $sql .= 'AND (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                else if ($type == 'TV Shows')
                    $sql .= 'AND SHOWS.TITLE_TYPE = 2 ';
                if ($load == 'favorites')
                    $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                else if ($load == "watched" || $load == "unwatched") {
                    $sql .= 'AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                    $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                    if ($load == "watched")
                        $sql .= 'VIDEOS.PLAY_COUNT > 0 ';
                    else
                        $sql .= 'VIDEOS.PLAY_COUNT = 0 ';
                }
            } else if ($filterby == 'All') {
                $sql = 'SELECT SHOWS.ID AS SHOW_ID,SHOWS.TITLE_TYPE AS TITLE_TYPE,CONTENT_TTID,TTID ';
                $sql .= 'FROM SHOWS ';
                if ($load == "watched" || $load == "unwatched")
                    $sql .= ',VIDEOS, SHOWS_VIDEOS ';
                else if ($load == 'favorites')
                    $sql .= ',FAVOURITES  ';
                if ($type == 'Movies')
                    $sql .= 'WHERE (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
                else if ($type == 'TV Shows')
                    $sql .= 'WHERE SHOWS.TITLE_TYPE = 2 ';
                else if ($load == 'Unidentified')
                    $sql .= 'WHERE (SHOWS.TITLE_TYPE = 0 OR SHOWS.TITLE_TYPE = 4) ';
                if ($load == 'newReleases'){
                    $sql .= ' AND (RELEASE_DATE BETWEEN "';
                    $sql .= date('Y-m-d', strtotime(date("Y-m-d")." -1 month"));
                    $sql .= '" AND "';
                    $sql .= date("Y-m-d").'")';
                }
                if ($load == 'favorites')
                    $sql .= ' AND FAVOURITES.MEDIA_ID = SHOWS.ID  ';
                else if ($load == "watched" || $load == "unwatched") {
                    $sql .= 'AND VIDEOS.ID = SHOWS_VIDEOS.VIDEOS_ID AND ';
                    $sql .= 'SHOWS.ID = SHOWS_VIDEOS.SHOWS_ID AND ';
                    if ($load == "watched")
                        $sql .= 'VIDEOS.PLAY_COUNT > 0 ';
                    else
                        $sql .= 'VIDEOS.PLAY_COUNT = 0 ';
                }
            }
        }
        if ($sortby == 'title')
            $sql .= 'ORDER BY SEARCH_TITLE ';
        else if ($sortby == 'release')
            $sql .= 'ORDER BY RELEASE_DATE ';
        else if ($sortby == 'duration')
            $sql .= 'ORDER BY RUNTIME ';
        else if ($sortby == 'rating')
            $sql .= 'ORDER BY RATING ';
        else if ($sortby == 'date')
            $sql .= 'ORDER BY SHOWS.CREATE_TIME ';

        if ($load == 'collections') {
            $tsql = "SELECT count(*) FROM sqlite_master WHERE type='table' AND name='COLLECTIONS'";
            $result = DBQuery($dbh, $tsql);
            $exists = $result->fetch(PDO::FETCH_NUM);

            if ($exists[0] == 1) {
                $sql = 'SELECT ID AS COLLECTION_ID FROM COLLECTIONS ';
                if ($filterby == 'search') {
                    if ($searchtype == 'title')
                        $sql .= 'WHERE TITLE LIKE "%' . $value . '%" ';
                }
                $sql .= 'ORDER BY COLLECTIONS.TITLE ';
            }
            else {
               $nmj_data['pos'] = 0;
               $nmj_data['total_count'] = 0;
               $nmj_data['data'] = array();
               print_r(json_encode($nmj_data));
               return;
            }
        }
        if ($load == 'lists') {
            checkNaddListTable($dbh);
            $sql = 'SELECT ID AS LIST_ID FROM LISTS ';
            if ($filterby == 'search') {
                if ($searchtype == 'title')
                    $sql .= 'WHERE TITLE LIKE "%' . $value . '%" ';
            }
            $sql .= 'ORDER BY LISTS.TITLE ';
        }

        if ($orderby == 'asc')
            $sql .= 'ASC';
        else if ($orderby == 'desc')
            $sql .= 'DESC';

        $sql .= ' LIMIT ' . $posStart . ',' . $count;

        $rcount = 0;
        //$sql_query[] = $sql;
        $result = DBQuery($dbh, $sql);
        $all_data = $result->fetchAll(PDO::FETCH_ASSOC);
        $count = count($all_data);

        $result_row = array();
        if ($count > 0) {
            $cnt=0;
            foreach ($all_data as $show_row) {
                if ($load == 'collections') {
                    $sql = 'SELECT COUNT(SHOWS_COLLECTIONS.ID) AS TOTAL_COUNT, COLLECTIONS.ID AS COLLECTION_ID,TITLE,';
                    $sql .= 'POSTER,CONTENT_TTID,PLAY_COUNT,TITLE_TYPE FROM SHOWS_COLLECTIONS,COLLECTIONS ';
                    $sql .= 'WHERE COLLECTIONS.ID=SHOWS_COLLECTIONS.COLLECTIONS_ID ';
                    $sql .= 'AND COLLECTIONS.ID='.$show_row['COLLECTION_ID'];
                } else if ($load == 'lists') {
                    $sql = 'SELECT LISTS.ID AS LIST_ID,TITLE,POSTER,LISTS.LIST_ID AS tmdbid,';
                    $sql .= 'PLAY_COUNT,TITLE_TYPE FROM LISTS ';
                    $sql .= 'WHERE LISTS.ID='.$show_row['LIST_ID'];
                    $result = DBQuery($dbh, $sql);
                    $list_result = $result->fetch(PDO::FETCH_ASSOC);
                    $sql = 'SELECT COUNT(SHOWS_LISTS.ID) AS TOTAL_COUNT FROM SHOWS_LISTS ';
                    $sql .= 'WHERE SHOWS_LISTS.LIST_ID='.$show_row['LIST_ID'];
                } else {
                    $sql = 'SELECT SHOWS.ID AS SHOW_ID,SHOWS.ID AS id, SHOWS.TITLE,SHOWS.TITLE_TYPE,SHOWS.CONTENT_TTID,TTID';
                    //$sql .= ',SHOWS.RATING,SHOWS.PARENTAL_CONTROL,SHOWS.TITLE_TYPE,SHOWS.YEAR';
                    $sql .= ',VIDEO_POSTERS.THUMBNAIL,VIDEO_POSTERS.POSTER ';
                    if ($show_row['TITLE_TYPE'] == 1 || $show_row['TITLE_TYPE'] == 6)
                        $sql .= ',VIDEOS.PLAY_COUNT ';
                    $sql .= 'FROM SHOWS,VIDEO_POSTERS ';
                    if ($show_row['TITLE_TYPE'] == 1 || $show_row['TITLE_TYPE'] == 6)
                        $sql .= ',SHOWS_VIDEOS,VIDEOS ';
                    $sql .= 'WHERE SHOWS.ID=' . $show_row['SHOW_ID'] . ' AND ';
                    $sql .= 'VIDEO_POSTERS.ID=' . $show_row['SHOW_ID'] . ' ';
                    if ($show_row['TITLE_TYPE'] == 1 || $show_row['TITLE_TYPE'] == 6) {
                        $sql .= ' AND SHOWS_VIDEOS.SHOWS_ID=' . $show_row['SHOW_ID'] . ' AND ';
                        $sql .= 'VIDEOS.ID=SHOWS_VIDEOS.VIDEOS_ID ';
                    }
                }

                $result = DBQuery($dbh, $sql);
                $result_row[$cnt] = $result->fetch(PDO::FETCH_ASSOC);
                if ($load == 'lists')
                  $result_row[$cnt] = array_merge($result_row[$cnt], $list_result);

                if ($load == 'collections') {
                    //$result_row[$cnt]['TITLE_TYPE'] = 10;
                    //$result_row[$cnt]['PLAY_COUNT'] = 0;
                    $result_row[$cnt]['THUMBNAIL'] = $result_row[$cnt]['POSTER'];
                }
                else if ($load == 'lists') {
                    //$result_row[$cnt]['TITLE_TYPE'] = 11;
                    //$result_row[$cnt]['PLAY_COUNT'] = 0;
                    $result_row[$cnt]['THUMBNAIL'] = $result_row[$cnt]['POSTER'];
                }
                //$result_row[$cnt] = fixImagePath($mediapath, $result_row[$cnt]);
                if (strpos($result_row[$cnt]['CONTENT_TTID'], 'tmdb') !== false) 
                  $result_row[$cnt]['tmdbid'] = str_replace("tmdb", "", $result_row[$cnt]['CONTENT_TTID']);
                $cnt++;
                //$sql_query[] = $sql;
            }
        $nmj_data['data'] = $result_row;
        $nmj_data['pos'] = $posStart;
        //$nmj_data['sql_query'] = $sql_query;
        $nmj_data['total_count'] = $totalCount[0];
        print_r(json_encode($nmj_data));
        } else {
            print ("{\n");
            print (' "data": [' . "\n");
            print("],\n");
            print(' "pos" : ' . $posStart . ',' . "\n");
            if ($posStart == 0)
                print(' "total_count" : ' . $totalCount[0] . "\n");
            print(' "sql_query": ["' . $sql . '"');
            print("}\n");
        }
    } else {
        print("{ }\n");
    }
// close the database connection
    $dbh = NULL;
} else if (isset($_GET['action']) && $_GET['action'] == 'getProcessPercentage') {
    if(file_exists('data/percent_completed')) {
      $result['completed'] = trim(file_get_contents('data/percent_completed'));
      print_r(json_encode($result));
    }
} else if (isset($_GET['action']) && $_GET['action'] == 'saveImage') {
    if (isset($_POST['DATA']))
      $nmj_data = json_decode($_POST['DATA'], true);
    if (isset($_GET['drivepath']))
        $nmj_data['DRIVE'] = $_GET['drivepath'];
    if (isset($_GET['dbpath']))
        $nmj_data['DB_PATH'] = $_GET['dbpath'];
    if (file_exists($nmj_data['DB_PATH']) && is_writable($nmj_data['DB_PATH'])) {
        $dbh = new PDO('sqlite:' . $nmj_data['DB_PATH']);
        $data = handleImages($dbh, $nmj_data, "updated");
        $result['status'] = "success";
        $result['code'] = "";
        $result['DATA'] = $data;
        print_r(json_encode($result));
    }
    else {
        $result['status'] = "error";
        $result['code'] = $nmj_data['DB_PATH'].' is not writable.';
        print_r(json_encode($result));
    }
} else if (isset($_GET['action']) && $_GET['action'] == 'saveData') {
    if (isset($_POST['DATA']))
      $nmj_data = json_decode($_POST['DATA'], true);
    if (isset($_GET['drivepath']))
        $nmj_data['DRIVE'] = $_GET['drivepath'];
    if (isset($_GET['dbpath']))
        $nmj_data['DB_PATH'] = $_GET['dbpath'];

    if (file_exists($nmj_data['DB_PATH']) && is_writable($nmj_data['DB_PATH'])) {
        $dbh = new PDO('sqlite:' . $nmj_data['DB_PATH']);
        handleNMJData($dbh, $nmj_data, "updated");
        //$result['data'] = loadMovieData($nmj_data['DB_PATH'], $nmj_data['SHOW_ID'], $nmj_data['DRIVE'], $nmj_data['SOURCEURL']);
        $result['status'] = "success";
        $result['code'] = "";
        $result['ID'] = $nmj_data['ID'];
        print_r(json_encode($result));
    }
    else {
        $result['status'] = "error";
        $result['code'] = $nmj_data['DB_PATH'].' is not writable.';
        print_r(json_encode($result));
    }
} else if (isset($_GET['action']) && $_GET['action'] == 'updateMediaInfo') {
    $mediainfo['VIDEO'] = json_decode($_GET['DATA'], true);
    if (is_array($mediainfo))
        print_r(json_encode(getMediaInfo($mediainfo)));
    else
        print_r('{"status":"error","message":"Invalid JSON."}');
} else if (isset($_GET['action']) && $_GET['action'] == 'updateData') {
    if (isset($_GET['SHOWID']))
        $showid = $_GET['SHOWID'];
    if (isset($_GET['imdbid']))
        $imdbid = $_GET['imdbid'];

    if (isset($_GET['tmdbid']))
        $nmj_data = getTMDBdata($_GET['tmdbid']);
    else if (isset($_GET['imdbid']))
        $nmj_data = getIMDBdata($_GET['imdbid']);
    $nmj_data['SHOW_ID'] = $showid;
    print_r(json_encode($nmj_data));
} else if (isset($_GET['action']) && $_GET['action'] == 'getCount') {
    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];

    $command = "cd ".getcwd().";ln -s " . $drivepath . " .";
    shell_exec($command);
    $mediapath = dirname(dirname($dbpath));
    if ($mediapath != $drivepath)  {
        $command = "cd ".getcwd().";ln -s " . $mediapath . " .";
        shell_exec($command);
    }

    if (file_exists($dbpath)) {
        $dbh = new PDO('sqlite:' . $dbpath);
        $sql = 'SELECT COUNT(SHOWS.ID) AS MOVIES FROM SHOWS';
        $sql .= ' WHERE (SHOWS.TITLE_TYPE = 1 OR SHOWS.TITLE_TYPE = 6) ';
        $result = DBQuery($dbh, $sql);
        $output = $result->fetch(PDO::FETCH_ASSOC);
        $count['data']['count']['movies'] = $output['MOVIES'];
        $sql = 'SELECT COUNT(SHOWS.ID) AS SHOWS FROM SHOWS';
        $sql .= ' WHERE SHOWS.TITLE_TYPE = 2 ';
        $result = DBQuery($dbh, $sql);
        $output = $result->fetch(PDO::FETCH_ASSOC);
        $count['data']['count']['shows'] = $output['SHOWS'];
        $sql = 'SELECT COUNT(SONG_ALBUMS.ID) AS MUSIC FROM SONG_ALBUMS';
        $result = DBQuery($dbh, $sql);
        $output  = $result->fetch(PDO::FETCH_ASSOC);
        $count['data']['count']['music'] = $output['MUSIC'];

        $sql = 'SELECT SHOWS.ID,PLAY_COUNT,CONTENT_TTID FROM SHOWS,VIDEOS,SHOWS_VIDEOS WHERE ';
        $sql .= 'CONTENT_TTID != "" AND ';
        $sql .= 'SHOWS_VIDEOS.SHOWS_ID=SHOWS.ID AND ';
        $sql .= 'VIDEOS.ID=SHOWS_VIDEOS.VIDEOS_ID';
        $result = DBQuery($dbh, $sql);
        $output = $result->fetchAll(PDO::FETCH_ASSOC);
        for($x=0;$x<count($output);$x++){
          $count['data']['library'][str_replace('tmdb','',$output[$x]['CONTENT_TTID'])] = $output[$x];
        }

        if(file_exists("data/trakt.movies.json"))
          $count['data']['trakt']['watched']['movies'] = json_decode(file_get_contents("data/trakt.movies.json"), TRUE);
        if(file_exists("data/trakt.shows.json"))
          $count['data']['trakt']['watched']['shows'] = json_decode(file_get_contents("data/trakt.shows.json"), TRUE);
    }
    print_r(json_encode($count));
} else if (isset($_GET['action']) && $_GET['action'] == 'addNewList') {

    if (isset($_GET['drivepath']))
        $drivepath = $_GET['drivepath'];
    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];
    if (isset($_GET['name']))
        $name = $_GET['name'];
    if (file_exists($dbpath) && is_writable($dbpath)) {
      $dbh = new PDO('sqlite:' . $dbpath);
      checkNaddListTable($dbh);

      $sql = 'SELECT ID FROM LISTS WHERE TITLE="'.$name.'"';
      $result = DBQuery($dbh, $sql);
      $row = $result->fetch(PDO::FETCH_ASSOC);
      if (!isset($row['ID'])) {
        $sql = 'INSERT INTO LISTS VALUES(NULL, "'.$name .'", NULL, ';
        $sql .= '0, 11,NULL,NULL,NULL,NULL,NULL,NULL)';
        $result = DBQuery($dbh, $sql);
        $row['ID'] = $dbh->lastInsertId();
        $output['status'] = "success";
        $output['code'] = '';
      }
      else {
        $output['status'] = "error";
        $output['code'] = $name. ' already exists.';
      }
    }
    else {
        $output['status'] = "error";
        $output['code'] = $dbpath. ' is not writable.';
    }
    print_r(json_encode($output));
} else if (isset($_GET['action']) && $_GET['action'] == 'addList') {
    global $TMDBAPI;

    if (isset($_GET['drivepath']))
        $drivepath = $_GET['drivepath'];
    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];
    if (isset($_GET['listid']))
        $listid = $_GET['listid'];
    if (file_exists($dbpath) && is_writable($dbpath)) {
        $dbh = new PDO('sqlite:' . $dbpath);

        checkNaddListTable($dbh);
        $data = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://api.themoviedb.org/3/configuration?api_key=" . $TMDBAPI . " -qO-");
        $json_parser = json_decode($data, true);
        $config['base_url']= $json_parser['images']['base_url'];

        $APIURL = 'http://api.themoviedb.org/3/list/' . $listid . '?api_key=' . $TMDBAPI;
        $json = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget '" . $APIURL . "' -qO- ");
        $json_parser = json_decode($json, true);
        if (!isset($json_parser)) {
          $output['status'] = "error";
          $output['code'] = "The resource you requested could not be found.";
        } else {
          for($i=0;$i<count($json_parser['items']);$i++){
            $sql = 'SELECT SHOWS.ID AS SHOW_ID FROM SHOWS WHERE CONTENT_TTID="tmdb'.$json_parser['items'][$i]['id'].'"';
            $result = DBQuery($dbh, $sql);
            $exists = $result->fetch(PDO::FETCH_NUM);
            if(is_array($exists)){
              $sql = 'SELECT ID FROM LISTS WHERE LIST_ID="'.$json_parser['id'].'"';
              $result = DBQuery($dbh, $sql);
              $row = $result->fetch(PDO::FETCH_ASSOC);
              if (!isset($row['ID'])) {
                $poster_url = $config['base_url'].'original'.$json_parser['poster_path'];
                $suffix = basename($poster_url);
                $poster_fname = "list_" . $suffix;
                $poster_path = "nmj_database/media/video/poster/" . $poster_fname;
                $command = 'wget -q "http://images1-focus-opensocial.googleusercontent.com/gadgets/proxy?url=' . $poster_url . '&resize_w=220&resize_h=330&container=focus" -O "' . $drivepath . "/" . $poster_path . '"';
                shell_exec($command);
                $sql = 'INSERT INTO LISTS VALUES(NULL, "'.$json_parser['name'] .'", "'.$poster_path .'", ';
                $sql .= '0, 11,';
                $sql .= '"'.$json_parser['id'].'",NULL,NULL,NULL,NULL,NULL)';
                $result = DBQuery($dbh, $sql);
                $row['ID'] = $dbh->lastInsertId();
              }
              if (isset($row['ID'])) {
                $sql = 'SELECT ID FROM SHOWS_LISTS WHERE LIST_ID='.$row['ID'].' AND SHOW_ID='.$exists[0];
                $result = DBQuery($dbh, $sql);
                $nrow = $result->fetch(PDO::FETCH_ASSOC);
                if (!isset($nrow['ID'])) {
                  $sql = 'INSERT INTO SHOWS_LISTS VALUES(NULL, "'. $row['ID'] .'", "'. $exists[0] .'",';
                  $sql .= 'NULL,NULL,NULL,NULL,NULL)'; 
                  $result = DBQuery($dbh, $sql);
                }
              }
            }
          }
          $output['status'] = "success";
          $output['code'] = '';
        }
    }
    else {
        $output['status'] = "error";
        $output['code'] = $dbpath. ' is not writable.';
    }
    print_r(json_encode($output));
} else if (isset($_GET['action']) && $_GET['action'] == 'updateCollections') {
    global $TMDBAPI;

    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];
    if (file_exists($dbpath) && is_writable($dbpath)) {
        file_put_contents("data/percent_completed", "");
        $mediapath = dirname(dirname($dbpath));
        $dbh = new PDO('sqlite:' . $dbpath);

        $sql = "SELECT count(*) FROM sqlite_master WHERE type='table' AND name='COLLECTIONS'";
        $result = DBQuery($dbh, $sql);
        $exists = $result->fetch(PDO::FETCH_NUM);

        if ($exists[0] == 0) {
            $sql = 'CREATE TABLE COLLECTIONS ( ID INTEGER PRIMARY KEY, TITLE TEXT, ';
            $sql .= 'OVERVIEW TEXT, POSTER TEXT, PLAY_COUNT INTEGER, TITLE_TYPE INTEGER, CONTENT_TTID TEXT, ';
            $sql .= 'CUSTOM1 TEXT, CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT)';
            DBQuery($dbh, $sql);
        }

        $sql = "SELECT count(*) FROM sqlite_master WHERE type='table' AND name='SHOWS_COLLECTIONS'";
        $result = DBQuery($dbh, $sql);
        $exists = $result->fetch(PDO::FETCH_NUM);

        if ($exists[0] == 0) {
            $sql = 'CREATE TABLE SHOWS_COLLECTIONS ( ID INTEGER PRIMARY KEY, COLLECTIONS_ID INTEGER, ';
            $sql .= 'SHOW_ID INTEGER, CUSTOM1 TEXT, ';
            $sql .= 'CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT)';
            DBQuery($dbh, $sql);
        }

        $sql = 'SELECT ID AS SHOW_ID, CONTENT_TTID FROM SHOWS ';
        $sql .= 'WHERE (TITLE_TYPE = 1 OR TITLE_TYPE = 6) AND CONTENT_TTID != ""';
        $data = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget http://api.themoviedb.org/3/configuration?api_key=" . $TMDBAPI . " -qO-");
        $json_parser = json_decode($data, true);
        $config['base_url']= $json_parser['images']['base_url'];

        $result = DBQuery($dbh, $sql);
        $show_data = $result->fetchAll(PDO::FETCH_ASSOC);
        for($i=0;$i<count($show_data);$i++) {
            $percent = (($i+1) * 100) / count($show_data);
            file_put_contents("data/percent_completed", $percent."\n");
            if (isset($show_data[$i]) && $show_data[$i]['CONTENT_TTID'] != '') {
                $APIURL = 'http://api.themoviedb.org/3/movie/' . str_replace('tmdb', '', $show_data[$i]['CONTENT_TTID']) . '?api_key=' . $TMDBAPI;
                $json = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget '" . $APIURL . "' -qO-");
                $json_parser = json_decode($json, true);
                if (is_array($json_parser['belongs_to_collection'])) {
                    $collection_id = $json_parser['belongs_to_collection']['id'];
                    $APIURL = 'http://api.themoviedb.org/3/collection/' . $collection_id . '?api_key=' . $TMDBAPI;
                    $json = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget '" . $APIURL . "' -qO-");
                    $json_parser = json_decode($json, true);
                    $nmj_data = array();
                    $nmj_data['DRIVE'] = $mediapath;
                    $nmj_data['CONTENT_TTID'] = $json_parser['id'];
                    $nmj_data['TITLE'] = $json_parser['name'];
                    $nmj_data['OVERVIEW'] = $json_parser['overview'];
                    $nmj_data['POSTER'] = $config['base_url'].'w300'.$json_parser['poster_path'];
                    foreach ($json_parser['parts'] as $movies) {
                        for($x=0;$x<count($show_data);$x++) {
                            if (str_replace('tmdb', '', $show_data[$x]['CONTENT_TTID']) == $movies['id']) {
                                $nmj_data['SHOW_ID'][] = $show_data[$x]['SHOW_ID'];
                                unset($show_data[$x]);
                            }
                        }
                    }
                    handleCollections($dbh, $nmj_data, "updated");
                }
            }
        }
        $result['status'] = "success";
        $result['code'] = '';
    }
    else {
        $result['status'] = "error";
        $result['code'] = $dbpath. ' is not writable.';
    }
    print_r(json_encode($result));
        
} else if (isset($_GET['action']) && $_GET['action'] == 'updateList') {
    global $TMDBAPI;

    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];
    if (isset($_GET['listname']))
        $nmj_data['NAME'] = $_GET['listname'];
    if (isset($_GET['showid']))
        $nmj_data['SHOW_ID'] = $_GET['showid'];
    if (file_exists($dbpath) && is_writable($dbpath)) {
        $mediapath = dirname(dirname($dbpath));
        $dbh = new PDO('sqlite:' . $dbpath);

        checkNaddListTable($dbh);
        handleList($dbh, $nmj_data, "updated");
        $output['status'] = "success";
        $output['code'] = '';
    }
    else {
        $output['status'] = "error";
        $output['code'] = $dbpath. ' is not writable.';
    }
    print_r(json_encode($output));
        
} else if (isset($_GET['action']) && $_GET['action'] == 'editFavorite') {
    $showid = explode(",",$_GET['showid']);
    $title_type = $_GET['TTYPE'];
    $mode = $_GET['mode'];

    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];
    if (file_exists($dbpath)) {
        $dbh = new PDO('sqlite:' . $dbpath);
        for($i=0;$i<count($showid);$i++){
        if ($mode == 'add') {
            $sql = 'INSERT INTO FAVOURITES VALUES(NULL,"' . $title_type . '",';
            $sql .= $showid[$i] . ',NULL,NULL,NULL,NULL,NULL)';
        } else if ($mode == 'remove') {
            $sql = 'DELETE FROM FAVOURITES WHERE MEDIA_ID=' . $showid[$i];
        }
        $result = DBQuery($dbh, $sql);
        }
    }
} else if (isset($_GET['action']) && $_GET['action'] == 'editWatched') {
    $showid = explode(",",$_GET['showid']);
    $title_type = $_GET['TTYPE'];
    $mode = $_GET['mode'];

    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];

    if(file_exists("/opt/syb/sigma/bin/gbus_read_uint32"))
        $machine="NMT";
    else
        $machine="OTHERS";

    if ($machine == 'NMT') {
        for($i=0;$i<count($showid);$i++){
        $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- ";
        $command .= "'http://127.0.0.1:8008/metadata_database?arg0=set_video_watched&arg1=" . $dbpath . "&arg2=s" . $showid[$i] . "&arg3=";
        if ($mode == 'add')
          $command .= "watched'";
        else if ($mode == 'remove')
          $command .= "unwatched'";
        $davidbox_output = shell_exec($command);
        $xml = simplexml_load_string($davidbox_output);
        $json = json_encode($xml);
        $json_parser = json_decode($json, TRUE);
        }
    }
    else {
    if (file_exists($dbpath)) {
        $dbh = new PDO('sqlite:' . $dbpath);
        for($i=0;$i<count($showid);$i++){
        if ($mode == 'add') {
            $sql = 'UPDATE VIDEOS SET PLAY_COUNT=1 WHERE VIDEOS.ID=(SELECT VIDEOS_ID FROM SHOWS_VIDEOS ';
            $sql .= 'WHERE SHOWS_ID=' . $showid[$i] . ')';
        } else if ($mode == 'remove') {
            $sql = 'UPDATE VIDEOS SET PLAY_COUNT=0 WHERE VIDEOS.ID=(SELECT VIDEOS_ID FROM SHOWS_VIDEOS ';
            $sql .= 'WHERE SHOWS_ID=' . $showid[$i] . ')';
        }
        $result = DBQuery($dbh, $sql);
        }
    }
    }
} else if (isset($_GET['action']) && $_GET['action'] == 'getCollections') {
    $collectionid = $_GET['collectionid'];

    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];

    if (file_exists($dbpath)) {
        $mediapath = dirname(dirname($dbpath));
        $dbh = new PDO('sqlite:' . $dbpath);

        $sql = 'SELECT DISTINCT SHOWS.ID AS SHOW_ID, SHOWS.TITLE,SHOWS.PARENTAL_CONTROL,';
        $sql .= 'SHOWS.YEAR,SHOWS.RATING,SHOWS.TITLE_TYPE,SHOWS.CONTENT_TTID,VIDEOS.PLAY_COUNT,';
        $sql .= 'VIDEO_POSTERS.POSTER,VIDEO_POSTERS.THUMBNAIL ';
        $sql .= 'FROM COLLECTIONS,SHOWS_COLLECTIONS,SHOWS,VIDEO_POSTERS,VIDEOS,SHOWS_VIDEOS ';
        $sql .= 'WHERE COLLECTIONS.ID=' . $collectionid . ' AND ';
        $sql .= 'SHOWS.ID=SHOWS_COLLECTIONS.SHOW_ID AND ';
        $sql .= 'SHOWS_VIDEOS.ID=SHOWS.ID AND ';
        $sql .= 'VIDEOS.ID=SHOWS_VIDEOS.VIDEOS_ID AND ';
        $sql .= 'SHOWS_COLLECTIONS.COLLECTIONS_ID=COLLECTIONS.ID AND ';
        $sql .= 'VIDEO_POSTERS.ID=SHOWS.ID ';
        $sql .= 'ORDER BY SHOWS.YEAR ';

        $result = DBQuery($dbh, $sql);
        $nmj_data = $result->fetchAll(PDO::FETCH_ASSOC);
        $count = count($nmj_data);
        for($i=0;$i<count($nmj_data);$i++){
                $nmj_data[$i]['tmdbid'] = str_replace("tmdb", "", $nmj_data[$i]['CONTENT_TTID']);
                /*$pos = strpos($nmj_data[$i]['THUMBNAIL'], "/share/nmj_database");
                if ($pos === false)
                    $nmj_data[$i]['THUMBNAIL'] = ($nmj_data[$i]['THUMBNAIL']) ? basename($mediapath) . '/' . $nmj_data[$i]['THUMBNAIL'] : $nmj_data[$i]['THUMBNAIL'];
                else
                    $nmj_data[$i]['THUMBNAIL'] = substr($nmj_data[$i]['THUMBNAIL'], 1);
                $pos = strpos($nmj_data[$i]['POSTER'], "/share/nmj_database");
                if ($pos === false)
                    $nmj_data[$i]['POSTER'] = ($nmj_data[$i]['POSTER']) ? basename($mediapath) . '/' . $nmj_data[$i]['POSTER'] : $nmj_data[$i]['POSTER'];
                else
                    $nmj_data[$i]['POSTER'] = substr($nmj_data[$i]['POSTER'], 1);*/
        }
        print_r(json_encode($nmj_data));
    }

} else if (isset($_GET['action']) && $_GET['action'] == 'getList') {
    $listid = $_GET['listid'];

    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];

    if (file_exists($dbpath)) {
        $mediapath = dirname(dirname($dbpath));
        $dbh = new PDO('sqlite:' . $dbpath);

        $sql = 'SELECT DISTINCT SHOWS.ID AS SHOW_ID, SHOWS.ID AS id, SHOWS.TITLE,SHOWS.PARENTAL_CONTROL,';
        $sql .= 'SHOWS.YEAR,SHOWS.RATING,SHOWS.TITLE_TYPE,';
        $sql .= 'VIDEO_POSTERS.POSTER,VIDEO_POSTERS.THUMBNAIL ';
        $sql .= 'FROM LISTS,SHOWS_LISTS,SHOWS,VIDEO_POSTERS ';
        $sql .= 'WHERE LISTS.ID=' . $listid . ' AND ';
        $sql .= 'SHOWS.ID=SHOWS_LISTS.SHOW_ID AND ';
        $sql .= 'SHOWS_LISTS.LIST_ID=LISTS.ID AND ';
        $sql .= 'VIDEO_POSTERS.ID=SHOWS.ID ';
        $sql .= 'ORDER BY SHOWS.YEAR ';

        $result = DBQuery($dbh, $sql);
        $nmj_data = $result->fetchAll(PDO::FETCH_ASSOC);
        $count = count($nmj_data);
        for($i=0;$i<count($nmj_data);$i++){
                $nmj_data[$i]['tmdbid'] = str_replace("tmdb", "", $nmj_data[$i]['CONTENT_TTID']);
                /*$pos = strpos($nmj_data[$i]['THUMBNAIL'], "/share/nmj_database");
                if ($pos === false)
                    $nmj_data[$i]['THUMBNAIL'] = ($nmj_data[$i]['THUMBNAIL']) ? basename($mediapath) . '/' . $nmj_data[$i]['THUMBNAIL'] : $nmj_data[$i]['THUMBNAIL'];
                else
                    $nmj_data[$i]['THUMBNAIL'] = substr($nmj_data[$i]['THUMBNAIL'], 1);
                $pos = strpos($nmj_data[$i]['POSTER'], "/share/nmj_database");
                if ($pos === false)
                    $nmj_data[$i]['POSTER'] = ($nmj_data[$i]['POSTER']) ? basename($mediapath) . '/' . $nmj_data[$i]['POSTER'] : $nmj_data[$i]['POSTER'];
                else
                    $nmj_data[$i]['POSTER'] = substr($nmj_data[$i]['POSTER'], 1);*/
        }
        print_r(json_encode($nmj_data));
    }

} else if (isset($_GET['action']) && $_GET['action'] == 'getLists') {

    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];

    if (isset($_GET['showid']))
        $showid = $_GET['showid'];

    if (file_exists($dbpath)) {
        $dbh = new PDO('sqlite:' . $dbpath);
        checkNaddListTable($dbh);
        $sql = 'SELECT ID AS id,TITLE AS value FROM LISTS ';
        $sql .= 'ORDER BY LISTS.TITLE ';
        $result = DBQuery($dbh, $sql);
        $nmj_data = $result->fetchAll(PDO::FETCH_ASSOC);
        $sql = 'SELECT LISTS.ID as LIST_ID FROM LISTS,SHOWS_LISTS ';
        $sql .= 'WHERE SHOWS_LISTS.SHOW_ID='.$showid;
        $sql .= ' AND LISTS.ID=SHOWS_LISTS.LIST_ID ';
        $result = DBQuery($dbh, $sql);
        $list_id = $result->fetch(PDO::FETCH_COLUMN);
        for($i=0;$i<count($nmj_data);$i++){
          if($nmj_data[$i][id] == $list_id)
            $nmj_data[$i]['checked'] = true;
          else
            $nmj_data[$i]['checked'] = false;
        }
    }
    $nmj['data']= $nmj_data;
    print_r(json_encode($nmj));

} else if (isset($_GET['action']) && $_GET['action'] == 'getSeasonDetails') {
    $showid = $_GET['showid'];
    $season = $_GET['season'];

    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];

    if (file_exists($dbpath)) {
        $mediapath = dirname(dirname($dbpath));
        $dbh = new PDO('sqlite:' . $dbpath);
        $nmj_data = loadSeasonData($dbh, $showid, $season, $mediapath);
        print_r(json_encode($nmj_data));
    }
} else if (isset($_GET['action']) && $_GET['action'] == 'getMusic') {

    //define variables from incoming values
    if (isset($_GET["start"]))
        $posStart = $_GET['start'];
    else
        $posStart = 0;

    if (isset($_GET["TYPE"]))
        $type = $_GET['TYPE'];
    else
        $type = "";

    if (isset($_GET["VALUE"]))
        $value = $_GET['VALUE'];
    else
        $value = "";

    if (isset($_GET["count"]))
        $count = $_GET['count'];
    else
        $count = 20;

    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];

    if (isset($_GET['filter']))
        $filter = $_GET['filter'];

    if (file_exists($dbpath)) {
        $dbh = new PDO('sqlite:' . $dbpath);

        if ($posStart == 0) {
            if ($type == 'Genre') {
                $sql = 'SELECT COUNT(SONG_GENRES_SONG_ALBUMS.ID),SONG_GENRES.ID FROM SONG_GENRES,';
                $sql .= 'SONG_GENRES_SONG_ALBUMS WHERE SONG_GENRES.NAME="' . $value . '" ';
                $sql .= 'AND SONG_GENRES_SONG_ALBUMS.GENRES_ID=SONG_GENRES.ID';
            } else if ($type == 'Year') {
                $sql = 'SELECT COUNT(*) FROM SONG_ALBUMS ';
                $sql .= 'WHERE RELEASE_DATE LIKE "' . $value . '-%"';
            } else if ($type == 'Artist') {
                $sql = 'SELECT COUNT(*) FROM SONG_PERSONS_SONG_ALBUMS,SONG_PERSONS ';
                $sql .= 'WHERE SONG_PERSONS.NAME="' . $value . '" AND ';
                $sql .= 'SONG_PERSONS_SONG_ALBUMS.PERSONS_ID=SONG_PERSONS.ID';
            } else if ($type == "Music") {
                $sql = 'SELECT COUNT(*) FROM SONG_ALBUMS';
            }

            $result = DBQuery($dbh, $sql);
            $totalCount = $result->fetch();
        } else
            $totalCount[0] = 0;

        if ($type == 'Genre') {
            $sql = 'SELECT SONG_GENRES_SONG_ALBUMS.ALBUMS_ID AS ALBUM_ID FROM SONG_GENRES,';
            $sql .= 'SONG_GENRES_SONG_ALBUMS,SONG_ALBUMS WHERE SONG_GENRES.NAME="' . $value . '" ';
            $sql .= 'AND SONG_GENRES_SONG_ALBUMS.GENRES_ID=SONG_GENRES.ID ';
            $sql .= 'AND SONG_ALBUMS.ID=ALBUM_ID ';
            $sql .= ' ORDER BY SONG_ALBUMS.SEARCH_TITLE ';
        } else if ($type == 'Year') {
            $sql = 'SELECT ID AS ALBUM_ID FROM SONG_ALBUMS ';
            $sql .= 'WHERE RELEASE_DATE LIKE "' . $value . '-%"';
        } else if ($type == 'Artist') {
            $sql = 'SELECT SONG_ALBUMS.ID AS ALBUM_ID FROM SONG_ALBUMS,SONG_PERSONS,';
            $sql .= 'SONG_PERSONS_SONG_ALBUMS WHERE ';
            $sql .= 'SONG_PERSONS_SONG_ALBUMS.PERSONS_ID = SONG_PERSONS.ID AND ';
            $sql .= 'SONG_PERSONS_SONG_ALBUMS.ALBUMS_ID = SONG_ALBUMS.ID AND ';
            $sql .= 'SONG_PERSONS.NAME = "' . $value . '" ';
        } else if ($type == 'Music') {
            $sql = 'SELECT ID AS ALBUM_ID FROM SONG_ALBUMS ';
            $sql .= 'ORDER BY SEARCH_TITLE ';
        }

        $sql .= ' LIMIT ' . $posStart . ',' . $count;
        $rcount = 0;
        $result = DBQuery($dbh, $sql);
        $all_data = $result->fetchAll(PDO::FETCH_ASSOC);
        $count = count($all_data);

        if ($count > 0) {
            print ("{\n");
            print (" pos:" . $posStart . ",\n");
            print (" data: [\n");

            foreach ($all_data as $music_row) {
                $sql = 'SELECT SONG_ALBUMS.ID AS ALBUM_ID,';
                $sql .= 'SONG_ALBUMS.TITLE,';
                $sql .= 'SONG_PERSONS.NAME,';
                $sql .= 'SONG_ALBUM_POSTERS.THUMBNAIL ';
                $sql .= 'FROM SONG_ALBUMS,SONG_PERSONS,SONG_ALBUM_POSTERS ';
                $sql .= 'WHERE SONG_ALBUMS.ID=' . $music_row['ALBUM_ID'] . ' AND ';
                $sql .= 'SONG_PERSONS.ID=' . $music_row['ALBUM_ID'] . ' AND ';
                $sql .= 'SONG_ALBUM_POSTERS.ID=' . $music_row['ALBUM_ID'] . ' ';

                $result = DBQuery($dbh, $sql);
                $nmj_data = $result->fetch(PDO::FETCH_ASSOC);

                // Print XML
                //print('    <item id="' . $nmj_data['VIDEO_ID'] . '">' . "\n");
                $kcount = 0;
                print ("  {\n");
                print("    total_count : " . $totalCount[0] . ",\n");
                foreach ($nmj_data as $key => $value) {
                    if ($key == 'TITLE')
                        $value = htmlspecialchars_decode($value);
                    $kcount++;
                    if ($key == 'THUMBNAIL') {
                        $pos = strpos($value, "/share/nmj_database");
                        if ($pos === false)
                            $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                        else
                            $value = substr($value, 1);
                    }
                    if ($value == '')
                        $value = "NULL";

                    if ($kcount == count($nmj_data))
                        print('    "' . $key . '" : "' . $value . '"' . "\n");
                    else
                        print('    "' . $key . '" : "' . $value . '"' . ",\n");
                }
                $rcount++;
                if ($rcount == $count)
                    print ("  }\n");
                else
                    print ("  },\n");
            }
            print("]}\n");
        } else {
            print("{}\n");
        }
    } else {
        print("{ }\n");
    }
    // close the database connection
    $dbh = NULL;
} else if (isset($_GET['action']) && $_GET['action'] == 'getChapters') {

    $imdbid = $_GET['TTID'];

    if (stristr($_SERVER["HTTP_ACCEPT"], "application/xhtml+xml")) {
        header("Content-type: application/xhtml+xml");
    } else {
        header("Content-type: text/xml");
    }
    print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    print ("<data>\n");
    $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- http://www.imdb.com/title/" . $imdbid . "/";
    $imdb_content = preg_replace('~(\r|\n|\r\n)~', '', shell_exec($command));
    $IMDB_TITLE = "~og:title' content=\"(.*) \((.*)\)\"~Ui";
    $strReturn = str_replace(" ", "%20", matchRegex($imdb_content, $IMDB_TITLE, 1));

    $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- http://chapterdb.org/browse/?title=" . $strReturn;
    $chapterdb_content = preg_replace('~(\r|\n|\r\n)~', '', shell_exec($command));
    $count = preg_match_all("|<td style=\"width:8\%\">(.*)</abbr></td>|isU", $chapterdb_content, $output);
    if ($count > 0) {
        for ($i = 0; $i < $count; $i++) {
            $cnt = preg_match('|(.*)</td>(.*)<a href="/browse/(.*)">(.*)</a></td>(.*)<td style(.*)>(.*)</td>|isU',
                $output[1][$i], $result);
            print ("            <item id='" . $result[3] . "'><name>" . $result[1] . "&#160;&#160;&#160;&#160;&#160;&#160;" .
                $result[4] . "&#160;&#160;&#160;&#160;&#160;&#160;" . $result[7] . "</name></item>\n");
        }
    }
        print ("</data>\n");
} else if (isset($_GET['action']) && $_GET['action'] == 'editChapters') {
    $showid = $_GET['showid'];
    $chapterid = $_GET['chapterid'];

    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];

    $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- http://chapterdb.org/browse/" . $chapterid;
    $chapterdb_content = preg_replace('~(\r|\n|\r\n)~', '', shell_exec($command));
    preg_match("|<table class=\"table table-condensed table-striped\">(.*)</table>|isU", $chapterdb_content, $output);

    $dom = new DOMDocument;
    $dom->loadHTML($output[1]);
    $rows = array();
    foreach ($dom->getElementsByTagName('tr') as $tr) {
        $cells = array();
        foreach ($tr->getElementsByTagName('td') as $td) {
            $cells[] = $td->nodeValue;
        }
        $rows[] = $cells;
    }

    if (file_exists($dbpath)) {
        $mediapath = dirname(dirname($dbpath));
        $dbh = new PDO('sqlite:' . $dbpath);

        $sql = "SELECT count(*) FROM sqlite_master WHERE type='table' AND name='CHAPTERS'";
        $result = DBQuery($dbh, $sql);
        $exists = $result->fetch(PDO::FETCH_NUM);

        if ($exists[0] == 0) {
            $sql = 'CREATE TABLE CHAPTERS ( ID INTEGER PRIMARY KEY, CHAPTER INTEGER, ';
            $sql .= 'CHAPTER_TEXT TEXT, RUNTIME INTEGER, SHOW_ID INTEGER, CUSTOM1 TEXT, ';
            $sql .= 'CUSTOM2 TEXT, CUSTOM3 TEXT, CUSTOM4 TEXT, CUSTOM5 TEXT)';
            DBQuery($dbh, $sql);
        }
        $sql = 'SELECT COUNT(SHOW_ID) FROM CHAPTERS WHERE SHOW_ID=' . $showid;
        $result = DBQuery($dbh, $sql);
        $chap_count = $result->fetchAll();
        if ($chap_count > 0) {
            $sql = 'DELETE FROM CHAPTERS WHERE SHOW_ID=' . $showid;
            DBQuery($dbh, $sql);
        }

        for ($i = 0; $i < count($rows); $i++) {
            $time = explode(".", $rows[$i][2]);
            sscanf($time[0], "%d:%d:%d", $hours, $minutes, $seconds);
            $time_seconds = isset($seconds) ? $hours * 3600 + $minutes * 60 + $seconds : $hours * 60 + $minutes;
            $sql = 'INSERT INTO CHAPTERS VALUES(NULL,';
            $sql .= $rows[$i][0] . ',"' . str_replace('"', '&quot;', $rows[$i][1]) . '",' . $time_seconds . ',';
            $sql .= $showid . ',NULL,NULL,NULL,NULL,NULL)';
            DBQuery($dbh, $sql);
        }
    }
} else if (isset($_GET['action']) && $_GET['action'] == 'getVideoDetails') {
    if (isset($_GET['dbpath']))
        $dbpath = $_GET['dbpath'];

    if (isset($_GET['title_type']))
        $title_type = $_GET['title_type'];

    if (isset($_GET['drivepath']))
        $drivepath = $_GET['drivepath'];

    if (isset($_GET['sourceurl']))
        $sourceurl = $_GET['sourceurl'];

    $showid = $_GET['showid'];
    if ($showid == 0){
        $dbh = new PDO('sqlite:' . $dbpath);
        $sql = 'SELECT ID AS SHOW_ID FROM SHOWS WHERE TITLE_TYPE = 1 ORDER BY RANDOM() LIMIT 1';
        $result = DBQuery($dbh, $sql);
        $showid = $result->fetch(PDO::FETCH_NUM);
        $showid = $showid[0];
    }
    
    if (file_exists($dbpath)) {
       if ($title_type == 1 || $title_type == 6) {
        $nmj_data = loadMovieData($dbpath, $showid, $drivepath, $sourceurl);
        print_r(json_encode($nmj_data));
        }
        else if ($title_type == 2) {
            $mediapath = dirname(dirname($dbpath));
            $dbh = new PDO('sqlite:' . $dbpath);
            $nmj_data = loadSeasons($dbh, $showid, $mediapath);
            print_r(json_encode($nmj_data));
        }
        else if ($title_type == 10) {
          $nmj_data = loadCollectionData($dbpath, $showid, $drivepath, $sourceurl);
          print_r(json_encode($nmj_data));
        }
    }
} else if (isset($_GET['action']) && $_GET['action'] == 'getMusicDetails') {
        if (isset($_GET['dbpath']))
            $dbpath = $_GET['dbpath'];

        if (isset($_GET['drivepath']))
            $drivepath = $_GET['drivepath'];

        $albumid = $_GET['albumid'];
        $songby = $_GET['songby'];

        if (file_exists($dbpath)) {
            $mediapath = dirname(dirname($dbpath));
            $dbh = new PDO('sqlite:' . $dbpath);

            print ("[\n");
            print ("  {\n");
            if ($albumid != 0) {
                //$nmj_data = loadMusicData($dbh, $albumid, $drivepath);
                $nmj_data = array();
                $sql = 'SELECT SONG_ALBUMS.ID AS ALBUM_ID,';
                $sql .= 'SONG_ALBUMS.TITLE,';
                $sql .= 'SONG_ALBUMS.RELEASE_DATE AS ALBUM_YEAR,';
                $sql .= 'SONG_PERSONS.NAME AS ALBUM_ARTIST,';
                $sql .= 'SONG_ALBUM_POSTERS.POSTER ';
                $sql .= 'FROM SONG_ALBUMS,SONG_PERSONS,SONG_ALBUM_POSTERS ';
                $sql .= 'WHERE SONG_ALBUMS.ID=' . $albumid . ' AND ';
                $sql .= 'SONG_PERSONS.ID=' . $albumid . ' AND ';
                $sql .= 'SONG_ALBUM_POSTERS.ID=' . $albumid . ' ';

                $result = DBQuery($dbh, $sql);
                $nmj_data = $result->fetch(PDO::FETCH_ASSOC);
                $year = explode("-", $nmj_data['ALBUM_YEAR']);
                $nmj_data['ALBUM_YEAR'] = $year[0];
                $nmj_data['DRIVE_PATH'] = $drivepath;

                print('    "INDEX" : "' . $index . '"' . ",\n");
                $kcount = 0;
                foreach ($nmj_data as $key => $value) {
                    $kcount++;
                    if ($key == 'BOOKMARK_TIME')
                        $value = sprintf('%02d:%02d:%02d', ($value / 3600), ($value / 60 % 60), $value % 60);
                    if ($key == 'POSTER')
                        $value = ($value) ? basename($mediapath) . '/' . $value : $value;
                    print('    "' . $key . '" : "' . $value . '"' . ",\n");
                }
            }

            if ($albumid != 0) {
                $sql = 'SELECT SONGS.TITLE, SONG_GENRES.NAME AS GENRE, SONGS.RUNTIME, ';
                $sql .= 'SONG_ALBUMS.TITLE AS ALBUM,SONG_PERSONS.NAME AS ARTIST,SONGS.PATH,';
                $sql .= 'SONG_ALBUMS_SONGS.SEQUENCE AS TRACK_NO ';
                $sql .= 'FROM SONGS, SONG_ALBUMS_SONGS, SONG_GENRES, SONG_GENRES_SONGS,';
                $sql .= 'SONG_ALBUMS, SONG_PERSONS_SONGS, SONG_PERSONS ';
                $sql .= 'WHERE SONG_ALBUMS_SONGS.ALBUMS_ID = ' . $albumid . ' AND ';
                $sql .= 'SONG_PERSONS_SONGS.SONGS_ID = SONGS.ID AND ';
                $sql .= 'SONG_PERSONS.ID = SONG_PERSONS_SONGS.PERSONS_ID AND ';
                $sql .= 'SONG_ALBUMS.ID = ' . $albumid . ' AND ';
                $sql .= 'SONG_GENRES_SONGS.SONGS_ID = SONGS.ID AND ';
                $sql .= 'SONG_GENRES.ID = SONG_GENRES_SONGS.GENRES_ID AND ';
                $sql .= 'SONG_ALBUMS_SONGS.SONGS_ID = SONGS.ID ';
                $sql .= 'ORDER BY SONG_ALBUMS_SONGS.SEQUENCE';
            } else {
                $sql = 'SELECT SONGS.TITLE, SONG_GENRES.NAME AS GENRE, SONGS.RUNTIME, ';
                $sql .= 'SONG_ALBUMS.TITLE AS ALBUM,SONG_PERSONS.NAME AS ARTIST,SONGS.PATH, ';
                $sql .= 'SONG_ALBUMS_SONGS.SEQUENCE AS TRACK_NO ';
                $sql .= 'FROM SONGS, SONG_ALBUMS_SONGS, SONG_GENRES, SONG_GENRES_SONGS,';
                $sql .= 'SONG_ALBUMS, SONG_PERSONS_SONGS, SONG_PERSONS ';
                $sql .= 'WHERE SONGS.TITLE LIKE "' . $songby . '%" AND ';
                $sql .= 'SONG_ALBUMS_SONGS.SONGS_ID = SONGS.ID AND ';
                $sql .= 'SONG_GENRES.ID = SONG_GENRES_SONGS.GENRES_ID AND ';
                $sql .= 'SONG_GENRES_SONGS.SONGS_ID = SONGS.ID AND ';
                $sql .= 'SONG_ALBUMS.ID = SONG_ALBUMS_SONGS.ALBUMS_ID AND ';
                $sql .= 'SONG_PERSONS_SONGS.SONGS_ID = SONGS.ID AND ';
                $sql .= 'SONG_PERSONS.ID = SONG_PERSONS_SONGS.PERSONS_ID ';
                $sql .= 'ORDER BY SONGS.SEARCH_TITLE';
            }

            $tracks = 0;
            print ('    "tracks": [' . "\n");
            foreach ($dbh->query($sql) as $track_data) {
                $tracks++;
                print ("    {\n");
                print ('      "TRACK_NO": "' . $track_data['TRACK_NO'] . '",' . "\n");
                print ('      "TITLE": "' . $track_data['TITLE'] . '",' . "\n");
                print ('      "RUNTIME": "' . sec2ms($track_data['RUNTIME']) . '",' . "\n");
                print ('      "ALBUM": "' . $track_data['ALBUM'] . '",' . "\n");
                print ('      "GENRE": "' . $track_data['GENRE'] . '",' . "\n");
                print ('      "PATH": "' . $track_data['PATH'] . '",' . "\n");
                print ('      "COMPOSER": "-",' . "\n");
                print ('      "ARTIST": "' . $track_data['ARTIST'] . '"' . "\n");
                print ("    },\n");
            }

            print ("    ]\n");
            print ("  }\n");
            print ("]\n");
        }
} else if (isset($_GET['action']) && $_GET['action'] == 'getMenu') {
        if (isset($_GET['dbpath']))
            $dbpath = $_GET['dbpath'];

        if (isset($_GET['filter']))
            $filter = $_GET['filter'];

        if (file_exists($dbpath)) {
            $mediapath = dirname(dirname($dbpath));
            $dbh = new PDO('sqlite:' . $dbpath);

            $cnt=0;
            if ($filter == "index") {
                $sql = 'SELECT DISTINCT NAME FROM SHOW_GROUPS ORDER BY NAME';
                foreach ($dbh->query($sql) as $row) {
                    $tmpary[$cnt]['id'] = $row['NAME'];
                    $tmpary[$cnt]['name'] = $row['NAME'];
                    $cnt++;
                }
            } else if ($filter == "genre") {
                $sql = 'SELECT DISTINCT NAME FROM VIDEO_GENRES ORDER BY NAME';
                foreach ($dbh->query($sql) as $row) {
                    $tmpary[$cnt]['id'] = $row['NAME'];
                    $tmpary[$cnt]['name'] = $row['NAME'];
                    $cnt++;
                }
            } else if ($filter == "year") {
                $sql = 'SELECT DISTINCT YEAR FROM SHOWS ORDER BY YEAR DESC';
                foreach ($dbh->query($sql) as $row) {
                    $tmpary[$cnt]['id'] = $row['YEAR'];
                    $tmpary[$cnt]['name'] = $row['YEAR'];
                    $cnt++;
                }
            } else if ($filter == "certification") {
                $sql = 'SELECT DISTINCT PARENTAL_CONTROL FROM SHOWS ORDER BY PARENTAL_CONTROL';
                foreach ($dbh->query($sql) as $row) {
                    if ($row['PARENTAL_CONTROL'] == '')
                        $row['PARENTAL_CONTROL'] = 'NR';
                    $tmpary[$cnt]['id'] = $row['PARENTAL_CONTROL'];
                    $tmpary[$cnt]['name'] = $row['PARENTAL_CONTROL'];
                    $cnt++;
                }
            } else if ($filter == "rating") {
                for ($i = 10; $i >= 0; $i--) {
                    $tmpary[$cnt]['id'] = $i;
                    $tmpary[$cnt]['name'] = "<img src='images/common_star_" . $i . ".png'>";
                    $cnt++;
                }
            }
            $output['data'] = $tmpary;
            print_r(json_encode($output, JSON_HEX_TAG));
        } else {
            print ("{ }");
        }
} else if (isset($_GET['action']) && $_GET['action'] == 'getDriveDetails') {
    $data = json_decode($_GET['DATA'], true);

    if ($data['device_type'] == 'samba') {
        $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;/bin/wget -qO- ";
        $command .= "'http://127.0.0.1:8008/file_operation?arg0=list_user_storage_file&arg1=";
        $command .= $data['path']. "&arg2=0&arg3=100&arg4=true&arg5=true&arg6=true&arg7=' 2>/tmp/ooo";

        $davidbox_output = shell_exec($command);

        $xml = simplexml_load_string($davidbox_output);
        $json = json_encode($xml);
        $json_parser = json_decode($json, TRUE);

    if ($json_parser['returnValue'] == 0) {
        if (file_exists($json_parser['response']['convertPath']."/nmj_database/media.db")) {
            $rdata['dbpath'] = $json_parser['response']['convertPath']."/nmj_database/media.db";
            if (is_writable($rdata['dbpath']))
                $rdata['writable'] = "yes";
            else
                $rdata['writable'] = "no";
            $rdata['jukebox'] = 1;
            $rdata['path'] = $data['path'];
            $rdata['drivepath'] = $json_parser['response']['convertPath'];
        }
    }
    }
    else {
        $list = glob('/share/nmj_database_*');
        if (count($list) > 0) {
        for ($k = 0; $k < count($list); $k++) {
            if (file_exists($list[$k].'/media.db')) {
                $temp_dbh = new PDO('sqlite:' . $list[$k] . '/media.db');
                $sql = 'SELECT DIRECTORY FROM SCAN_DIRS';
                $result = DBQuery($temp_dbh, $sql);
                $all_data = $result->fetch(PDO::FETCH_ASSOC);
            if (strpos($all_data['DIRECTORY'], $data['path']) === false) {
                $rdata['dbpath'] =  '';
                $rdata['jukebox'] = 0;
                $rdata['writable'] = "no";
                $rdata['path'] = $data['path'];
                $rdata['drivepath'] = $json_parser['response']['convertPath'];
            }
            else {
                $rdata['dbpath'] =  $list[$k].'/media.db';
                if (is_writable($rdata['dbpath']))
                    $rdata['writable'] = "yes";
                else
                    $rdata['writable'] = "no";
                $rdata['jukebox'] = 1;
                $rdata['path'] = $data['path'];
                $rdata['drivepath'] = $json_parser['response']['convertPath'];
            }
            }
        }
    }
    else {
        $rdata['dbpath'] = '';
        $rdata['writable'] = "no";
        $rdata['jukebox'] = 0;
        $rdata['path'] = $data['path'];
        $rdata['datapath'] = $data['path'];
    }
    }
    print_r(json_encode($rdata));
} else if (isset($_GET['action']) && $_GET['action'] == 'getDrives') {
    if (isset($_GET['type']))
        $type = $_GET['type'];

    if (isset($_GET['dir']))
        $dir = $_GET['dir'];

    if(file_exists("/opt/syb/sigma/bin/gbus_read_uint32"))
        $machine="NMT";
    else
        $machine="OTHERS";

    $devices = array();
    if ($machine == 'NMT') {
        $command = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- ";
        $command .= "'http://127.0.0.1:8008/file_operation?arg0=list_user_storage_file&arg1=";
        if(isset($dir))
        $command .= $dir;
        $command .= "&arg2=0&arg3=100&arg4=true&arg5=true&arg6=true&arg7='";
        $davidbox_output = shell_exec($command);
        $xml = simplexml_load_string($davidbox_output);
        $json = json_encode($xml);
        $json_parser = json_decode($json, TRUE);

    if($json_parser['returnValue'] == 0){
    if ($type == "local") {
        if (is_array($json_parser)) {
        $all_devices = $json_parser['response']['fileList']['file'];
        $cnt=0;
        for($i=0;$i<count($all_devices);$i++){
            if ($all_devices[$i]['device_type'] == 'harddisk' || $all_devices[$i]['device_type'] == 'usb') {
            if (file_exists($all_devices[$i]['path'] . "/nmj_database/media.db")) {
                $data[$cnt]['name'] = $all_devices[$i]['name'];
                $data[$cnt]['dbpath'] = $all_devices[$i]['path'] . "/nmj_database/media.db";
                $data[$cnt]['drivepath'] = $all_devices[$i]['path'];
                if (is_writable($data[$cnt]['dbpath']))
                    $data[$cnt]['writable'] = "yes";
                else
                    $data[$cnt]['writable'] = "no";
                $data[$cnt]['image'] = "images/selectsource_icon_harddisk_jukebox.png";
                $data[$cnt]['jukebox'] = 1;
            }
            else {
                $data[$cnt]['name'] = $all_devices[$i]['name'];
                $data[$cnt]['dbpath'] = '';
                $data[$cnt]['writable'] = "no";
                $data[$cnt]['drivepath'] = $all_devices[$i]['path'];
                $data[$cnt]['image'] = "images/selectsource_icon_harddisk.png";
                $data[$cnt]['jukebox'] = 0;
            }
            $data[$cnt]['type'] = "local";
            $cnt++;
        }
        }
        $devices['machine'] = "NMT";
        $devices['data'] = $data;
        $devices['status'] = 'success';
        $devices['message'] = '';
        print_r(json_encode($devices));
        }
        else
            print_r('{"data":[]}');
    } else if ($type == "network") {
        if (is_array($json_parser)) {
        $all_devices = $json_parser['response']['fileList']['file'];
        $cnt=0;
        for($i=0;$i<count($all_devices);$i++){
            if ($all_devices[$i]['device_type'] == 'nfs' || $all_devices[$i]['device_type'] == 'samba') {
                $data[$cnt]['name'] = $all_devices[$i]['name'];
                $data[$cnt]['path'] = $all_devices[$i]['path'];
                $data[$cnt]['image'] = "images/selectsource_icon_network_shared.png";
                $data[$cnt]['type'] = "network";
                $data[$cnt]['device_type'] = $all_devices[$i]['device_type'];
                $cnt++;
        }
        }
        $devices['machine'] = "NMT";
        $devices['data'] = $data;
        $devices['status'] = 'success';
        $devices['message'] = '';
        print_r(json_encode($devices));
        }
        else
            print_r('{"data":[]}');
    }
    }
    else {
        $devices['status'] = 'error';
        if ($json_parser['returnValue'] == 901)
          $devices['message'] = 'Invalid argument';
        else if ($json_parser['returnValue'] == 902)
          $devices['message'] = 'Internal failure';
        else if ($json_parser['returnValue'] == 903)
          $devices['message'] = 'Out of memory';
        else if ($json_parser['returnValue'] == 904)
          $devices['message'] = 'Fail to resolve hostname, server appears to be offline';
        else if ($json_parser['returnValue'] == 905)
          $devices['message'] = 'Share no longer exist';
        else if ($json_parser['returnValue'] == 906)
          $devices['message'] = 'Please retry';
        else if ($json_parser['returnValue'] == 907)
          $devices['message'] = 'Server is busy, unable to access now';
        else if ($json_parser['returnValue'] == 908)
          $devices['message'] = 'Unable login to target server, please retry';
        else if ($json_parser['returnValue'] == 909)
          $devices['message'] = 'Unable access to server, please check your server setup';
        else if ($json_parser['returnValue'] == 910)
          $devices['message'] = 'User/password required';
        else if ($json_parser['returnValue'] == 911)
          $devices['message'] = 'I/O error';
        else if ($json_parser['returnValue'] == 912)
          $devices['message'] = 'Host is unreachable';
        else if ($json_parser['returnValue'] == 913)
          $devices['message'] = 'No domain master browser';
        else if ($json_parser['returnValue'] == 914)
          $devices['message'] = 'No local master browser';
        else if ($json_parser['returnValue'] == 915)
          $devices['message'] = 'No workgroup list';
        else if ($json_parser['returnValue'] == 916)
          $devices['message'] = 'No server list';
        else if ($json_parser['returnValue'] == 917)
          $devices['message'] = 'No share list';
        else if ($json_parser['returnValue'] == 918)
          $devices['message'] = 'No more free mount point for new mount/access request';
    }
    }
    else {
        $files = scandir(".");
        $cnt=0;
        for($i=0;$i<count($files);$i++){
            if ($files[$i] != '.' && $files[$i] != '..' && (is_link($files[$i]) || is_dir($files[$i]))) {
            if (file_exists($files[$i] . "/nmj_database/media.db")) {
                $data[$cnt]['name'] = $files[$i];
                $data[$cnt]['dbpath'] = $files[$i] . "/nmj_database/media.db";
                if (is_writable($data[$cnt]['dbpath']))
                    $data[$cnt]['writable'] = "yes";
                else
                    $data[$cnt]['writable'] = "no";
                $data[$cnt]['drivepath'] = $files[$i];
                $data[$cnt]['image'] = "images/selectsource_icon_harddisk_jukebox.png";
                $data[$cnt]['jukebox'] = 1;
                $data[$cnt]['type'] = "local";
            }
            else {
                $data[$cnt]['name'] = $files[$i];
                $data[$cnt]['dbpath'] = '';
                $data[$cnt]['writable'] = "no";
                $data[$cnt]['drivepath'] = $files[$i];
                $data[$cnt]['image'] = "images/selectsource_icon_harddisk.png";
                $data[$cnt]['jukebox'] = 0;
                $data[$cnt]['type'] = "local";
            }
            $cnt++;
         }
         }
            $devices['machine'] = "";
            $devices['data'] = $data;
            print_r(json_encode($devices));
    }
} else if (isset($_GET['action']) && $_GET['action'] == 'playMedia') {
        if (isset($_GET['media']))
            $media = $_GET['media'];
        if (isset($_GET['type']))
            $type = $_GET['type'];
        if (isset($_GET['time']))
            $time = $_GET['time'];
        if ($time == 0)
            $time = '';
        $APIURL = '';
        if ($type == "movie") {
            $movies = explode("#", $media);
            if (count($movies) == 1) {
                $APIURL = " 'http://127.0.0.1:8008/playback?arg0=start_vod&arg1=MyMovieFile&arg2=" . $movies[0] . "&arg3=show&arg4=" . $time . "&arg5=0&arg6=enable' ";
            } else {
                for ($h = 0; $h < count($movies); $h++)
                    $APIURL = $APIURL . " 'http://127.0.0.1:8008/playback?arg0=insert_vod_queue&arg1=MyMovieFile&arg2=" . $movies[$h] . "&arg3=show&arg4=' ";
            }
        } else {
            $music = explode("#", $media);
            if (count($music) == 1)
                $APIURL = " 'http://127.0.0.1:8008/playback?arg0=start_aod&arg1=MyAudioFile&arg2=" . $music[0] . "&arg3=show&arg4=disable' ";
            else {
                for ($h = 0; $h < count($music); $h++)
                    $APIURL = $APIURL . " 'http://127.0.0.1:8008/playback?arg0=insert_aod_queue&arg1=MyAudioFile&arg2=" . $music[$h] . "&arg3=show' ";
            }
        }
        $current = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- 'http://127.0.0.1:8008/playback?arg0=stop_vod'");
        $current = shell_exec("export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- 'http://127.0.0.1:8008/playback?arg0=stop_aod'");
        $url = "export LD_LIBRARY_PATH=/opt/syb/sigma/lib:/lib;wget -qO- " . $APIURL;
        $xml_data = shell_exec($url);
        $xml = simplexml_load_string($xml_data);
        $json = json_encode($xml);
        $json_parser = json_decode($json, TRUE);
        print_r('{"data":[]}');
    //return ($json_parser['returnValue']);

}
?>
