#!/bin/sh

INSTALL_ROOT=/share/Apps/NMJManager
PATH=$INSTALL_ROOT/bin:$INSTALL_ROOT/sbin:$PATH
NAME=lighttpd
DESC="NMJManager Web Server"
DAEMON=$INSTALL_ROOT/sbin/$NAME
LIGHTTPD_MODULES=$INSTALL_ROOT/lib/$NAME/
DAEMON_OPTS="-f $INSTALL_ROOT/etc/$NAME/$NAME.conf"
PIDDIR=/var/log/$NAME
LANG="en_US.UTF-8";export LANG

test -x $DAEMON || exit 0

start() {
    if [ ! -d $PIDDIR ]; then
      mkdir -p $PIDDIR
      chmod 777 $PIDDIR
    fi

    cd $INSTALL_ROOT
    LD_PRELOAD=/lib/libpthread.so.0 $DAEMON $DAEMON_OPTS -m $LIGHTTPD_MODULES
}

stop() {
    pkill -f NMJManager/sbin/lighttpd
    sleep 1
    if [ -d $PIDDIR ]; then
      rm -rf $PIDDIR
    fi
}

case "$1" in
    start)
        echo "Starting $DESC" "$NAME"
        start
        exit $?
        ;;
    stop)
        echo "Stopping $DESC" "$NAME"
        stop
        exit $?
        ;;
    restart)
        # disable appinit webserver_enable/disable
        # by using the false executable instead
        stop
        sleep 1
        start
        ;;
    *)
        echo "Usage: $0 {start|stop|restart}" >&2
        exit 1
        ;;
esac
