#!/bin/sh
#
# MiniDLNA initscript
#
# Based on the mediatomb debian package.

unset USER

# PATH should only include /usr/* if it runs after the mountnfs.sh script
INSTALL_ROOT=/share/Apps/MiniDLNA
PATH=${INSTALL_ROOT}/bin:${INSTALL_ROOT}/sbin:/bin:/sbin:/usr/bin:/usr/sbin;export PATH
DESC="MiniDLNA/UPnP-AV media server"
NAME=minidlnad
DAEMON=${INSTALL_ROOT}/sbin/${NAME}
PIDFILE=/var/run/$NAME.pid
CONFIGFILE=${INSTALL_ROOT}/config/${NAME}.conf

# Set the default log file
if [ -z $LOGFILE ]; then
	LOGFILE=/var/log/${NAME}.log
fi

DAEMON_ARGS="-f $CONFIGFILE -P $PIDFILE $DAEMON_OPTS"

#
# Function that starts the daemon/service
#
do_start()
{
	# Return
	#   0 if daemon has been started
	#   1 if daemon was already running
	#   2 if daemon could not be started

	start-stop-daemon -S --quiet --pidfile $PIDFILE \
		--chuid $USER:$GROUP --exec $DAEMON -- \
		$DAEMON_ARGS \
		|| return 2
}

#
# Function that stops the daemon/service
#
do_stop()
{
	# Return
	#   0 if daemon has been stopped
	#   1 if daemon was already stopped
	#   2 if daemon could not be stopped
	#   other if a failure occurred
	start-stop-daemon -K --quiet --pidfile $PIDFILE --exec $DAEMON
	RETVAL="$?"
	[ "$RETVAL" = 2 ] && return 2
	# Wait for children to finish too if this is a daemon that forks
	# and if the daemon is only ever run from this initscript.
	start-stop-daemon -K --quiet --oknodo --exec $DAEMON
	[ "$?" = 2 ] && return 2
	# Many daemons dont delete their pidfiles when they exit.
	rm -f $PIDFILE
	return "$RETVAL"
}

case "$1" in
  start)
    [ "$VERBOSE" != no ] && echo "Starting $DESC " "$NAME"
    do_start
    case "$?" in
		0|1) [ "$VERBOSE" != no ] && exit 0 ;;
		2) [ "$VERBOSE" != no ] && exit 1 ;;
	esac
  ;;
  stop)
	[ "$VERBOSE" != no ] && echo "Stopping $DESC" "$NAME"
	do_stop
	case "$?" in
		0|1) [ "$VERBOSE" != no ] && exit 0 ;;
		2) [ "$VERBOSE" != no ] && exit 1 ;;
	esac
	;;
  restart|force-reload)
	echo "Restarting $DESC" "$NAME"
	do_stop
	case "$?" in
	  0|1)
		if [ "$1" = "force-reload" ]; then
			# Rescan the collection
			DAEMON_ARGS="$DAEMON_ARGS -R"
		fi
		do_start
		case "$?" in
			0) exit 0 ;;
			1) exit 1 ;; # Old process is still running
			*) exit 1 ;; # Failed to start
		esac
		;;
	  *)
	  	# Failed to stop
		exit 1
		;;
	esac
	;;
  *)
	echo "Usage: $0 {start|stop|restart|force-reload}" >&2
	exit 3
	;;
esac
