#!/bin/sh

BASEDIR=/share/Apps/MediaTomb
NAME=mediatomb
USER=nmt
GROUP=nmt
PIDFILE=/var/run/$NAME.pid
LOGFILE=$BASEDIR/$NAME.log
DAEMON_ARGS="-c $BASEDIR/config/mediatomb.xml -d -u $USER -g $GROUP -P $PIDFILE -l $LOGFILE"
DAEMON=$BASEDIR/bin/$NAME

start()
{	
    if [ -n "`ps | grep '$DAEMON' | grep -v 'grep'`" ]; then
        #don't start it twice
	    echo "MediaTomb CSI already running"
        exit 0
    fi
	
    chown -R nmt $BASEDIR

    $BASEDIR/bin/start-stop-daemon --start --quiet --pidfile $PIDFILE --exec $DAEMON  \
	-- $DAEMON_ARGS 
}

stop()
{	
    $BASEDIR/bin/start-stop-daemon --stop --quiet --retry=TERM/30/KILL/5 --pidfile $PIDFILE --name $NAME
}

case "$1" in
	start)
	start
	;;

	stop)
	stop
	;;

	restart)
	stop
	sleep 1
	start
esac
