#!/bin/sh

LOCAL=/share/Apps/local
NAME=deluge-web
OPKG=$LOCAL/bin/opkg
LD_LIBRARY_PATH=/share/Apps/local/lib:/usr/local/lib:/opt/syb/sigma/lib:/opt/syb/app/lib:/nmt/apps/lib:/lib;export LD_LIBRARY_PATH

install()
{	
    if [ -d "/nmt/apps" ];then
        dir="/nmt/apps"
    elif [ -d "/nmt/syb8634" ];then
        dir="/mnt/syb8634"
    else 
        echo "Unknown NMT."
        exit 1
    fi

    if [ -d /opt/gaya ]; then
        MODEL=a110
    else
        CHIPSET=`/opt/syb/sigma/bin/gbus_read_uint32 0x0002fee8 2>&-`
        if [ $CHIPSET = "0x00008911" ];then
            MODEL=a400
        elif [ $CHIPSET = "0x00008647" -o $CHIPSET = "0x00008643" ];then
            MODEL=c200
        elif [ $CHIPSET = "0x00008757" ];then
            MODEL=vten
        fi
    fi

    if [ ! -f $OPKG ]; then
        cd /share
        echo "Downloading opkg_${MODEL}_latest.zip"
        wget -q http://sourceforge.net/projects/nmtcsi/files/opkg_${MODEL}_latest.zip
        if [ -f opkg_${MODEL}_latest.zip ];then
            echo "Extracting opkg_${MODEL}_latest.zip"
            unzip opkg_${MODEL}_latest.zip
        else
            echo "Error: Can't find opkg_${MODEL}_latest.zip"
            exit
        fi
        if [ -f opkg.tar ];then
            echo "Installing opkg_${MODEL}_latest.zip"
            /share/Apps/AppInit/appinit.cgi install opkg.tar
            rm opkg.tar opkg_${MODEL}_latest.zip
        else
            echo "Error: Can't find opkg.tar"
            exit
        fi
    fi

    if [ -f $OPKG ];then
        if [ -f $LOCAL/bin/$NAME ];then
            echo "Removing existing $NAME"
            $OPKG remove $NAME -force-depends -V0
        fi
        echo "Updating oPKG list..."
        $OPKG update -V0
        echo "Installing $NAME"
        $OPKG install $NAME -force-overwrite -force-reinstall -V0
    else
        echo "Cannot install opkg automatically."
        exit 1
    fi
}

uninstall()
{
    if [ -d "/nmt/apps" ];then
        dir="/nmt/apps"
    elif [ -d "/nmt/syb8634" ];then
        dir="/mnt/syb8634"
    else 
        echo "Unknown NMT."
        exit 1
    fi

    $OPKG remove $NAME -V0
}


case "$1" in
    install)
    install
    ;;
    
    uninstall)
    uninstall
    ;;
esac
