#!/bin/sh

LOCAL=/share/Apps/local
NAME=deluged

if [ -f "/bin/busybox" ];then
BUSYBOX="/bin/busybox"
elif [ -f "/bin/busybox_org" ];then
BUSYBOX="/bin/busybox_org"
fi

is_nmt100() {
    [ -f /mnt/syb8634/MIN_FIRMWARE_VER ]
}
is_nmt200() {
    [ -f /nmt/apps/MIN_FIRMWARE_VER ]
}

if is_nmt200; then
    dir="/nmt/apps"
elif is_nmt100; then
    dir="/mnt/syb8634"
else
    echo "Unknown NMT."
    exit 1
fi

start()
{	
    if [ -f $LOCAL/etc/init.d/$NAME ];then
        $LOCAL/etc/init.d/$NAME start
    elif [ -f /share/Apps/Deluge/setup.sh ];then
        /share/Apps/Deluge/setup.sh install
        $LOCAL/etc/init.d/$NAME start
    fi
}

stop()
{	
    if [ -f $LOCAL/etc/init.d/$NAME ];then
        $LOCAL/etc/init.d/$NAME stop
    fi

}

case "$1" in
	start)
	start
	;;

	stop)
	stop
	;;

	restart)
	stop
	$SLEEP 1
	start
esac
