#!/bin/sh

bind_mount()
{
    mount -o bind /proc /share/Apps/debian/proc
    mount -o bind /dev/pts /share/Apps/debian/dev/pts
    mount -o bind /sys /share/Apps/debian/sys 
    mount -o bind /share /share/Apps/debian/share
    echo "Done<br>"
}

remove_mount()
{
    umount /share/Apps/debian/proc
    umount /share/Apps/debian/dev/pts
    umount /share/Apps/debian/sys 
    umount /share/Apps/debian/share
    echo "Done<br>"
}

fix_permissions()
{
    /usr/sbin/chroot /share/Apps/debian /bin/bash -c "/usr/bin/setfacl --restore=/permissions.acl"
}

start_init_d()
{
    cd /share/Apps/debian/etc/rc2.d
    for script in `ls S*`
    do
    /usr/sbin/chroot /share/Apps/debian /bin/bash -c "/etc/rc2.d/${script} start"
    done
}

stop_init_d()
{
    cd /share/Apps/debian/etc/rc2.d
    for script in `ls S*`
    do
    /usr/sbin/chroot /share/Apps/debian /bin/bash -c "/etc/rc2.d/${script} stop"
    done
}

case "$1" in
    start)
    bind_mount;
    fix_permissions;
    start_init_d;
    ;;
    
    stop)
    stop_init_d;
    remove_mount;
    exit
    ;;
    
    restart)
    stop
    sleep 2
    start
    ;;
esac
