#!/nmt/apps/server/php
<?php

	$cwd = dirname(dirname(__FILE__));
	$config = parse_ini_file($cwd . "/config.ini", true);
	$drive = "HARD_DISK";
	
	if (file_exists('/opt/sybhttpd/localhost.drives/HARD_DISK')) {
		    $drive = "HARD_DISK";
		} elseif (file_exists('/opt/sybhttpd/localhost.drives/SATA_DISK')) {
		    $drive = "SATA_DISK";
		} elseif (file_exists('/opt/sybhttpd/localhost.drives/USB_DRIVE')) {
		    $drive = "USB_DRIVE";
	}

	if ($_SERVER['argc'] == 2 && $_SERVER['argv'][1] == 'start') {
		copy("/tmp/netshare", "/share/Apps/NetworkMounter/netshare");
		echo "Mounting network shares...\n";

		while (list(,$share) = each($config)) {
			mountShare($share, $drive);

	    }
	}

	if ($_SERVER['argc'] == 2 && $_SERVER['argv'][1] == 'stop') {
		echo "Unmounting network shares...\n";

		while (list(,$share) = each($config)) {
			unmountShare($share);
		}
		exec("mv -f /share/Apps/NetworkMounter/netshare /tmp/");
	}


	function unmountShare($share) {
		if (!isset($share['share']) || $share['share'] == '') {
			return;
		}


		if (!isset($share['path']) || $share['path'] == '') {
			return;
		}

		// Minimal required settings are provided... build our command
		$command = "/bin/umount ";

		$command .= $share['path'] . ' ';

		echo "Unmounting " . $share['share'] . " from " . $share['path'] . "\n";

		$remdir = "rm -R  " . $share['path'] . ' ';

		exec($command);
	}

	function mountShare($share, $drive) {

		if (!isset($share['share']) || $share['share'] == '') {
			return;
		}


		if (!isset($share['path']) || $share['path'] == '') {
			return;
		}

		// Minimal required settings are provided... build our command
		if ($share['type'] == 'cifs' && (file_exists('/opt/syb/app/sbin/mount.cifs'))) {
		    $command = "/opt/syb/app/sbin/mount.cifs ";
		}else{
		    $command = "/bin/mount "."-t " . $share['type'] . ' ';
		}

		$command .= $share['share'] . ' ';
		$command .= $share['path'] . ' ';


		// Build our options
		$options = array();

		if ((isset($share['inlist']) && $share['inlist'] != '') && $share['filter'] != '') {
			if ($share['filter'] == 'index') {
				$netshare = "echo 'file:///opt/sybhttpd/localhost.images/hd/list_workgrp.png\n" . substr_replace($share['path'], 'http://localhost.drives:8883/' . $drive . '/', 0, 7) . "/index.htm" . "\n" . $share['inlist'] . "' >> /tmp/netshare" . "\n";
			} else {
				$netshare = "echo 'file:///opt/sybhttpd/localhost.images/hd/list_workgrp.png\n" . substr_replace($share['path'], 'http://localhost.drives:8883/' . $drive . '/', 0, 7) . "/?filter=" . $share['filter'] . "\n" . $share['inlist'] . "' >> /tmp/netshare" . "\n";
			}
		} elseif ((isset($share['inlist']) && $share['inlist'] != '') && $share['filter'] == '') {
			$netshare = "echo 'file:///opt/sybhttpd/localhost.images/hd/list_workgrp.png\n" . substr_replace($share['path'], 'http://localhost.drives:8883/' . $drive . '/', 0, 7) . "\n" . $share['inlist'] . "' >> /tmp/netshare" . "\n";
		}

		if (isset($share['user']) && $share['user'] != '') {
			$options[] = "user=" . $share['user'];
		}

		if (isset($share['password']) && $share['password'] != '') {
			$options[] = "password=" . $share['password'];
		}

		if (isset($share['options']) && $share['options'] != '') {
			$options[] = $share['options'];
		}

		if (count($options)) {
			$command .= '-o ' . implode(",", $options) . ' ';
		}

		$mkmdir = "mkdir -p  " . $share['path'] . ' ';

		if (isset($share['inlist']) && $share['inlist'] != '') {
			exec($netshare);
		}

		exec($mkmdir);
		echo "$command" . "\n";
		exec($command);
		if (isset($share['autoboot']) && $share['autoboot'] != '') {
			if (file_exists('/share/.home/user.phf')) {
				rename("/share/.home/index.phf", "/share/.home/index.bak");
				rename("/share/.home/user.phf", "/share/.home/index.phf");
				$command = 'wget -O /dev/null "http://127.0.0.1:8008/system?arg0=load_phf&arg1=' . $share['autoboot'] . '&arg2="';
				exec ( "echo . | ".$command);
				sleep(10);
			}else{
				copy($share['autoboot'], '/share/.home/user.phf');
			}
			$plorp = substr(strrchr($share['autoboot'],'/'), 1);
			$newline1 = "cd " . substr($share['autoboot'], 0, - strlen($plorp));
			$newline2 = "/share/Apps/AppInit/appinit.cgi restart NetworkMounter";
			$key = 'exit 0';
			$file = "/share/start_app.sh";
			$check = file_get_contents($file);
			if (!strpos($check, $newline2) && (!strpos($check, $newline1))){
				echo "Doing all doing replace\n";
				echo $newline1."\n";
				$newfile = "/share/filetemp.txt";
				copy($file, $newfile) or exit("failed to copy $file");
				$fc = fopen ($file, "r");
				while (!feof ($fc)) {
					$buffer = fgets($fc, 4096);
					$lines[] = $buffer;
				}
				fclose ($fc);
				$f=fopen($newfile,"w") or die("couldn't open $file");
				foreach($lines as $line){
					if (strstr($line,$key)){
						fwrite($f,$newline1."\n".$newline2."\n");
					}
					fwrite($f,$line);
				}
				fclose($f);
				copy($newfile, $file) or exit("failed to copy $newfile");
			}elseif (!strpos($check, $newline2) || (!strpos($check, $newline1))){
			    echo "doing replace\n";
				echo $newline1."\n";
				$newfile = "/share/filetemp.txt";
				copy($file, $newfile) or exit("failed to copy $file");
				$fc = fopen ($file, "r");
				while (!feof ($fc)) {
					$buffer = fgets($fc, 4096);
					$lines[] = $buffer;
				}
				fclose ($fc);
				$f=fopen($newfile,"w") or die("couldn't open $file");
				foreach($lines as $line){
					if (strstr($line,'#M_A_R_K_E_R_do_not_remove_me')){
						fwrite($f,$line);
						fwrite($f,$newline1."\n".$newline2."\n".$key."\n");
						break 1;
					}
					fwrite($f,$line);
				}
				fclose($f);
				copy($newfile, $file) or exit("failed to copy $newfile");
			}
			if (file_exists('/share/.home/index.bak')) {
			    rename("/share/.home/index.phf", "/share/.home/user.phf");
			    rename("/share/.home/index.bak", "/share/.home/index.phf");
			}
		}
}